"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AnimatedCrossView;
var _react = require("react");
var _reactNative = require("react-native");
var _reactNativePaper = require("react-native-paper");
var _styles = require("../shared/styles");
var _jsxRuntime = require("react/jsx-runtime");
function AnimatedCrossView({
  collapsed,
  calendar,
  calendarEdit
}) {
  const theme = (0, _reactNativePaper.useTheme)();
  const calendarOpacity = (0, _react.useRef)(new _reactNative.Animated.Value(collapsed ? 1 : 0));
  (0, _react.useEffect)(() => {
    _reactNative.Animated.timing(calendarOpacity.current, {
      toValue: collapsed ? 1 : 0,
      duration: 250,
      useNativeDriver: true
    }).start();
  }, [collapsed]);
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
    style: _styles.sharedStyles.root,
    children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.Animated.View, {
      pointerEvents: collapsed ? 'auto' : 'none',
      style: [_styles.sharedStyles.root, {
        opacity: calendarOpacity.current,
        transform: [{
          scaleY: calendarOpacity.current.interpolate({
            inputRange: [0, 1],
            outputRange: [0.85, 1]
          })
        }, {
          scaleX: calendarOpacity.current.interpolate({
            inputRange: [0, 1],
            outputRange: [0.95, 1]
          })
        }]
      }],
      children: calendar
    }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.Animated.View, {
      pointerEvents: collapsed ? 'none' : 'auto',
      style: [styles.calendarEdit, {
        backgroundColor: theme.colors.surface,
        opacity: calendarOpacity.current.interpolate({
          inputRange: [0, 1],
          outputRange: [1, 0]
        }),
        transform: [{
          scale: calendarOpacity.current.interpolate({
            inputRange: [0, 1],
            outputRange: [1, 0.95]
          })
        }]
      }],
      children: calendarEdit
    })]
  });
}
const styles = _reactNative.StyleSheet.create({
  calendarEdit: {
    position: 'absolute',
    left: 0,
    right: 0
  }
});
//# sourceMappingURL=AnimatedCrossView.js.map