// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.firebase.messaging;

public class Task<T> {
    private final T result;
    private final Exception exception;

    public Task(T result) {
        this.result = result;
        this.exception = null;
    }

    public Task(Exception exception) {
        this.result = null;
        this.exception = exception;
    }

    public boolean isSuccessful() {
        return exception == null;
    }

    public Exception getException() {
        return exception;
    }

    public T getResult() {
        if (exception != null) {
            throw new RuntimeException(exception);
        }
        return result;
    }

    public Task<T> addOnCompleteListener(OnCompleteListener<T> listener) {
        listener.onComplete(this);
        return this;
    }

    public interface OnCompleteListener<T> {
        void onComplete(Task<T> task);
    }
}

