"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var json_exports = {};
__export(json_exports, {
  SingleStoreJson: () => SingleStoreJson,
  SingleStoreJsonBuilder: () => SingleStoreJsonBuilder,
  json: () => json
});
module.exports = __toCommonJS(json_exports);
var import_entity = require("../../entity.cjs");
var import_common = require("./common.cjs");
class SingleStoreJsonBuilder extends import_common.SingleStoreColumnBuilder {
  static [import_entity.entityKind] = "SingleStoreJsonBuilder";
  constructor(name) {
    super(name, "json", "SingleStoreJson");
  }
  /** @internal */
  build(table) {
    return new SingleStoreJson(
      table,
      this.config
    );
  }
}
class SingleStoreJson extends import_common.SingleStoreColumn {
  static [import_entity.entityKind] = "SingleStoreJson";
  getSQLType() {
    return "json";
  }
  mapToDriverValue(value) {
    return JSON.stringify(value);
  }
}
function json(name) {
  return new SingleStoreJsonBuilder(name ?? "");
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SingleStoreJson,
  SingleStoreJsonBuilder,
  json
});
//# sourceMappingURL=json.cjs.map