Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _requireResolve = require('require-resolve');

var _requireResolve2 = _interopRequireDefault(_requireResolve);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var BabelInlineImportHelper = function () {
  function BabelInlineImportHelper() {
    _classCallCheck(this, BabelInlineImportHelper);
  }

  _createClass(BabelInlineImportHelper, null, [{
    key: 'shouldBeInlined',
    value: function shouldBeInlined(givenPath, extensions) {
      var accept = typeof extensions === 'string' ? [extensions] : extensions || BabelInlineImportHelper.extensions;

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = accept[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var extension = _step.value;

          if (givenPath.endsWith(extension)) {
            return true;
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return false;
    }
  }, {
    key: 'getContents',
    value: function getContents(givenPath, reference) {
      if (!reference) {
        throw new Error('"reference" argument must be specified');
      }

      var mod = (0, _requireResolve2.default)(givenPath, _path2.default.resolve(reference));

      if (!mod || !mod.src) {
        throw new Error('Path \'' + givenPath + '\' could not be found for \'' + reference + '\'');
      }

      return _fs2.default.readFileSync(mod.src).toString();
    }
  }, {
    key: 'transformRelativeToRootPath',
    value: function transformRelativeToRootPath(path, rootPathSuffix) {
      if (this.hasRoot(path)) {
        var withoutRoot = path.substring(1, path.length);
        return '' + BabelInlineImportHelper.root + (rootPathSuffix || '') + '/' + withoutRoot;
      }
      if (typeof path === 'string') {
        return path;
      }
      throw new Error('ERROR: No path passed');
    }
  }, {
    key: 'hasRoot',
    value: function hasRoot(string) {
      if (typeof string !== 'string') {
        return false;
      }

      return string.substring(0, 1) === '/';
    }
  }]);

  return BabelInlineImportHelper;
}();

BabelInlineImportHelper.extensions = ['.raw', '.text', '.graphql'];
BabelInlineImportHelper.root = global.rootPath || process.cwd();
exports.default = BabelInlineImportHelper;