require "json"

package = JSON.parse(File.read(File.join(__dir__, "package.json")))

Pod::Spec.new do |s|
  s.name         = "ReactNativeFs"
  s.version      = package["version"]
  s.summary      = package["description"]
  s.homepage     = package["homepage"]
  s.license      = package["license"]
  s.authors      = package["author"]

  s.platforms    = { :ios => min_ios_version_supported, :osx => "10.13" }
  s.source       = { :git => "https://github.com/birdofpreyru/react-native-fs.git", :tag => "#{s.version}" }

  s.resource_bundles = { 'RNFS_PrivacyInfo' => 'ios/PrivacyInfo.xcprivacy' }
  s.frameworks = "AVFoundation", "Photos"
  s.source_files = "ios/**/*.{h,m,mm,cpp}"

  # Necessary for background downloads to work,
  # see: https://github.com/birdofpreyru/react-native-fs/issues/114
  # NOTE: Not sure if we can keep the private_header_files value (it comes
  # from the library scaffolding generated by create-react-native-library tool),
  # for now it is commented out, as that is what is proven to work in the issue
  # referenced above).
  # s.private_header_files = "ios/**/*.h"
  s.public_header_files = "ios/RNFSBackgroundDownloads.h"

  install_modules_dependencies(s)
end
