/**
 * Attempts to perform the given async `action` up to `maxRetries` times with
 * the specified `interval`, stopping at the first successful (non-throwing)
 * execution.
 * @param action
 * @param maxRetries Optional. The maximum number of re-tries. Defaults 3.
 * @param interval Optional. The interval between re-tries (in milliseconds).
 *  Defaults to 300ms.
 * @returns Resolves to the result of the successful `action` execution;
 *  or rejects with the error from the last faileda attempt.
 */
export default function withRetries<T>(action: () => T, maxRetries?: number, interval?: number): Promise<Awaited<T>>;
