import Barrier, { type Executor } from './Barrier';
export declare const SEC_MS = 1000;
export declare const MIN_MS = 60000;
export declare const HOUR_MS = 3600000;
export declare const DAY_MS = 86400000;
export declare const YEAR_MS = 31536000000;
export declare class Timer<T> extends Barrier<void, T> {
    private pAbort;
    private pTimeout?;
    get abort(): () => void;
    get timeout(): number | undefined;
    /**
     * Creates a new, non-initialized instance of Timer. Call .init() method
     * to actually initialize and launch the timer.
     *
     * NOTE: Although it might be tempting to accept `timeout` value as
     * a constructor's argument, it won't work well, because Timer is an
     * extension of Promise (via Barrier), and the way Promises works (in
     * particular their .then() method, which internally calls constructor()
     * with special executor) does not play along with initalization depending
     * on custom parameters done in constructor().
     *
     * @param executor
     */
    constructor(executor?: Executor<T>);
    init(timeout: number): this;
    then<TR1, TR2>(onFulfilled?: ((value: T) => TR1 | PromiseLike<TR1>) | null, onRejected?: ((reason: unknown) => TR2 | PromiseLike<TR2>) | null): Timer<TR1 | TR2>;
}
/**
 * Creates a Promise, which resolves after the given timeout.
 * @param {number} timeout Timeout [ms].
 * @return {Barrier} Resolves after the timeout. It has additional
 *  .abort() method attached, which cancels the pending timer resolution
 *  (without resolving or rejecting the barrier).
 */
export declare function timer(timeout: number): Timer<void>;
