/**
 * Implements a simple semaphore for async code logic.
 */
export default class Semaphore {
    constructor(ready?: boolean);
    get ready(): boolean;
    setReady(ready: boolean): void;
    /**
     * Waits until the semaphore is ready, and marks it as non-ready (seizes it).
     */
    seize(): Promise<void>;
    waitReady(seize?: boolean): Promise<void>;
    /**
     * If semaphore is ready, it releases the next barrier in the queue, if any,
     * and reschedules itself for a call in the next event loop iteration.
     * Otherwise, it breaks the queue draining loop, which will be restarted
     * the next time the semaphore is set ready.
     */
    pDrainQueue(): Promise<void>;
    private pDraining;
    private pDrainLock;
    private pQueue;
    private pReady;
}
