export type Listener<T extends unknown[] = unknown[]> = (...args: T) => void;
/**
 * Simple listeneable data Emitter.
 */
export declare class Emitter<T extends unknown[] = unknown[]> {
    private pListeners;
    /**
     * Returns "true" if any listener is connected; "false" otherwise.
     * @return {boolean}
     */
    get hasListeners(): boolean;
    get listeners(): ReadonlyArray<Listener<T>>;
    /**
     * Adds `listener` if it is not already connected.
     * @param {function} listener
     * @return {function} Unsubscribe function.
     */
    addListener(listener: Listener<T>): () => void;
    /**
     * Calls every connected listener with the given arguments.
     * @param args
     */
    emit(...args: T): void;
    /**
     * Removes all connected listeners.
     */
    removeAllListeners(): void;
    /**
     * Removes specified `listener`, if connected.
     * @param listener
     */
    removeListener(listener: Listener<T>): void;
}
