type CachedT<T> = [T, number];
type TimestampedPromise<T> = Promise<T> & {
    timestamp: number;
};
type EntryT<T> = CachedT<T> | TimestampedPromise<CachedT<T>>;
export declare class Cached<T> {
    readonly maxage: number;
    private getter;
    private pData;
    private pOldestTimestamp;
    /** For test use only. */
    get data(): Readonly<Record<string, EntryT<T>>>;
    /** For test use only. */
    get oldestTimestamp(): number;
    constructor(maxage: number, getter: (id: string) => T | Promise<T>);
    /** Removes stale items from the cache, and updates .oldestTimestamp. */
    private cleanCache;
    /**
     * Adds entry to the cache.
     * NOTE: It assumes entry's timestamp is the current moment (for the cache
     * cleaning purposes; if it is not, but it is a past timestamp, nothing bad
     * will happen, just some cleaning operation will be skipped).
     */
    private setEntry;
    /** Adds `datum` to the cache, and removes stale items from the cache. */
    private set;
    /**
     * Retrieves envelope of the specified datum, either read from the cache,
     * or retrieved using the getter provided at construction time.
     */
    private getEntry;
    /** Gets item. */
    get(id: string, forceRefresh?: boolean): T | Promise<T>;
}
export {};
