
# Online Sources of Puzzles

Many crossword compilers and fans host web pages where puzzles can be
downloaded. Below is a list of sources known to Forkyz. Please [raise an
issue on the GitLab page][issues] if you would like to add a source or
make a correction.

There are two ways to get crosswords from the web: sharing a web page or downloading supported files.

## Websites Supported by Sharing

For the websites below, open a puzzle page in your browser, then use the "share" function to share the page with Forkyz.

* [Crossword Nexus][jonesin] -- any site embedding [Crossword Nexus][crosswordnexus] puzzles, for example the Jonesin crossword.
* [Everyman Crossword][everyman] -- Sunday Everyman puzzle in the Observer (and possibly other Observer puzzles).
* [Hamburger Abendblatt][hamburgerabendblatt] -- daily crossword from the Hamburger Abendblatt.
* [Irish News Crosswords][irishnews] -- daily quick and cryptic crosswords (sudoku not supported).
* [Metro Crosswords][metro] -- daily quick and cryptic crosswords (sudoku not supported).
* [Seattle Times][seattletimes] -- Seattle Times NY Times crossword.
* [Telegraaf Kruiswoordpuzzels][telegraaf] -- daily crossword from De Telegraaf.
* [The Guardian][guardian] -- a selection of daily/weekly crosswords from The Guardian.
* [mycrossword.co.uk][mycrosswordcouk] -- crowd-sourced crossword community.

## Websites with File Downloads

Forkyz will attempt to open any file you give it, but look out for
Across Lite (.puz) or JPZ in particular. IPuz support is partial and
aims to cover block and bar puzzles.

The majority of the links on this page come from [Michael F. Gill
(Mokelfish)'s list of puzzles][mokelfish].

* [arctan(x)words][arctan-x-words] -- by Christopher Adams.
* [Andrew Marc Greene][andrew-marc-greene] -- some puzzles have PUZ links.
* [Aries Puzzles][aries-puzzles] -- monthly puzzles by Andrew Ries. Rows gardens, marching bands, twists and turns, &c.
* [AV Club Xwords][avcx] -- almost daily crosswords and cryptics, requires subscription, free samples available.
* [Avid Puzzler][avid-puzzler] -- by David Gold.
* [Beneath the Surface][beneath-the-surface] -- by Kyle Dolan.
* Big Dave's [Monthly Prize][big-dave-monthly], [Weekly Non-Prize][big-dave-weekly], [Rookie Corner][big-dave-rookie], and [Special Puzzles][big-dave-special].
* [Brendan Emmet Quigley][beq] -- custom puzzle creator, releasing some puzzles online.
* [CommuniCrossings][communicrossings] -- homepage of Steve Weyer.
* [Crosshare][crosshare] -- ad-free, open-source crossword puzzles.
* [Crossweird Puzzles][crossweird] -- independent puzzles.
* [Crosswords Schmosswords][crosswords-schmosswords] -- by Kate Schmate.
* [Crossword Nexus][crosswordnexus] -- blog with crosswords downloadable in JPZ format.
* [Cruzzles][cruzzles] -- crosswords by Ricky Cruz.
* [Cryptic Cru Archives][crypticcru] -- puzzles created by New York Times forum members.
* Cryptivore -- "and other mysteries of life" -- email cryptivoresubscription@gmail.com to subscribe.
* [Daily Crossword Links][daily-crossword-links] -- daily list of puzzles in a variety of formats.
* [Diary of a Crossword Fiend][diary] -- crossword reviews and links to puzzles across the web (under Today's Puzzles).
* [Glentopher][glentopher] -- monthly cryptics.
* [Grid Therapy][gridtherapy] -- crosswords by Trent H. Evans.
* [Grids These Days][grids-these-days] -- by Paolo Pasco.
* [Half-Baked][half-baked] -- by Will Eisenberg.
* [Happy Little Puzzles][happylittlepuzzles] -- a variety of different crossword styles.
* [Hub Crosswords][hubcrosswords] -- Sunday-sized crosswords from Emily Cox, Henry Rathvon, and Brendan Emmett Quigley. Puzzles released via Patreon.
* [Jeff Davidson][jeff-davidson] -- crosswords, rows gardens, crosswordles...
* [JimJar's Cryptopica][jimjar].
* [Keglar's Cryptics][keglar] -- homepage of Ron Sweet, block puzzles compatible with Forkyz.
* [Knotty Grids][knotty-grids] -- by Adam Simon Levine.
* [Lexicon Devil][lexicon-devil] -- by Richard D. Allen.
* [Luckystreak XWords][luckystreak] -- modern/Gen-Z crosswords from Ada Nicolle. Subscription puzzles also via [Patreon][luckyxwords].
* [Mad Dog Cryptics][mad-dog-cryptics] -- by Terry Brennan.
* [Mokelfish][mokelfish-puzzles] -- "Multi-part variety word and logic puzzles by Michael F. Gill"
* [Nathan Curtis][nathan-curtis] -- a variety of puzzles via Patreon, free and via subscription.
* [Neville Fogarty][neville-fogarty].
* [NYT Crosswords][nyt-crosswords] -- archive of New York Times crosswords, 1976-2018.
* [Out of Left Field][outofleftfield] -- former The Nation crossword compilers Joshua Kosman and Henri Picciotto now releasing cryptics via Patreon.
* [Outside the Box Puzzles][outside-the-box] -- subscription required, puzzles available in JPZ, untested.
* [Private Eye][private-eye] -- (roughly) fortnightly cryptics downloadable as .puz files.
* [Puzzles That Need a Home][puzzles-that-need-a-home] -- by Brian Thomas.
* [Sid's Grids][sids-grids] -- by Sid Sivakumar.
* [Something Different][something-different] -- set of PUZ files.
* [Square Chase][squarechase] -- bar puzzles via Patreon, tested with Forkyz.
* [Square Pursuit][square-pursuit] -- by Steve Mossberg.
* [The Inkubator][inkubator] -- female-led puzzles going beyond the mainstream.
* [The Rackenfracker][rackenfracker] -- puzzles from a variety of editors.
* [Tough as Nails][tough-as-nails] -- by Stella Zawistowski.
* [XWords by a Ladee][xwords-by-aladee] -- by Brooke.

[mokelfish]: http://bbtp.net/puzzle/links.html
[issues]: https://gitlab.com/Hague/forkyz/-/issues

[andrew-marc-greene]: http://www.greenehouse.com/a/puzzles/
[arctan-x-words]: http://arctanxwords.blogspot.com/
[aries-puzzles]: https://www.ariespuzzles.com/
[avcx]: https://avxwords.com/
[avid-puzzler]: https://avidpuzzler.blogspot.com/
[beneath-the-surface]: https://beneaththesurfacepuzzles.blogspot.com/
[beq]: https://www.brendanemmettquigley.com/
[big-dave-monthly]: http://crypticcrosswords.net/puzzles/prize-puzzles
[big-dave-rookie]: http://crypticcrosswords.net/puzzles/rookie-corner/
[big-dave-special]: http://crypticcrosswords.net/puzzles/special-puzzles/
[big-dave-weekly]: http://crypticcrosswords.net/puzzles/ntspp-puzzles/
[communicrossings]: https://communicrossings.com/crosswords-weyer
[crosshare]: https://crosshare.org/
[crossweird]: https://www.crossweirdpuzzles.com
[crosswordnexus]: https://crosswordnexus.com/blog/
[crosswords-schmosswords]: https://kateschmatecrosswords.weebly.com/
[cruzzles]: https://cruzzles.blogspot.com/
[crypticcru]: https://archive.nytimes.com/www.nytimes.com/premium/xword/cryptic-archive.html
[cryptivore]: https://cryptivore.com/
[daily-crossword-links]: https://dailycrosswordlinks.com/
[diary]: https://crosswordfiend.com/
[everyman]: https://observer.co.uk/everyman
[glentopher]: https://glentopher.blogspot.com/
[grids-these-days]: http://gridsthesedays.blogspot.com/
[gridtherapy]: https://gridtherapy.com/
[guardian]: https://www.theguardian.com/crosswords
[half-baked]: https://halfbakedpuzzles.blogspot.com/
[hamburgerabendblatt]: https://www.abendblatt.de/ratgeber/wissen/article106560367/Spielen-Sie-hier-taeglich-das-kostenlose-Kreuzwortraetsel.html
[happylittlepuzzles]: https://www.happylittlepuzzles.com/
[hubcrosswords]: https://www.patreon.com/hubcrosswords
[inkubator]: https://inkubatorcrosswords.com/
[irishnews]: https://www.irishnews.com/puzzles/
[jeff-davidson]: https://puzzles.jeffpdavidson.com/
[jimjar]: https://twitter.com/Jimjar
[jonesin]: https://www.crosswordnexus.com/jonesin/
[keglar]: https://kegler.gitlab.io/
[knotty-grids]: https://knottygrids.blogspot.com/
[lexicon-devil]: http://www.lexicondevil.live/
[luckystreak]: https://luckyxwords.blogspot.com/
[luckyxwords]: https://www.patreon.com/luckyxwords
[mad-dog-cryptics]: https://maddogcryptics.com/
[metro]: https://metro.co.uk/puzzles/
[mokelfish-puzzles]: https://bbtp.net/puzzle/
[mycrosswordcouk]: https://mycrossword.co.uk
[nathan-curtis]: https://www.patreon.com/nathancurtis
[neville-fogarty]: https://nevillefogarty.wordpress.com/
[nyt-crosswords]: https://github.com/doshea/nyt_crosswords
[outofleftfield]: http://www.leftfieldcryptics.com/
[outside-the-box]: https://www.joonpahk.com
[private-eye]: https://www.private-eye.co.uk/crossword
[puzzles-that-need-a-home]: https://puzzlesthatneedahome.blogspot.com/
[rackenfracker]: https://www.therackenfracker.com/
[seattletimes]: https://www.seattletimes.com/games-nytimes-crossword/
[sids-grids]: https://www.sidsgrids.com
[something-different]: https://dandoesnotblog.blogspot.com/2020/04/something-different.html
[square-pursuit]: https://squarepursuit.com/
[squarechase]: https://www.patreon.com/squarechase
[telegraaf]: https://www.telegraaf.nl/puzzels/kruiswoord/
[tough-as-nails]: https://toughasnails.net/
[xwords-by-aladee]: https://xwordsbyaladee.blogspot.com/
