
package app.crossword.yourealwaysbe.forkyz.settings

import java.io.InputStream
import java.io.OutputStream

import androidx.datastore.core.CorruptionException
import androidx.datastore.core.Serializer
import com.google.protobuf.InvalidProtocolBufferException

object SettingsSerializer : Serializer<Settings> {
    override val defaultValue : Settings = Settings.newBuilder()
        .setAlwaysAnnounceBox(false)
        .setAlwaysAnnounceClue(false)
        .setApplicationTheme(Theme.T_STANDARD)
        .setArchiveCleanupAge(-1)
        .clearAutoDownloaders()
        .setBackgroundDownloadAllowRoaming(false)
        .clearBackgroundDownloadDays()
        .setBackgroundDownloadDaysTime(8)
        .setBackgroundDownloadHourly(false)
        .setBackgroundDownloadRequireCharging(false)
        .setBackgroundDownloadRequireUnmetered(true)
        .setBrowseAlwaysShowRating(false)
        .setBrowseIndicateIfSolution(false)
        .setBrowseNewPuzzle(false)
        .setBrowseShowPercentageCorrect(false)
        .setButtonActivatesVoice(false)
        .setButtonAnnounceClue(false)
        .setChatGPTAPIKey("")
        .setCleanupAge(-1)
        .setClueBelowGrid(false)
        .setClueHighlight(ClueHighlight.CH_RADIO_BUTTON)
        .setClueTabsDouble(ClueTabsDouble.CTD_NEVER)
        .setCrosswordSolverEnabled(true)
        .setCustomDailyTitle("")
        .setCustomDailyUrl("")
        .setCycleUnfilledMode(CycleUnfilledMode.CU_NEVER)
        .setDeleteCrossingMode(DeleteCrossingModeSetting.DCMS_DELETE)
        .setDeleteOnCleanup(false)
        .setDisableRatings(false)
        .setDisableSwipe(true)
        .setDisplayScratch(false)
        .setDisplaySeparators(DisplaySeparators.DS_ALWAYS)
        .setDlLast(0)
        .setDlOnStartup(false)
        .setDoubleTap(false)
        .setDownload20Minutes(true)
        .setDownloadCustomDaily(false)
        .setDownloadDeStandaard(true)
        .setDownloadDeTelegraaf(true)
        .setDownloadElPaisExperto(true)
        .setDownloadGuardianDailyCryptic(true)
        .setDownloadGuardianWeeklyQuiptic(true)
        .setDownloadHamAbend(true)
        .setDownloadIndependentDailyCryptic(true)
        .setDownloadIrishNewsCryptic(true)
        .setDownloadJonesin(true)
        .setDownloadJoseph(true)
        .setDownloadLATimes(true)
        .setDownloadLeParisienF1(true)
        .setDownloadLeParisienF2(true)
        .setDownloadLeParisienF3(true)
        .setDownloadLeParisienF4(true)
        .setDownloadMetroCryptic(true)
        .setDownloadMetroQuick(true)
        .setDownloadNewYorkTimesSyndicated(true)
        .setDownloadNewsday(true)
        .setDownloadPremier(true)
        .setDownloadSheffer(true)
        .setDownloadTimeout(30000)
        .setDownloadUSAToday(true)
        .setDownloadUniversal(true)
        .setDownloadWaPoSunday(true)
        .setDownloadWsj(true)
        .setDuckDuckGoEnabled(true)
        .setEnsureVisible(true)
        .setEnterChangesDirection(true)
        .setEqualsAnnounceClue(true)
        .setExternalDictionary(ExternalDictionarySetting.EDS_FREE)
        .setFifteenSquaredEnabled(true)
        .setFitToScreenMode(FitToScreenMode.FTSM_NEVER)
        .setFullScreen(false)
        .setGridRatio(GridRatio.GR_PUZZLE_SHAPE)
        .setGridRatioLand(GridRatio.GR_PUZZLE_SHAPE)
        .setIndicateShowErrors(true)
        .setInferSeparators(false)
        .setKeyboardCompact(false)
        .setKeyboardForceCaps(true)
        .setKeyboardHaptic(true)
        .setKeyboardHideButton(false)
        .setKeyboardLayout(KeyboardLayout.KL_QWERTY)
        .setKeyboardRepeatDelay(300)
        .setKeyboardRepeatInterval(75)
        .setKeyboardShowHide(KeyboardMode.KM_HIDE_MANUAL)
        .setLastSeenVersion("")
        .setMovementStrategy(MovementStrategySetting.MSS_MOVE_NEXT_ON_AXIS)
        .setMovementStrategyClueList(MovementStrategySetting.MSS_MOVE_NEXT_CLUE)
        .setOrientationLock(Orientation.O_UNLOCKED)
        .setPlayActivityClueTabsPage(0)
        .setPlayActivityClueTabsPage1(1)
        .setPlayLetterUndoEnabled(false)
        .setPredictAnagramChars(true)
        .setPreserveCorrectLettersInShowErrors(false)
        .setRandomClueOnShake(false)
        .setSafArchiveFolderUri("")
        .setSafCrosswordsFolderUri("")
        .setSafRootUri("")
        .setSafToImportDoneFolderUri("")
        .setSafToImportFailedFolderUri("")
        .setSafToImportFolderUri("")
        .setScale(1.0F)
        .setScrapeCru(true)
        .setScrapeGuardianQuick(true)
        .setScrapeKegler(true)
        .setScrapePrivateEye(true)
        .setScrapePrzekroj(true)
        .setScratchMode(false)
        .setShowCluesOnPlayScreen(true)
        .setShowCount(false)
        .setShowErrors(false)
        .setShowErrorsClue(false)
        .setShowErrorsCursor(false)
        .setShowTimer(false)
        .setShowWordsInClueList(false)
        .setSkipFilled(false)
        .setSnapClue(false)
        .setSort(AccessorSetting.AS_DATE_DESC)
        .setSpaceChangesDirection(true)
        .setStorageLocation(StorageLocation.SL_INTERNAL)
        .setSuppressHints(false)
        .setSuppressMessages(false)
        .setSuppressSummaryMessages(false)
        .setSwipeAction(BrowseSwipeAction.BSA_ARCHIVE)
        .setToggleBeforeMove(false)
        .setUiTheme(DayNightMode.DNM_DAY)
        .setUseNativeKeyboard(false)
        .setVolumeActivatesVoice(false)
        .setSpecialEntryForceCaps(false)
        .setDontConfirmCleanup(false)
        .setDontConfirmBrowseDelete(false)
        .setExpandableClueLine(false)
        .setClueListNameInClueLine(ClueListClueLine.CLCL_FULL)
        .setDownloadTF1MotsFleches(true)
        .setDownloadSudOuestMotsFleches(true)
        .setDownloadSudOuestMotsCroises(true)
        .setDownloadTF1MotsCroises(true)
        .build()

    override suspend fun readFrom(input: InputStream) : Settings {
        try {
            return Settings.parseFrom(input)
        } catch (exception: InvalidProtocolBufferException) {
            throw CorruptionException("Cannot read proto.", exception)
        }
    }

    override suspend fun writeTo(t: Settings, output: OutputStream)
        = t.writeTo(output)
}

