package ac.mdiq.podcini.net.sync

import ac.mdiq.podcini.util.config.ClientConfig
import android.content.Context
import android.content.SharedPreferences
import androidx.core.content.edit

object SynchronizationSettings {
    const val LAST_SYNC_ATTEMPT_TIMESTAMP: String = "last_sync_attempt_timestamp"
    private const val NAME = "synchronization"
    private const val WIFI_SYNC_ENABLED = "wifi_sync_enabled"
    private const val SELECTED_SYNC_PROVIDER = "selected_sync_provider"
    private const val LAST_SYNC_ATTEMPT_SUCCESS = "last_sync_attempt_success"
    private const val LAST_EPISODE_ACTIONS_SYNC_TIMESTAMP = "last_episode_actions_sync_timestamp"
    private const val LAST_SUBSCRIPTION_SYNC_TIMESTAMP = "last_sync_timestamp"

    val isProviderConnected: Boolean
        get() = selectedSyncProviderKey != null

    fun resetTimestamps() {
        sharedPreferences.edit {
            putLong(LAST_SUBSCRIPTION_SYNC_TIMESTAMP, 0)
            putLong(LAST_EPISODE_ACTIONS_SYNC_TIMESTAMP, 0)
            putLong(LAST_SYNC_ATTEMPT_TIMESTAMP, 0)
        }
    }

    val isLastSyncSuccessful: Boolean
        get() = sharedPreferences.getBoolean(LAST_SYNC_ATTEMPT_SUCCESS, false)

    val lastSyncAttempt: Long
        get() = sharedPreferences.getLong(LAST_SYNC_ATTEMPT_TIMESTAMP, 0)

    fun setSelectedSyncProvider(provider: SynchronizationProviderViewData?) {
        sharedPreferences.edit { putString(SELECTED_SYNC_PROVIDER, provider?.identifier) }
    }

    val selectedSyncProviderKey: String?
        get() = sharedPreferences.getString(SELECTED_SYNC_PROVIDER, null)

    fun setWifiSyncEnabled(stat: Boolean) {
        sharedPreferences.edit { putBoolean(WIFI_SYNC_ENABLED, stat) }
    }

    val wifiSyncEnabledKey: Boolean
        get() = sharedPreferences.getBoolean(WIFI_SYNC_ENABLED, false)

    fun updateLastSynchronizationAttempt() {
        sharedPreferences.edit { putLong(LAST_SYNC_ATTEMPT_TIMESTAMP, System.currentTimeMillis()) }
    }

    fun setLastSynchronizationAttemptSuccess(isSuccess: Boolean) {
        sharedPreferences.edit { putBoolean(LAST_SYNC_ATTEMPT_SUCCESS, isSuccess) }
    }

    val lastSubscriptionSynchronizationTimestamp: Long
        get() = sharedPreferences.getLong(LAST_SUBSCRIPTION_SYNC_TIMESTAMP, 0)

    fun setLastSubscriptionSynchronizationAttemptTimestamp(newTimeStamp: Long) {
        sharedPreferences.edit { putLong(LAST_SUBSCRIPTION_SYNC_TIMESTAMP, newTimeStamp) }
    }

    val lastEpisodeActionSynchronizationTimestamp: Long
        get() = sharedPreferences.getLong(LAST_EPISODE_ACTIONS_SYNC_TIMESTAMP, 0)

    fun setLastEpisodeActionSynchronizationAttemptTimestamp(timestamp: Long) {
        sharedPreferences.edit { putLong(LAST_EPISODE_ACTIONS_SYNC_TIMESTAMP, timestamp) }
    }

    private val sharedPreferences: SharedPreferences
        get() = ClientConfig.applicationCallbacks!!.getApplicationInstance()!!.getSharedPreferences(NAME, Context.MODE_PRIVATE)
}
