/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.draw2d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.tests.draw2d.Draw2dFigureTestCase;
import org.eclipse.wb.tests.draw2d.TestCaseRootFigure;
import org.eclipse.wb.tests.gef.TestLogger;
import org.junit.jupiter.api.Test;

public class LayerTest
extends Draw2dFigureTestCase {
    @Test
    public void test_name() throws Exception {
        LayerTest.assertNull((Object)new Layer(null).getName());
        LayerTest.assertEquals((Object)"", (Object)new Layer("").getName());
        LayerTest.assertEquals((Object)"Feedback", (Object)new Layer("Feedback").getName());
    }

    @Test
    public void test_bounds() throws Exception {
        TestLogger actualLogger = new TestLogger();
        TestCaseRootFigure parentFigure = new TestCaseRootFigure(actualLogger);
        Layer layer = new Layer("test");
        parentFigure.add((IFigure)layer);
        actualLogger.clear();
        layer.setBounds(new Rectangle(1, 2, 3, 4));
        actualLogger.assertEmpty();
        LayerTest.assertEquals((Object)new Rectangle(1, 2, 3, 4), (Object)layer.getBounds());
        layer.setLocation(new Point(5, 5));
        actualLogger.assertEmpty();
        LayerTest.assertEquals((Object)new Rectangle(5, 5, 3, 4), (Object)layer.getBounds());
        layer.setLocation(new Point(7, 8));
        actualLogger.assertEmpty();
        LayerTest.assertEquals((Object)new Rectangle(7, 8, 3, 4), (Object)layer.getBounds());
        layer.setSize(12, 13);
        actualLogger.assertEmpty();
        LayerTest.assertEquals((Object)new Rectangle(7, 8, 12, 13), (Object)layer.getBounds());
        layer.setSize(new Dimension(2, 1));
        actualLogger.assertEmpty();
        LayerTest.assertEquals((Object)new Rectangle(7, 8, 2, 1), (Object)layer.getBounds());
    }

    @Test
    public void test_opaque() throws Exception {
        TestLogger actualLogger = new TestLogger();
        TestCaseRootFigure parentFigure = new TestCaseRootFigure(actualLogger);
        Layer layer = new Layer("test");
        parentFigure.add((IFigure)layer);
        actualLogger.clear();
        LayerTest.assertFalse((boolean)layer.isOpaque());
        layer.setOpaque(true);
        actualLogger.assertEmpty();
        LayerTest.assertFalse((boolean)layer.isOpaque());
        layer.setOpaque(false);
        actualLogger.assertEmpty();
        LayerTest.assertFalse((boolean)layer.isOpaque());
    }

    @Test
    public void test_containsPoint() throws Exception {
        Layer layer = new Layer("test");
        Figure figure = new Figure();
        figure.setBounds(new Rectangle(10, 10, 100, 100));
        layer.add((IFigure)figure);
        layer.setBounds(new Rectangle(0, 0, 200, 200));
        LayerTest.assertFalse((boolean)layer.containsPoint(0, 0));
        LayerTest.assertTrue((boolean)layer.containsPoint(50, 50));
    }
}

