/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.widgets;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.RootAssociation;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyEditor;
import org.eclipse.wb.internal.core.model.util.PlaceholderUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.swt.model.jface.viewer.ViewerInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.ButtonInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class ControlTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_MethodMain() throws Exception {
        CompositeInfo shellInfo = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell(SWT.NONE);", "    shell.setSize(320, 240);", "    shell.setText('SWT');", "    Button button = new Button(shell, SWT.NONE);", "    button.setBounds(10, 20, 50, 30);", "    button.setText('push');", "  }", "}");
        ControlTest.assertInstanceOf(RootAssociation.class, (Object)shellInfo.getAssociation());
        List children = shellInfo.getChildrenControls();
        ControlTest.assertEquals((int)1, (int)children.size());
        ControlInfo buttonInfo = (ControlInfo)children.get(0);
        Property buttonProperty = buttonInfo.getPropertyByTitle("text");
        ControlTest.assertNotNull((Object)buttonProperty);
        ControlTest.assertEquals((Object)"push", (Object)buttonProperty.getValue());
        ControlTest.assertTrue((boolean)(buttonProperty.getEditor() instanceof StringPropertyEditor));
        Property shellProperty = shellInfo.getPropertyByTitle("text");
        ControlTest.assertNotNull((Object)shellProperty);
        ControlTest.assertEquals((Object)"SWT", (Object)shellProperty.getValue());
        ControlTest.assertTrue((boolean)(shellProperty.getEditor() instanceof StringPropertyEditor));
        shellInfo.refresh();
        ControlTest.assertNotNull((Object)shellInfo.getImage());
        ControlTest.assertEquals((Object)new org.eclipse.swt.graphics.Rectangle(0, 0, 320, 240), (Object)shellInfo.getImage().getBounds());
        Insets shellInsets = shellInfo.getClientAreaInsets();
        Rectangle shellModelBounds = shellInfo.getModelBounds();
        Rectangle shellBounds = shellInfo.getBounds();
        Rectangle buttonBounds = buttonInfo.getBounds();
        Rectangle buttonModelBounds = buttonInfo.getModelBounds();
        ControlTest.assertNotNull((Object)shellInsets);
        ControlTest.assertNotNull((Object)shellBounds);
        ControlTest.assertNotNull((Object)shellModelBounds);
        ControlTest.assertNotNull((Object)buttonBounds);
        ControlTest.assertNotNull((Object)buttonModelBounds);
        ControlTest.assertEquals((Object)new Dimension(320, 240), (Object)shellModelBounds.getSize());
        ControlTest.assertEquals((Object)new Dimension(320, 240), (Object)shellBounds.getSize());
        ControlTest.assertEquals((int)shellInsets.left, (int)(buttonBounds.x - buttonModelBounds.x));
        ControlTest.assertEquals((int)shellInsets.top, (int)(buttonBounds.y - buttonModelBounds.y));
        ControlTest.assertNotNull((Object)buttonInfo.getImage());
        ControlTest.assertNotNull((Object)buttonInfo.getClientAreaInsets());
        ControlTest.assertEquals((Object)new Rectangle(10 + shellInsets.left, 20 + shellInsets.top, 50, 30), (Object)buttonBounds);
        ControlTest.assertNotNull((Object)buttonInfo.getPreferredSize());
    }

    @Test
    public void test_application() throws Exception {
        this.m_waitForAutoBuild = true;
        this.parseComposite("public class Test {", "  private Shell shell;", "  public static void main(String[] args) {", "    Test app = new Test();", "    app.open();", "  }", "  public void open() {", "    Display display = Display.getDefault();", "    createContents();", "    shell.open();", "    shell.layout();", "    while (!shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  private void createContents() {", "    shell = new Shell();", "    shell.setSize(450, 300);", "    shell.setText('SWT Application');", "    shell.setLayout(new GridLayout());", "  }", "}");
    }

    @Test
    public void test_newDisplay() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  public static void main(String[] args) {", "    Display display = new Display();", "    Shell shell = new Shell(display);", "  }", "}");
        ControlTest.assertEquals((Object)"org.eclipse.swt.widgets.Shell", (Object)shell.getDescription().getComponentClass().getName());
    }

    @Test
    public void test_classLoader_1() throws Exception {
        this.test_classLoader(new String[]{"class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "  }", "}"});
    }

    @Test
    public void test_classLoader_2() throws Exception {
        this.test_classLoader(new String[]{"class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}"});
    }

    private void test_classLoader(String[] lines) throws Exception {
        CompositeInfo compositeInfo = this.parseComposite(lines);
        Class<?> swtClass = this.m_lastLoader.loadClass("org.eclipse.swt.SWT");
        ControlTest.assertNotNull(swtClass);
        ControlTest.assertEquals((Object)swtClass.getField("BORDER").get(null), (Object)2048);
        ControlTest.assertEquals((int)swtClass.getField("BORDER").getInt(null), (int)2048);
        Class<?> shellClass = this.m_lastLoader.loadClass("org.eclipse.swt.widgets.Shell");
        ControlTest.assertNotNull(shellClass);
        compositeInfo.refresh();
        Composite control = compositeInfo.getWidget();
        ControlTest.assertNotNull((Object)control.getBounds());
        ControlTest.assertNotNull((Object)control.toDisplay(0, 0));
        ControlTest.assertNotNull((Object)control.getStyle());
    }

    @Test
    public void test_sharingDescriptions() throws Exception {
        CompositeInfo shell_1 = (CompositeInfo)this.parseSource("test", "Test_1.java", ControlTest.getSourceDQ("package test;", "public class Test_1 extends org.eclipse.swt.widgets.Shell {", "  public Test_1() {", "    new org.eclipse.jface.viewers.TableViewer(this, 0);", "  }", "}"));
        ViewerInfo viewer_1 = (ViewerInfo)((ControlInfo)shell_1.getChildrenControls().get(0)).getChildrenJava().get(0);
        CompositeInfo shell_2 = (CompositeInfo)this.parseSource("test", "Test_2.java", ControlTest.getSourceDQ("package test;", "public class Test_2 extends org.eclipse.swt.widgets.Shell {", "  public Test_2() {", "    new org.eclipse.jface.viewers.TableViewer(this, 0);", "  }", "}"));
        ViewerInfo viewer_2 = (ViewerInfo)((ControlInfo)shell_2.getChildrenControls().get(0)).getChildrenJava().get(0);
        ControlTest.assertSame((Object)shell_1.getDescription(), (Object)shell_2.getDescription());
        ControlTest.assertSame((Object)viewer_1.getDescription(), (Object)viewer_2.getDescription());
    }

    @Test
    public void test_nonStaticInnerClass() throws Exception {
        this.m_waitForAutoBuild = true;
        this.parseSource("test", "Test.java", this.getTestSource("public class Test extends Shell {", "  public Test() {", "    new MyComposite(this, SWT.NONE);", "  }", "  private class MyComposite extends Composite {", "    public MyComposite(Composite parent, int style) {", "      super(parent, style);", "    }", "  }", "}"));
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new MyComposite(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}");
    }

    @Test
    public void test_preferredBounds_usualBounds() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    setSize(500, 300);", "    //", "    Composite composite = new Composite(this, SWT.NONE);", "    composite.setLayout(new GridLayout());", "    //", "    Button button = new Button(composite, SWT.NONE);", "    button.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));", "  }", "}");
        shell.refresh();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        GridLayoutInfo gridLayout = (GridLayoutInfo)composite.getLayout();
        int columnWidth = gridLayout.getGridInfo().getColumnIntervals()[0].length();
        ControlTest.assertTrue((columnWidth > 400 ? 1 : 0) != 0, (String)("More than 400 expected, but " + columnWidth + " found"));
    }

    @Test
    public void test_disposeHierarchy() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new Button(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        Composite shellObject = shell.getWidget();
        Control buttonObject = button.getWidget();
        ControlTest.assertFalse((boolean)shellObject.isDisposed());
        ControlTest.assertFalse((boolean)buttonObject.isDisposed());
        this.disposeLastModel();
        ControlTest.assertTrue((boolean)shellObject.isDisposed());
        ControlTest.assertTrue((boolean)buttonObject.isDisposed());
    }

    @Test
    public void test_ColorConverter() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        shell.refresh();
        Property backgroundProperty = shell.getPropertyByTitle("background");
        Color backgroundValue = (Color)backgroundProperty.getValue();
        ControlTest.assertNotNull((Object)backgroundValue);
        ControlTest.assertFalse((boolean)backgroundValue.isDisposed());
    }

    @Test
    public void test_getAbsoluteBounds() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setSize(800, 600);", "    //", "    Composite composite = new Composite(this, SWT.NONE);", "    composite.setBounds(10, 20, 300, 200);", "    //", "    Button button = new Button(composite, SWT.NONE);", "    button.setBounds(5, 10, 100, 50);", "  }", "}");
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        shell.refresh();
        ControlTest.assertEquals((Object)new Rectangle(0, 0, 800, 600), (Object)shell.getAbsoluteBounds());
        ControlTest.assertEquals((Object)new Rectangle(10 + shell.getClientAreaInsets().left, 20 + shell.getClientAreaInsets().top, 300, 200), (Object)composite.getAbsoluteBounds());
        ControlTest.assertEquals((Object)new Rectangle(5 + composite.getAbsoluteBounds().x, 10 + composite.getAbsoluteBounds().y, 100, 50), (Object)button.getAbsoluteBounds());
    }

    @Test
    public void test_executeNoVariable() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    new Button(this, SWT.NONE);", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        shell.refresh();
        ControlTest.assertNotNull((Object)button.getObject());
    }

    @Test
    public void test_exposeAction() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        MenuManager manager = ControlTest.getDesignerMenuManager();
        button.getBroadcastObject().addContextMenu(Collections.singletonList(button), (ObjectInfo)button, (IMenuManager)manager);
        ControlTest.assertNotNull((Object)ControlTest.findChildAction((IContributionManager)manager, "Expose component..."));
    }

    private void check_constructorEvaluation_actualOnlyException_placeholder(CompositeInfo shell, String exceptionNodeSource) throws Exception {
        this.check_constructorEvaluation_placeholder(shell);
        this.check_constructorEvaluation_actualOnlyException(exceptionNodeSource);
    }

    private void check_constructorEvaluation_placeholder(CompositeInfo shell) throws Exception {
        shell.refresh();
        ControlInfo badComponent = (ControlInfo)shell.getChildrenControls().get(0);
        Control badComponentObject = (Control)badComponent.getObject();
        ControlTest.assertEquals((Object)badComponentObject.getClass().getName(), (Object)"org.eclipse.swt.widgets.Composite");
        ControlTest.assertTrue((boolean)badComponent.isPlaceholder());
        Object[] children = shell.getWidget().getChildren();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])children).hasSize(1)).containsOnly((Object[])new Control[]{badComponentObject});
    }

    private void check_constructorEvaluation_actualOnlyException(String exceptionNodeSource) {
        List badNodes = this.m_lastState.getBadRefreshNodes().nodes();
        Assertions.assertThat((List)badNodes).hasSize(1);
        EditorState.BadNodeInformation badNode = (EditorState.BadNodeInformation)badNodes.get(0);
        this.check_constructorEvaluation_badNode(badNode, exceptionNodeSource, "actual");
    }

    private void check_constructorEvaluation_badNode(EditorState.BadNodeInformation badNode, String exceptionNodeSource, String exceptionMessage) {
        ASTNode node = badNode.getNode();
        Throwable nodeException = badNode.getException();
        ControlTest.assertEquals((Object)exceptionNodeSource, (Object)this.m_lastEditor.getSource(node));
        Throwable e = DesignerExceptionUtils.getRootCause((Throwable)nodeException);
        Assertions.assertThat((Throwable)e).isExactlyInstanceOf(IllegalStateException.class);
        ControlTest.assertEquals((Object)e.getMessage(), (Object)exceptionMessage);
        Assertions.assertThat((List)PlaceholderUtils.getExceptions((ASTNode)node)).contains((Object[])new Throwable[]{nodeException});
    }

    @Test
    public void test_constructorEvaluation_exceptionActual_sameDefault() throws Exception {
        ControlTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends Button {", "  public MyButton(Composite parent, int style) {", "    super(parent, style);", "    throw new IllegalStateException('actual');", "  }", "  protected void checkSubclass() {", "  }", "}"));
        ControlTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    MyButton button = new MyButton(this, SWT.NONE);", "  }", "}");
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new MyButton(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: test.MyButton} {local-unique: button} {/new MyButton(this, SWT.NONE)/}");
        this.check_constructorEvaluation_actualOnlyException_placeholder(shell, "new MyButton(this, SWT.NONE)");
    }

    @Test
    public void test_constructorEvaluation_exceptionActual_noDefault() throws Exception {
        ControlTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends Button {", "  public MyButton(Composite parent, int style, int value) {", "    super(parent, style);", "    throw new IllegalStateException('actual');", "  }", "  protected void checkSubclass() {", "  }", "}"));
        ControlTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    MyButton button = new MyButton(this, SWT.NONE, 0);", "  }", "}");
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new MyButton(this, SWT.NONE, 0)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: test.MyButton} {local-unique: button} {/new MyButton(this, SWT.NONE, 0)/}");
        this.check_constructorEvaluation_actualOnlyException_placeholder(shell, "new MyButton(this, SWT.NONE, 0)");
    }

    @Test
    public void test_constructorEvaluation_exceptionActual_exceptionDefault() throws Exception {
        ControlTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends Button {", "  public MyButton(Composite parent, int style) {", "    super(parent, style);", "    throw new IllegalStateException('default');", "  }", "  public MyButton(Composite parent, int style, int value) {", "    super(parent, style);", "    throw new IllegalStateException('actual');", "  }", "  protected void checkSubclass() {", "  }", "}"));
        ControlTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    MyButton button = new MyButton(this, SWT.NONE, 0);", "  }", "}");
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new MyButton(this, SWT.NONE, 0)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: test.MyButton} {local-unique: button} {/new MyButton(this, SWT.NONE, 0)/}");
        this.check_constructorEvaluation_placeholder(shell);
        String exceptionNodeSource = "new MyButton(this, SWT.NONE, 0)";
        List badNodes = this.m_lastState.getBadRefreshNodes().nodes();
        Assertions.assertThat((List)badNodes).hasSize(2);
        EditorState.BadNodeInformation badNode = (EditorState.BadNodeInformation)badNodes.get(0);
        this.check_constructorEvaluation_badNode(badNode, exceptionNodeSource, "actual");
        badNode = (EditorState.BadNodeInformation)badNodes.get(1);
        this.check_constructorEvaluation_badNode(badNode, exceptionNodeSource, "default");
    }

    @Test
    public void test_constructorEvaluation_exceptionActual_goodDefault() throws Exception {
        ControlTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends Button {", "  public MyButton(Composite parent, int style) {", "    super(parent, style);", "    setText('A');", "  }", "  public MyButton(Composite parent, int style, int value) {", "    super(parent, style);", "    setText('B');", "    throw new IllegalStateException('actual');", "  }", "  protected void checkSubclass() {", "  }", "}"));
        ControlTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    MyButton button = new MyButton(this, SWT.NONE, 0);", "  }", "}");
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new MyButton(this, SWT.NONE, 0)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: test.MyButton} {local-unique: button} {/new MyButton(this, SWT.NONE, 0)/}");
        shell.refresh();
        ButtonInfo button = (ButtonInfo)shell.getChildrenControls().get(0);
        Button buttonObject = button.getWidget();
        ControlTest.assertEquals((Object)"A", (Object)buttonObject.getText());
        ControlTest.assertFalse((boolean)button.isPlaceholder());
        Object[] children = shell.getWidget().getChildren();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])children).hasSize(1)).containsOnly((Object[])new Control[]{buttonObject});
        this.check_constructorEvaluation_actualOnlyException("new MyButton(this, SWT.NONE, 0)");
    }

    @Test
    public void test_constructorEvaluation_placeholder_ignoreExposed() throws Exception {
        ControlTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends Button {", "  public MyButton(Composite parent, int style, int value) {", "    super(parent, style);", "    throw new IllegalStateException('actual');", "  }", "  protected void checkSubclass() {", "  }", "  public Control getExposed() {", "    return null;", "  }", "}"));
        ControlTest.waitForAutoBuild();
        this.parseComposite("public class Test extends Shell {", "  public Test() {", "    MyButton button = new MyButton(this, SWT.NONE, 0);", "  }", "}");
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new MyButton(this, SWT.NONE, 0)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: test.MyButton} {local-unique: button} {/new MyButton(this, SWT.NONE, 0)/}");
    }

    @Test
    public void test_newAnonymousControl() throws Exception {
        ControlTest.setFileContentSrc("test/MyAbstractButton.java", this.getTestSource("public class MyAbstractButton extends Button {", "  public MyAbstractButton(Composite parent, int style) {", "    super(parent, style);", "  }", "  protected void checkSubclass() {", "  }", "}"));
        ControlTest.waitForAutoBuild();
        ControlTest.useStrictEvaluationMode(false);
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new MyAbstractButton(this, SWT.NONE) {};", "  }", "}");
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new MyAbstractButton(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: test.MyAbstractButton} {empty} {/new MyAbstractButton(this, SWT.NONE)/}");
        shell.refresh();
        ControlTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_duplicateMethodInvocation() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    createButton(this, 0);", "    createButton(this, 1);", "  }", "  private void createButton(Composite parent, int value) {", "    new Button(parent, SWT.NONE);", "  }", "}");
        ControlTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/createButton(this, 0)/ /createButton(this, 1)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: org.eclipse.swt.widgets.Button} {empty} {/new Button(parent, SWT.NONE)/}");
        shell.refresh();
        ControlTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_nullAsParent() throws Exception {
        try {
            this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Button button = new Button(null, SWT.NONE);", "  }", "}");
        }
        catch (Throwable e) {
            DesignerException de = (DesignerException)DesignerExceptionUtils.getRootCause((Throwable)e);
            ControlTest.assertEquals((int)2005, (int)de.getCode());
        }
    }

    @Test
    public void test_unknownCompositeParameter() throws Exception {
        this.parseComposite("public class Test {", "  /**", "  * @wbp.parser.entryPoint", "  */", "  public void createContent(Composite parent) {", "    Composite composite = new Composite(parent, SWT.NONE);", "    new Button(composite, SWT.NONE);", "  }", "}");
        ControlTest.assertHierarchy("{new: org.eclipse.swt.widgets.Composite} {local-unique: composite} {/new Composite(parent, SWT.NONE)/ /new Button(composite, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: org.eclipse.swt.widgets.Button} {empty} {/new Button(composite, SWT.NONE)/}");
    }

    @Test
    public void test_disposeSharedShell() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent) {", "    super(parent, SWT.NONE);", "  }", "}");
        composite.refresh();
        Composite shell = composite.getWidget().getParent();
        shell.dispose();
        composite.refresh();
    }

    @Test
    public void test_parentNotAsFirstParameter() throws Exception {
        ControlTest.useStrictEvaluationMode(false);
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(int flag, Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        composite.refresh();
        Composite compositeObject = composite.getWidget();
        ControlTest.assertNotNull((Object)compositeObject.getParent());
        Assertions.assertThat((int)(0x2000000 & compositeObject.getStyle())).isGreaterThan(0);
    }

    @Test
    public void test_dontIntercept_computeSize_1() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "  public Point computeSize(int wHint, int hHint, boolean changed) {", "    if (1 == 2) {", "      return new Point(1, 2);", "    }", "    return super.computeSize(wHint, hHint, changed);", "  }", "}");
        composite.refresh();
    }

    @Test
    public void test_dontIntercept_computeSize_2() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "  public Point computeSize(int wHint, int hHint) {", "    if (1 == 2) {", "      return new Point(1, 2);", "    }", "    return super.computeSize(wHint, hHint);", "  }", "}");
        composite.refresh();
    }
}

