/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import java.util.List;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JTabbedPaneInfo;
import org.eclipse.wb.internal.swing.model.component.JTabbedPaneTabInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.jupiter.api.Test;

public class JTabbedPaneGefTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_childrenForActiveTab() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tJTabbedPane tabbedPane = new JTabbedPane(JTabbedPane.TOP);\n\t\tadd(tabbedPane);\n\t\t{\n\t\t\tJPanel panel_1 = new JPanel();\n\t\t\tpanel_1.setLayout(null);\n\t\t\ttabbedPane.addTab(\"AAAAAA\", panel_1);\n\t\t\t{\n\t\t\t\tJButton button_1 = new JButton();\n\t\t\t\tbutton_1.setBounds(10, 10, 100, 100);\n\t\t\t\tpanel_1.add(button_1);\n\t\t\t}\n\t\t}\n\t\t{\n\t\t\tJPanel panel_2 = new JPanel();\n\t\t\tpanel_2.setLayout(null);\n\t\t\ttabbedPane.addTab(\"BBBBBB\", panel_2);\n\t\t\t{\n\t\t\t\tJButton button_2 = new JButton();\n\t\t\t\tbutton_2.setBounds(110, 10, 100, 100);\n\t\t\t\tpanel_2.add(button_2);\n\t\t\t}\n\t\t}\n\t}\n}");
        JTabbedPaneInfo tabbedPane = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ContainerInfo panel_1 = (ContainerInfo)tabbedPane.getChildrenComponents().get(0);
        ContainerInfo panel_2 = (ContainerInfo)tabbedPane.getChildrenComponents().get(1);
        ComponentInfo button_1 = (ComponentInfo)panel_1.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel_2.getChildrenComponents().get(0);
        JTabbedPaneGefTest.assertNotNull((Object)this.canvas.getEditPart(panel_1));
        JTabbedPaneGefTest.assertNotNull((Object)this.canvas.getEditPart(button_1));
        this.canvas.assertNullEditPart(panel_2);
        this.canvas.assertNullEditPart(button_2);
        this.canvas.target(tabbedPane).in(50, 50).move().click();
        this.assertSelectionModels(button_1);
        this.canvas.target(tabbedPane).in(150, 50).move().click();
        this.assertSelectionModels(panel_1);
    }

    @Test
    public void test_tab_MOVE() throws Exception {
        ContainerInfo panel = this.openContainer("class Test extends JPanel {\n\tTest() {\n\t\tJTabbedPane tabbed = new JTabbedPane();\n\t\tadd(tabbed);\n\t\t{\n\t\t\tJLabel label = new JLabel();\n\t\t\ttabbed.addTab(\"111\", label);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\ttabbed.addTab(\"222\", button);\n\t\t}\n\t}\n}");
        JTabbedPaneInfo tabbedPane = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo label = (ComponentInfo)tabbedPane.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)tabbedPane.getChildrenComponents().get(1);
        this.canvas.assertNotNullEditPart(label);
        this.canvas.assertNullEditPart(button);
        List tabs = tabbedPane.getTabs();
        JTabbedPaneTabInfo labelTab = (JTabbedPaneTabInfo)tabs.get(0);
        JTabbedPaneTabInfo buttonTab = (JTabbedPaneTabInfo)tabs.get(1);
        this.canvas.beginDrag(buttonTab).dragTo((Object)labelTab, 5, 5).endDrag();
        this.canvas.assertNullEditPart(label);
        this.canvas.assertNotNullEditPart(button);
        this.assertEditor("class Test extends JPanel {\n\tTest() {\n\t\tJTabbedPane tabbed = new JTabbedPane();\n\t\tadd(tabbed);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\ttabbed.addTab(\"222\", button);\n\t\t}\n\t\t{\n\t\t\tJLabel label = new JLabel();\n\t\t\ttabbed.addTab(\"111\", label);\n\t\t}\n\t}\n}");
    }
}

