/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JSplitPaneInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.model.parser.AbstractJavaInfoTest;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class JSplitPaneTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_association_setLeftRight() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JSplitPane split = new JSplitPane();", "    add(split);", "    {", "      JButton button = new JButton();", "      split.setLeftComponent(button);", "    }", "    {", "      JButton button = new JButton();", "      split.setRightComponent(button);", "    }", "  }", "}");
        panel.refresh();
        JSplitPaneInfo split = (JSplitPaneInfo)panel.getChildrenComponents().get(0);
        JSplitPaneTest.assertEquals((int)2, (int)split.getChildrenComponents().size());
        JSplitPaneTest.assertFalse((boolean)split.isEmptyPosition(true));
        JSplitPaneTest.assertFalse((boolean)split.isEmptyPosition(false));
        Insets insets = split.getInsets();
        Rectangle r = split.getPositionRectangle(true);
        JSplitPaneTest.assertEquals((int)insets.left, (int)r.x);
        JSplitPaneTest.assertEquals((int)insets.top, (int)r.y);
        r = split.getPositionRectangle(false);
        JSplitPaneTest.assertEquals((int)insets.top, (int)r.y);
    }

    @Test
    public void test_association_empty() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JSplitPane split = new JSplitPane();", "    add(split);", "  }", "}");
        panel.refresh();
        JSplitPaneInfo split = (JSplitPaneInfo)panel.getChildrenComponents().get(0);
        JSplitPaneTest.assertTrue((boolean)split.isEmptyPosition(true));
        JSplitPaneTest.assertTrue((boolean)split.isEmptyPosition(false));
    }

    @Test
    public void test_association_setDividerLocation() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JSplitPane split = new JSplitPane();", "    add(split);", "    {", "      JButton button_1 = new JButton();", "      split.setLeftComponent(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      split.setRightComponent(button_2);", "    }", "  }", "}");
        panel.refresh();
        JSplitPaneInfo split = (JSplitPaneInfo)panel.getChildrenComponents().get(0);
        split.getPropertyByTitle("dividerLocation(double)").setValue((Object)0.5);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JSplitPane split = new JSplitPane();", "    add(split);", "    {", "      JButton button_1 = new JButton();", "      split.setLeftComponent(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      split.setRightComponent(button_2);", "    }", "    split.setDividerLocation(0.5);", "  }", "}");
    }

    @Test
    public void test_getPositionRectangle_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JSplitPane split = new JSplitPane();", "    add(split);", "    {", "      JButton button = new JButton();", "      split.setLeftComponent(button);", "    }", "    {", "      JButton button = new JButton();", "      split.setRightComponent(button);", "    }", "  }", "}");
        panel.refresh();
        JSplitPaneInfo split = (JSplitPaneInfo)panel.getChildrenComponents().get(0);
        Insets insets = split.getInsets();
        Rectangle r = split.getPositionRectangle(true);
        JSplitPaneTest.assertEquals((int)insets.left, (int)r.x);
        JSplitPaneTest.assertEquals((int)insets.top, (int)r.y);
        r = split.getPositionRectangle(false);
        JSplitPaneTest.assertEquals((int)insets.top, (int)r.y);
    }

    @Test
    public void test_getPositionRectangle_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JSplitPane split = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, null, null);", "    add(split);", "  }", "}");
        panel.refresh();
        JSplitPaneInfo split = (JSplitPaneInfo)panel.getChildrenComponents().get(0);
        Rectangle r = split.getPositionRectangle(true);
        JSplitPaneTest.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)r);
    }

    @Test
    public void test_CREATE() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JSplitPane split = new JSplitPane();", "    add(split);", "  }", "}");
        JSplitPaneInfo split = (JSplitPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo newComponent = JSplitPaneTest.createJButton();
        split.command_CREATE(newComponent, true);
        JSplitPaneTest.assertInstanceOf(InvocationChildAssociation.class, (Object)newComponent.getAssociation());
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JSplitPane split = new JSplitPane();", "    add(split);", "    {", "      JButton button = new JButton();", "      split.setLeftComponent(button);", "    }", "  }", "}");
    }

    @Test
    public void test_OUT() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JSplitPane split = new JSplitPane();", "    add(split);", "    {", "      JButton button = new JButton();", "      split.setLeftComponent(button);", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "    }", "  }", "}");
        JSplitPaneInfo split = (JSplitPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)split.getChildrenComponents().get(0);
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(1);
        FlowLayoutInfo innerLayout = (FlowLayoutInfo)innerPanel.getLayout();
        innerLayout.move(button, null);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JSplitPane split = new JSplitPane();", "    add(split);", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        JButton button = new JButton();", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JSplitPane split = new JSplitPane();", "    add(split);", "    {", "      JButton button = new JButton();", "      split.setLeftComponent(button);", "    }", "  }", "}");
        JSplitPaneInfo split = (JSplitPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)split.getChildrenComponents().get(0);
        split.command_MOVE(button, false);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JSplitPane split = new JSplitPane();", "    add(split);", "    {", "      JButton button = new JButton();", "      split.setRightComponent(button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JSplitPane split = new JSplitPane();", "    add(split);", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        JButton button = new JButton();", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
        JSplitPaneInfo split = (JSplitPaneInfo)panel.getChildrenComponents().get(0);
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(1);
        ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        split.command_ADD(button, true);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JSplitPane split = new JSplitPane();", "    add(split);", "    {", "      JButton button = new JButton();", "      split.setLeftComponent(button);", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "    }", "  }", "}");
    }

    @Test
    public void test_clipboard() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    {", "      JSplitPane split = new JSplitPane();", "      add(split);", "      {", "        JButton button = new JButton('A');", "        split.setLeftComponent(button);", "      }", "      {", "        JButton button = new JButton('B');", "        split.setRightComponent(button);", "      }", "    }", "  }", "}");
        this.refresh();
        ComponentInfo split = (ComponentInfo)JSplitPaneTest.getJavaInfoByName("split");
        JSplitPaneTest.doCopyPaste(split, new AbstractJavaInfoTest.PasteProcedure<ComponentInfo>(){

            @Override
            public void run(ComponentInfo copy) throws Exception {
                ((FlowLayoutInfo)panel.getLayout()).add(copy, null);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    {", "      JSplitPane split = new JSplitPane();", "      add(split);", "      {", "        JButton button = new JButton('A');", "        split.setLeftComponent(button);", "      }", "      {", "        JButton button = new JButton('B');", "        split.setRightComponent(button);", "      }", "    }", "    {", "      JSplitPane split = new JSplitPane();", "      add(split);", "      {", "        JButton button = new JButton('A');", "        split.setLeftComponent(button);", "      }", "      {", "        JButton button = new JButton('B');", "        split.setRightComponent(button);", "      }", "    }", "  }", "}");
    }
}

