/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.nebula;

import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.rcp.nebula.grid.GridColumnGroupInfo;
import org.eclipse.wb.internal.rcp.nebula.grid.GridColumnInfo;
import org.eclipse.wb.internal.rcp.nebula.grid.GridInfo;
import org.eclipse.wb.internal.rcp.nebula.grid.GridItemInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.nebula.AbstractNebulaTest;
import org.junit.jupiter.api.Test;

public class GridTest
extends AbstractNebulaTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_General() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.nebula.widgets.grid.*;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Grid grid = new Grid(this, SWT.NONE);", "    {", "      GridColumnGroup group = new GridColumnGroup(grid, SWT.NONE);", "      {", "        GridColumn column = new GridColumn(group, SWT.NONE);", "        column.setWidth(150);", "      }", "    }", "    {", "      GridItem item1 = new GridItem(grid, SWT.NONE);", "      {", "        GridItem item2 = new GridItem(item1, SWT.NONE);", "      }", "    }", "  }", "}");
        shell.refresh();
        GridInfo grid = (GridInfo)shell.getChildren(CompositeInfo.class).get(0);
        GridTest.assertEquals((int)2, (int)grid.getChildren().size());
        GridTest.assertEquals((int)1, (int)grid.getChildren(GridColumnGroupInfo.class).size());
        GridTest.assertEquals((int)1, (int)grid.getChildren(GridItemInfo.class).size());
        int headerHeight = grid.getWidget().getHeaderHeight();
        int groupHeaderHeight = grid.getWidget().getGroupHeaderHeight();
        GridColumnGroupInfo group = (GridColumnGroupInfo)grid.getChildren(GridColumnGroupInfo.class).get(0);
        Rectangle bounds = group.getBounds();
        GridTest.assertEquals((int)bounds.width, (int)150);
        GridTest.assertEquals((int)bounds.height, (int)headerHeight);
        GridTest.assertEquals((int)1, (int)group.getChildren(GridColumnInfo.class).size());
        GridColumnInfo column = (GridColumnInfo)group.getChildren(GridColumnInfo.class).get(0);
        Rectangle bounds2 = column.getBounds();
        GridTest.assertEquals((int)bounds2.width, (int)150);
        GridTest.assertEquals((int)bounds2.height, (int)(headerHeight - groupHeaderHeight));
        GridItemInfo item = (GridItemInfo)grid.getChildren(GridItemInfo.class).get(0);
        bounds2 = item.getBounds();
        Assertions.assertThat((int)bounds2.width).isGreaterThan(100);
        Assertions.assertThat((int)bounds2.height).isLessThan(25);
        GridTest.assertEquals((int)1, (int)item.getChildren().size());
        GridItemInfo subItem = (GridItemInfo)item.getChildren(GridItemInfo.class).get(0);
        Rectangle bounds3 = subItem.getBounds();
        Assertions.assertThat((int)bounds3.width).isGreaterThan(100);
        GridTest.assertEquals((int)bounds3.height, (int)0);
    }

    @Test
    public void test_Expanded() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.nebula.widgets.grid.*;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Grid grid = new Grid(this, SWT.NONE);", "    {", "      GridColumnGroup group = new GridColumnGroup(grid, SWT.NONE);", "      {", "        GridColumn column = new GridColumn(group, SWT.NONE);", "        column.setWidth(150);", "      }", "    }", "    {", "      GridColumn column = new GridColumn(grid, SWT.NONE);", "      column.setWidth(100);", "    }", "    {", "      GridItem item1 = new GridItem(grid, SWT.NONE);", "      item1.setExpanded(true);", "      {", "        GridItem item2 = new GridItem(item1, SWT.NONE);", "      }", "    }", "  }", "}");
        shell.refresh();
        CompositeInfo grid = (CompositeInfo)shell.getChildren(CompositeInfo.class).get(0);
        GridItemInfo item = (GridItemInfo)grid.getChildren(GridItemInfo.class).get(0);
        Rectangle bounds = item.getBounds();
        Assertions.assertThat((int)bounds.width).isGreaterThan(100);
        Assertions.assertThat((int)bounds.height).isGreaterThan(30);
        GridTest.assertEquals((int)1, (int)item.getChildren().size());
        GridItemInfo subItem = (GridItemInfo)item.getChildren(GridItemInfo.class).get(0);
        Rectangle bounds2 = subItem.getBounds();
        Assertions.assertThat((int)bounds2.width).isGreaterThan(100);
        Assertions.assertThat((int)bounds2.height).isGreaterThan(15);
    }

    @Test
    public void test_addColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.nebula.widgets.grid.*;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Grid grid = new Grid(this, SWT.NONE);", "    {", "      GridColumnGroup group = new GridColumnGroup(grid, SWT.NONE);", "      {", "        GridColumn column = new GridColumn(group, SWT.NONE);", "        column.setWidth(150);", "      }", "    }", "    {", "      GridItem item1 = new GridItem(grid, SWT.NONE);", "      {", "        GridItem item2 = new GridItem(item1, SWT.NONE);", "      }", "    }", "  }", "}");
        shell.refresh();
        GridInfo grid = (GridInfo)shell.getChildren(GridInfo.class).get(0);
        GridColumnInfo column = (GridColumnInfo)JavaInfoUtils.createJavaInfo((AstEditor)grid.getEditor(), (String)"org.eclipse.nebula.widgets.grid.GridColumn", (CreationSupport)new ConstructorCreationSupport());
        JavaInfoUtils.add((JavaInfo)column, null, (JavaInfo)grid, null);
        this.assertEditor("import org.eclipse.nebula.widgets.grid.*;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Grid grid = new Grid(this, SWT.NONE);", "    {", "      GridColumnGroup group = new GridColumnGroup(grid, SWT.NONE);", "      {", "        GridColumn column = new GridColumn(group, SWT.NONE);", "        column.setWidth(150);", "      }", "    }", "    {", "      GridColumn gridColumn = new GridColumn(grid, SWT.NONE);", "      gridColumn.setText('New Column');", "      gridColumn.setWidth(150);", "    }", "    {", "      GridItem item1 = new GridItem(grid, SWT.NONE);", "      {", "        GridItem item2 = new GridItem(item1, SWT.NONE);", "      }", "    }", "  }", "}");
    }
}

