/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.layout;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.generic.FlowContainerFactory;
import org.eclipse.wb.internal.rcp.model.layout.StackLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class StackLayoutTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        StackLayoutTest.assertInstanceOf(StackLayoutInfo.class, (Object)shell.getLayout());
        StackLayoutTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new StackLayout())/ /new Button(this, SWT.NONE)/}", "  {new: org.eclipse.swt.custom.StackLayout} {empty} {/setLayout(new StackLayout())/}", "  {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(this, SWT.NONE)/}");
    }

    @Test
    public void test_parseEmpty() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "  }", "}");
        shell.refresh();
    }

    @Test
    public void test_setLayout_wasGridLayout() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "  }", "}");
        shell.refresh();
        StackLayoutInfo layout = (StackLayoutInfo)BTestUtils.createLayout("org.eclipse.swt.custom.StackLayout");
        shell.setLayout((LayoutInfo)layout);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "  }", "}");
        StackLayoutTest.assertActiveControl(layout, null);
    }

    @Test
    public void test_visibilityGraphical() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        StackLayoutInfo layout = (StackLayoutInfo)shell.getLayout();
        ControlInfo button_1 = (ControlInfo)StackLayoutTest.getJavaInfoByName("button_1");
        StackLayoutTest.assertSame((Object)button_1, (Object)layout.getActiveControl());
        List children = shell.getPresentation().getChildrenGraphical();
        Assertions.assertThat((List)children).containsExactly((Object[])new ObjectInfo[]{button_1});
    }

    @Test
    public void test_flowContainer() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "  }", "}");
        StackLayoutInfo layout = (StackLayoutInfo)shell.getLayout();
        List canvasContainers = new FlowContainerFactory((JavaInfo)layout, true).get();
        List treeContainers = new FlowContainerFactory((JavaInfo)layout, false).get();
        Assertions.assertThat((List)canvasContainers).isNotEmpty();
        Assertions.assertThat((List)treeContainers).isNotEmpty();
    }

    @Test
    public void test_flowContainer_CREATE_asFirst() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "  }", "}");
        StackLayoutInfo layout = (StackLayoutInfo)shell.getLayout();
        ControlInfo button = BTestUtils.createButton();
        StackLayoutTest.flowContainer_CREATE((JavaInfo)layout, button, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        StackLayoutTest.assertActiveControl(layout, button);
    }

    @Test
    public void test_flowContainer_CREATE_andActivate() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        StackLayoutInfo layout = (StackLayoutInfo)shell.getLayout();
        StackLayoutTest.assertActiveControl(layout, (ControlInfo)shell.getChildrenControls().get(0));
        ControlInfo button = BTestUtils.createButton();
        StackLayoutTest.flowContainer_CREATE((JavaInfo)layout, button, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        StackLayoutTest.assertActiveControl(layout, button);
    }

    @Test
    public void test_flowContainer_MOVE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        StackLayoutInfo layout = (StackLayoutInfo)shell.getLayout();
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(1);
        StackLayoutTest.flowContainer_MOVE((JavaInfo)layout, button_2, button_1);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        StackLayoutTest.assertActiveControl(layout, button_2);
    }

    @Test
    public void test_flowContainer_ADD() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new StackLayout());", "      {", "        Button button_1 = new Button(composite, SWT.NONE);", "      }", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        StackLayoutInfo stackLayout = (StackLayoutInfo)composite.getLayout();
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(1);
        StackLayoutTest.flowContainer_MOVE((JavaInfo)stackLayout, button_2, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new StackLayout());", "      {", "        Button button_1 = new Button(composite, SWT.NONE);", "      }", "      {", "        Button button_2 = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
        StackLayoutTest.assertActiveControl(stackLayout, button_2);
    }

    @Test
    public void test_clipboard() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite c = new Composite(this, SWT.NONE);", "      c.setLayout(new StackLayout());", "      {", "        Button button_1 = new Button(c, SWT.NONE);", "      }", "      {", "        Button button_2 = new Button(c, SWT.NONE);", "      }", "    }", "  }", "}");
        shell.refresh();
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)composite);
        CompositeInfo newComposite = (CompositeInfo)memento.create((JavaInfo)shell);
        fillLayout.command_CREATE((ControlInfo)newComposite, null);
        memento.apply();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite c = new Composite(this, SWT.NONE);", "      c.setLayout(new StackLayout());", "      {", "        Button button_1 = new Button(c, SWT.NONE);", "      }", "      {", "        Button button_2 = new Button(c, SWT.NONE);", "      }", "    }", "    {", "      Composite c = new Composite(this, SWT.NONE);", "      c.setLayout(new StackLayout());", "      {", "        Button button_1 = new Button(c, SWT.NONE);", "      }", "      {", "        Button button_2 = new Button(c, SWT.NONE);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_activeControl() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        StackLayoutInfo layout = (StackLayoutInfo)shell.getLayout();
        List buttons = shell.getChildrenControls();
        ControlInfo button_1 = (ControlInfo)buttons.get(0);
        ControlInfo button_2 = (ControlInfo)buttons.get(1);
        StackLayoutTest.assertActiveControl(layout, button_1);
        boolean shouldRefresh = StackLayoutTest.notifySelecting((ObjectInfo)button_2);
        StackLayoutTest.assertTrue((boolean)shouldRefresh);
        shell.refresh();
        StackLayoutTest.assertActiveControl(layout, button_2);
        shouldRefresh = StackLayoutTest.notifySelecting((ObjectInfo)button_2);
        StackLayoutTest.assertFalse((boolean)shouldRefresh);
    }

    @Test
    public void test_activeControl_whenDelete() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        StackLayoutInfo layout = (StackLayoutInfo)shell.getLayout();
        List buttons = shell.getChildrenControls();
        ControlInfo button_1 = (ControlInfo)buttons.get(0);
        ControlInfo button_2 = (ControlInfo)buttons.get(1);
        ControlInfo button_3 = (ControlInfo)buttons.get(2);
        StackLayoutTest.assertActiveControl(layout, button_1);
        button_1.delete();
        StackLayoutTest.assertActiveControl(layout, button_2);
        button_2.delete();
        StackLayoutTest.assertActiveControl(layout, button_3);
        button_3.delete();
        StackLayoutTest.assertActiveControl(layout, null);
    }

    @Test
    public void test_activeControl_showPrevNext() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new StackLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        StackLayoutInfo layout = (StackLayoutInfo)shell.getLayout();
        ControlInfo button_1 = (ControlInfo)StackLayoutTest.getJavaInfoByName("button_1");
        ControlInfo button_2 = (ControlInfo)StackLayoutTest.getJavaInfoByName("button_2");
        ControlInfo button_3 = (ControlInfo)StackLayoutTest.getJavaInfoByName("button_3");
        StackLayoutTest.assertActiveControl(layout, button_1);
        StackLayoutTest.assertSame((Object)button_3, (Object)layout.getPrevControl());
        layout.show(button_3);
        StackLayoutTest.assertActiveControl(layout, button_3);
        StackLayoutTest.assertSame((Object)button_1, (Object)layout.getNextControl());
        layout.show(button_1);
        StackLayoutTest.assertActiveControl(layout, button_1);
        StackLayoutTest.assertSame((Object)button_2, (Object)layout.getNextControl());
        layout.show(button_2);
        StackLayoutTest.assertActiveControl(layout, button_2);
    }

    private static void assertActiveControl(StackLayoutInfo layout, ControlInfo expected) throws Exception {
        ControlInfo actualControl = layout.getActiveControl();
        StackLayoutTest.assertSame((Object)expected, (Object)actualControl);
    }
}

