/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor;

import java.awt.Component;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.multi.MultiMode;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class SplitModeTest
extends SwingGefTest {
    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        IPreferenceStore preferences = DesignerPlugin.getPreferences();
        preferences.setToDefault("editor.layout");
        preferences.setToDefault("editor.layout.syncDelay");
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_reparse_afterDelay() throws Exception {
        IPreferenceStore preferences = DesignerPlugin.getPreferences();
        preferences.setValue("editor.layout", 2);
        preferences.setValue("editor.layout.syncDelay", 100);
        this.openContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t} // marker\n}");
        this.openSourcePage();
        this.check_isEnabled(true);
        this.m_designerEditor.getSite().getShell().forceActive();
        MultiMode multiMode = (MultiMode)this.m_designerEditor.getMultiMode();
        multiMode.getSourcePage().setFocus();
        IBuffer buffer = this.m_lastEditor.getModelUnit().getBuffer();
        int position = buffer.getContents().indexOf("} // marker");
        buffer.replace(position, 0, "setEnabled(false);");
        this.check_isEnabled(true);
        SplitModeTest.waitEventLoop(1000);
        this.check_isEnabled(false);
    }

    @Test
    public void test_reparse_afterSave() throws Exception {
        IPreferenceStore preferences = DesignerPlugin.getPreferences();
        preferences.setValue("editor.layout", 2);
        preferences.setValue("editor.layout.syncDelay", -1);
        this.openContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t} // marker\n}");
        this.openSourcePage();
        this.check_isEnabled(true);
        IBuffer buffer = this.m_lastEditor.getModelUnit().getBuffer();
        int position = buffer.getContents().indexOf("} // marker");
        buffer.replace(position, 0, "setEnabled(false);");
        this.check_isEnabled(true);
        SplitModeTest.waitEventLoop(300);
        this.check_isEnabled(true);
        this.m_designerEditor.doSave(null);
        this.check_isEnabled(false);
    }

    private void check_isEnabled(boolean expected) {
        this.fetchContentFields();
        SplitModeTest.assertEquals((Object)expected, (Object)((Component)this.m_contentJavaInfo.getObject()).isEnabled());
    }
}

