/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor;

import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.matchers.WithTooltip;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.wb.internal.core.editor.multi.MultiMode;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.jupiter.api.Test;

public class JavaPropertiesToolBarContributorTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_gotoDefinition() throws Exception {
        this.openContainer("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        Object button = JavaPropertiesToolBarContributorTest.getJavaInfoByName("button");
        SWTBot bot = new SWTBot((Widget)this.m_designerEditor.getRootControl());
        JavaPropertiesToolBarContributorTest.assertTrue((boolean)bot.getFinder().findControls(WithTooltip.withTooltip((String)"Goto definition")).isEmpty());
        this.canvas.select(button);
        JavaPropertiesToolBarContributorTest.assertFalse((boolean)bot.getFinder().findControls(WithTooltip.withTooltip((String)"Goto definition")).isEmpty());
        SWTBotToolbarButton toolItem = bot.toolbarButtonWithTooltip("Goto definition");
        toolItem.click();
        JavaPropertiesToolBarContributorTest.waitEventLoop(0);
        MultiMode multiMode = (MultiMode)this.m_designerEditor.getMultiMode();
        JavaPropertiesToolBarContributorTest.assertTrue((boolean)multiMode.isSourceActive());
        int expectedPosition = button.getCreationSupport().getNode().getStartPosition();
        this.assertJavaSelection(expectedPosition, 0);
    }

    @Test
    public void test_convertLocalToField() throws Exception {
        this.openContainer("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        Object button = JavaPropertiesToolBarContributorTest.getJavaInfoByName("button");
        SWTBot bot = new SWTBot((Widget)this.m_designerEditor.getRootControl());
        JavaPropertiesToolBarContributorTest.assertTrue((boolean)bot.getFinder().findControls(WithTooltip.withTooltip((String)"Convert local to field")).isEmpty());
        this.canvas.select(button);
        JavaPropertiesToolBarContributorTest.assertFalse((boolean)bot.getFinder().findControls(WithTooltip.withTooltip((String)"Convert local to field")).isEmpty());
        SWTBotToolbarButton toolItem = bot.toolbarButtonWithTooltip("Convert local to field");
        toolItem.click();
        this.assertEditor("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tprivate JButton button;\n\tpublic Test() {\n\t\t{\n\t\t\tbutton = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        toolItem = bot.toolbarButtonWithTooltip("Convert field to local");
        toolItem.click();
        this.assertEditor("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }
}

