/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.databinding.swing;

import java.util.List;
import org.eclipse.wb.internal.swing.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.swing.databinding.model.bindings.AutoBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.UpdateStrategyInfo;
import org.eclipse.wb.internal.swing.model.component.JPanelInfo;
import org.eclipse.wb.tests.designer.databinding.swing.AbstractBindingTest;
import org.eclipse.wb.tests.designer.databinding.swing.DatabindingTestUtils;
import org.junit.jupiter.api.Test;

public class BindValueTest
extends AbstractBindingTest {
    @Test
    public void test_strategy_policy_variable() throws Exception {
        this.m_waitForAutoBuild = true;
        JPanelInfo shell = DatabindingTestUtils.parseTestSource(this, "public class Test extends JPanel {\n\tpublic static class MyBean {\n\t\tprotected String name;\n\t\tpublic String getName() {\n\t\t\treturn name;\n\t\t}\n\t\tpublic void setName(String newName) {\n\t\t\tthis.name = newName;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tJFrame frame = new JFrame();\n\t\tframe.getContentPane().add(new Test(), BorderLayout.CENTER);\n\t\tframe.setMinimumSize(new Dimension(500, 500));\n\t\tframe.setVisible(true);\n\t\tframe.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);\n\t}\n\tprotected MyBean myBean = new MyBean();\n\tprivate JLabel label;\n\tprivate JTextField textField;\n\tprivate JButton button;\n\tpublic Test() {\n\t\tlabel = new JLabel();\n\t\tadd(label);\n\t\ttextField = new JTextField();\n\t\tadd(textField);\n\t\tbutton = new JButton();\n\t\tadd(button);\n\t\tinitDataBindings();\n\t}\n\tAutoBinding.UpdateStrategy m_strategy = AutoBinding.UpdateStrategy.READ_ONCE;\n\tprotected void initDataBindings() {\n\t\t{\n\t\t\tBeanProperty<MyBean, String> modelBeanProperty = BeanProperty.create(\"name\");\n\t\t\tBeanProperty<JLabel, String> labelBeanProperty = BeanProperty.create(\"text\");\n\t\t\tAutoBinding.UpdateStrategy strategy = AutoBinding.UpdateStrategy.READ;\n\t\t\tAutoBinding<MyBean, String, JLabel, String> autoBinding = Bindings.createAutoBinding(\n\t\t\t\tstrategy, myBean, modelBeanProperty, label, labelBeanProperty);\n\t\t\tautoBinding.bind();\n\t\t}\n\t\t{\n\t\t\tBeanProperty<MyBean, String> modelBeanProperty = BeanProperty.create(\"name\");\n\t\t\tBeanProperty<JTextField, String> textFieldBeanProperty = BeanProperty.create(\"text\");\n\t\t\tAutoBinding<MyBean, String, JTextField, String> autoBinding = Bindings.createAutoBinding(\n\t\t\t\tAutoBinding.UpdateStrategy.READ_WRITE, myBean, modelBeanProperty, textField, textFieldBeanProperty);\n\t\t\tautoBinding.bind();\n\t\t}\n\t\t{\n\t\t\tBeanProperty<MyBean, String> modelBeanProperty = BeanProperty.create(\"name\");\n\t\t\tBeanProperty<JButton, String> buttonBeanProperty = BeanProperty.create(\"text\");\n\t\t\tAutoBinding<MyBean, String, JButton, String> autoBinding = Bindings.createAutoBinding(\n\t\t\t\tm_strategy, myBean, modelBeanProperty, button, buttonBeanProperty);\n\t\t\tautoBinding.bind();\n\t\t}\n\t}\n}");
        BindValueTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        List bindings = provider.getBindings();
        BindValueTest.assertNotNull((Object)bindings);
        BindValueTest.assertEquals((int)3, (int)bindings.size());
        BindValueTest.assertInstanceOf(AutoBindingInfo.class, bindings.get(0));
        AutoBindingInfo binding = (AutoBindingInfo)bindings.get(0);
        UpdateStrategyInfo strategyInfo = binding.getStrategyInfo();
        BindValueTest.assertEquals((Object)"READ", (Object)strategyInfo.getStrategyValue());
        BindValueTest.assertInstanceOf(AutoBindingInfo.class, bindings.get(1));
        binding = (AutoBindingInfo)bindings.get(1);
        strategyInfo = binding.getStrategyInfo();
        BindValueTest.assertEquals((Object)"READ_WRITE", (Object)strategyInfo.getStrategyValue());
        BindValueTest.assertInstanceOf(AutoBindingInfo.class, bindings.get(2));
        binding = (AutoBindingInfo)bindings.get(2);
        strategyInfo = binding.getStrategyInfo();
        BindValueTest.assertEquals((Object)"READ_ONCE", (Object)strategyInfo.getStrategyValue());
    }
}

