/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util.generic;

import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.property.ITypedProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.IntegerPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.StringListPropertyEditor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class ModelMethodPropertyTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    private void prepareMyPanel(String parameters) throws Exception {
        this.prepareMyPanel0(parameters + " type=java.lang.String");
    }

    private void prepareMyPanel0(String parameters) throws Exception {
        ModelMethodPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  // filler", "}"));
        ModelMethodPropertyTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ModelMethodPropertyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <model class='" + MyModel.class.getName() + "'/>", "  <parameters>", "    <parameter name='modelMethodProperty " + parameters + "'/>", "  </parameters>", "</component>"));
        ModelMethodPropertyTest.waitForAutoBuild();
    }

    @Test
    public void test_valueProperty() throws Exception {
        this.prepareMyPanel("getter=getValue setter=setValue title=value category=normal");
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ModelMethodPropertyTest.assertNoErrors((JavaInfo)panel);
        Property property = panel.getPropertyByTitle("value");
        ModelMethodPropertyTest.assertNotNull((Object)property);
        ModelMethodPropertyTest.assertSame((Object)PropertyCategory.NORMAL, (Object)property.getCategory());
        ModelMethodPropertyTest.assertSame(String.class, (Object)((ITypedProperty)property).getType());
        ModelMethodPropertyTest.assertTrue((boolean)property.isModified());
        ModelMethodPropertyTest.assertEquals((Object)"abc", (Object)property.getValue());
        property.setValue((Object)"123");
        ModelMethodPropertyTest.assertEquals((Object)"123", (Object)property.getValue());
        ModelMethodPropertyTest.assertSame((Object)property, (Object)panel.getPropertyByTitle("value"));
    }

    @Test
    public void test_primitiveType() throws Exception {
        this.prepareMyPanel0("getter=getValue setter=setValue title=value type=int");
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ModelMethodPropertyTest.assertNoErrors((JavaInfo)panel);
        Property property = panel.getPropertyByTitle("value");
        ModelMethodPropertyTest.assertNotNull((Object)property);
        ModelMethodPropertyTest.assertSame((Object)IntegerPropertyEditor.INSTANCE, (Object)property.getEditor());
        ModelMethodPropertyTest.assertSame(Integer.TYPE, (Object)((ITypedProperty)property).getType());
    }

    @Test
    public void test_propertyEditor_StringList() throws Exception {
        this.prepareMyPanel("getter=getValue setter=setValue title=value editor=strings(A,B,C)");
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ModelMethodPropertyTest.assertNoErrors((JavaInfo)panel);
        Property property = panel.getPropertyByTitle("value");
        ModelMethodPropertyTest.assertNotNull((Object)property);
        PropertyEditor propertyEditor = property.getEditor();
        ModelMethodPropertyTest.assertInstanceOf(StringListPropertyEditor.class, (Object)propertyEditor);
        Object[] strings = (String[])ReflectionUtils.getFieldObject((Object)propertyEditor, (String)"m_strings");
        ModelMethodPropertyTest.assertArrayEquals((Object[])strings, (Object[])new String[]{"A", "B", "C"});
    }

    @Test
    public void test_noRequiredParameters_getter() throws Exception {
        this.prepareMyPanel("_getter=getValue setter=setValue title=value");
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        List warnings = this.m_lastState.getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
        Assertions.assertThat((String)((EditorWarning)warnings.get(0)).getMessage()).contains(new CharSequence[]{"'getter'"});
    }

    @Test
    public void test_noRequiredParameters_setter() throws Exception {
        this.prepareMyPanel("getter=getValue _setter=setValue title=value");
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        List warnings = this.m_lastState.getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
        Assertions.assertThat((String)((EditorWarning)warnings.get(0)).getMessage()).contains(new CharSequence[]{"'setter'"});
    }

    @Test
    public void test_noRequiredParameters_title() throws Exception {
        this.prepareMyPanel("getter=getValue setter=setValue _title=value");
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        List warnings = this.m_lastState.getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
        Assertions.assertThat((String)((EditorWarning)warnings.get(0)).getMessage()).contains(new CharSequence[]{"'title'"});
    }

    @Test
    public void test_invalidParameter_getter() throws Exception {
        this.prepareMyPanel("getter=noSuchMethod setter=foo title=bar");
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        List warnings = this.m_lastState.getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((EditorWarning)warnings.get(0)).getMessage()).contains(new CharSequence[]{"Invalid"})).contains(new CharSequence[]{"getter"});
    }

    @Test
    public void test_invalidParameter_setter() throws Exception {
        this.prepareMyPanel("getter=getValue setter=noSuchMethod title=bar");
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        List warnings = this.m_lastState.getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((EditorWarning)warnings.get(0)).getMessage()).contains(new CharSequence[]{"Invalid"})).contains(new CharSequence[]{"setter"});
    }

    public static class MyModel
    extends ContainerInfo {
        private String m_value = "abc";

        public MyModel(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
            super(editor, description, creationSupport);
        }

        public Object getValue() {
            return this.m_value;
        }

        public void setValue(Object value) {
            this.m_value = (String)value;
        }
    }
}

