/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.order.TabOrderInfo;
import org.eclipse.wb.internal.core.model.property.order.TabOrderProperty;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipTextProvider;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class TabOrderPropertyTest
extends SwingModelTest {
    @Test
    public void test_common() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "  }", "}");
        TestTabOrderProperty property = new TestTabOrderProperty((JavaInfo)panel, null, null, null, null);
        TabOrderPropertyTest.assertEquals((Object)"tab order", (Object)property.getTitle());
        TabOrderPropertyTest.assertFalse((boolean)property.isModified());
    }

    @Test
    public void test_tooltip() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "  }", "}");
        TestTabOrderProperty property = new TestTabOrderProperty((JavaInfo)panel, null, null, null, null);
        TabOrderPropertyTest.assertNull((Object)property.getAdapter(Object.class));
        TabOrderPropertyTest.assertNull((Object)property.getAdapter(PropertyTooltipProvider.class));
        property = new TestTabOrderProperty((JavaInfo)panel, null, null, null, "Tooltip");
        TabOrderPropertyTest.assertNull((Object)property.getAdapter(Object.class));
        PropertyTooltipProvider tooltipProvider = (PropertyTooltipProvider)property.getAdapter(PropertyTooltipProvider.class);
        TabOrderPropertyTest.assertInstanceOf(PropertyTooltipTextProvider.class, (Object)tooltipProvider);
        TabOrderPropertyTest.assertNotNull((Object)ReflectionUtils.invokeMethod((Object)tooltipProvider, (String)"getText(org.eclipse.wb.internal.core.model.property.Property)", (Object[])new Object[]{property}));
    }

    @Test
    public void test_noValue() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "    JLabel label = new JLabel();", "    add(label);", "  }", "}");
        panel.refresh();
        TabOrderPropertyTest.assertEquals((int)2, (int)panel.getChildrenComponents().size());
        ArrayList<AbstractComponentInfo> defaultControls = new ArrayList<AbstractComponentInfo>();
        defaultControls.add((AbstractComponentInfo)panel.getChildrenComponents().get(0));
        TestTabOrderProperty property = new TestTabOrderProperty((JavaInfo)panel, panel.getChildrenComponents(), defaultControls, null, null);
        Object value = property.getValue();
        TabOrderPropertyTest.assertNotNull((Object)value);
        TabOrderPropertyTest.assertInstanceOf(TabOrderInfo.class, (Object)value);
        TabOrderInfo orderInfo = (TabOrderInfo)value;
        TabOrderPropertyTest.assertEquals((Object)"", (Object)property.getDisplayText());
        TabOrderPropertyTest.assertEquals((int)2, (int)orderInfo.getInfos().size());
        TabOrderPropertyTest.assertSame(panel.getChildrenComponents().get(0), orderInfo.getInfos().get(0));
        TabOrderPropertyTest.assertSame(panel.getChildrenComponents().get(1), orderInfo.getInfos().get(1));
        TabOrderPropertyTest.assertEquals((int)1, (int)orderInfo.getOrderedInfos().size());
        TabOrderPropertyTest.assertSame(panel.getChildrenComponents().get(0), orderInfo.getOrderedInfos().get(0));
        TabOrderPropertyTest.assertEquals((Object)"", (Object)TabOrderPropertyTest.getPropertyText((Property)property));
    }

    @Test
    public void test_value() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "    JComboBox combo = new JComboBox();", "    add(combo);", "    JLabel label = new JLabel();", "    add(label);", "    setTabOrder(new JComponent[]{label, button});", "  }", "  public void setTabOrder(JComponent []orders) {", "  }", "}");
        panel.refresh();
        TabOrderPropertyTest.assertEquals((int)3, (int)panel.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo combo = (ComponentInfo)panel.getChildrenComponents().get(1);
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(2);
        ArrayList<ComponentInfo> defaultControls = new ArrayList<ComponentInfo>();
        defaultControls.add(button);
        TypeDeclaration type = (TypeDeclaration)this.m_lastEditor.getAstUnit().types().get(0);
        ExpressionStatement statement = (ExpressionStatement)type.getMethods()[0].getBody().statements().get(6);
        MethodInvocation invocation = (MethodInvocation)statement.getExpression();
        ArrayCreation creation = (ArrayCreation)invocation.arguments().get(0);
        TestTabOrderProperty property = new TestTabOrderProperty((JavaInfo)panel, panel.getChildrenComponents(), defaultControls, creation.getInitializer(), null);
        TabOrderPropertyTest.assertTrue((boolean)property.isModified());
        TabOrderPropertyTest.assertEquals((Object)"[label, button]", (Object)TabOrderPropertyTest.getPropertyText((Property)property));
        Object value = property.getValue();
        TabOrderPropertyTest.assertNotNull((Object)value);
        TabOrderPropertyTest.assertInstanceOf(TabOrderInfo.class, (Object)value);
        TabOrderInfo orderInfo = (TabOrderInfo)value;
        TabOrderPropertyTest.assertEquals((Object)"[label, button]", (Object)property.getDisplayText());
        TabOrderPropertyTest.assertEquals((int)3, (int)orderInfo.getInfos().size());
        TabOrderPropertyTest.assertSame((Object)label, orderInfo.getInfos().get(0));
        TabOrderPropertyTest.assertSame((Object)button, orderInfo.getInfos().get(1));
        TabOrderPropertyTest.assertSame((Object)combo, orderInfo.getInfos().get(2));
        TabOrderPropertyTest.assertEquals((int)2, (int)orderInfo.getOrderedInfos().size());
        TabOrderPropertyTest.assertSame((Object)label, orderInfo.getOrderedInfos().get(0));
        TabOrderPropertyTest.assertSame((Object)button, orderInfo.getOrderedInfos().get(1));
        TabOrderPropertyTest.assertFalse((boolean)property.assert_isRemoveFlag());
        TabOrderPropertyTest.assertNull((Object)property.assert_getSource());
        property.setValue(Property.UNKNOWN_VALUE);
        TabOrderPropertyTest.assertTrue((boolean)property.assert_isRemoveFlag());
        TabOrderPropertyTest.assertNull((Object)property.assert_getSource());
        property.assert_clearState();
        orderInfo.getOrderedInfos().clear();
        property.setValue(orderInfo);
        TabOrderPropertyTest.assertTrue((boolean)property.assert_isRemoveFlag());
        TabOrderPropertyTest.assertNull((Object)property.assert_getSource());
        property.assert_clearState();
        orderInfo.getOrderedInfos().add(button);
        orderInfo.getOrderedInfos().add(label);
        property.setValue(orderInfo);
        String expected = TemplateUtils.format((String)"'{'{0}, {1}'}'", (Object[])new Object[]{button, label});
        TabOrderPropertyTest.assertTrue((boolean)property.assert_isRemoveFlag());
        TabOrderPropertyTest.assertEquals((Object)expected, (Object)property.assert_getSource());
        property.assert_clearState();
    }

    private static class TestTabOrderProperty
    extends TabOrderProperty {
        private final List<? extends AbstractComponentInfo> m_allInfos;
        private final List<? extends AbstractComponentInfo> m_defaultInfos;
        private final ArrayInitializer m_initializer;
        private final String m_tooltip;
        private String m_source;
        private boolean m_removeFlag;

        public TestTabOrderProperty(JavaInfo container, List<? extends AbstractComponentInfo> allInfos, List<? extends AbstractComponentInfo> defaultInfos, ArrayInitializer initializer, String tooltip) {
            super(container);
            this.m_allInfos = allInfos != null ? allInfos : Collections.emptyList();
            this.m_defaultInfos = defaultInfos;
            this.m_initializer = initializer;
            this.m_tooltip = tooltip;
        }

        protected ArrayInitializer getOrderedArray() throws Exception {
            return this.m_initializer;
        }

        protected List<? extends AbstractComponentInfo> getTabPossibleChildren() throws Exception {
            return this.m_allInfos;
        }

        protected boolean isDefaultOrdered(AbstractComponentInfo component) throws Exception {
            return this.m_defaultInfos.contains(component);
        }

        protected void removePropertyAssociation() throws Exception {
            this.m_removeFlag = true;
        }

        protected void setOrderedArraySource(String source) throws Exception {
            this.m_source = source;
        }

        public boolean assert_isRemoveFlag() {
            return this.m_removeFlag;
        }

        public String assert_getSource() {
            return this.m_source;
        }

        public void assert_clearState() {
            this.m_removeFlag = false;
            this.m_source = null;
        }

        protected String getPropertyTooltipText() {
            return this.m_tooltip;
        }

        protected MethodInvocation getMethodInvocation() {
            return null;
        }
    }
}

