/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property;

import org.eclipse.wb.internal.core.model.property.EmptyProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.BooleanPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.IntegerPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class EmptyPropertyTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_defaultEditor() throws Exception {
        EmptyProperty property = new EmptyProperty();
        EmptyPropertyTest.assertSame((Object)BooleanPropertyEditor.INSTANCE, (Object)property.getEditor());
        EmptyPropertyTest.assertOtherFeatures((Property)property);
    }

    @Test
    public void test_myEditor() throws Exception {
        EmptyProperty property = new EmptyProperty((PropertyEditor)IntegerPropertyEditor.INSTANCE);
        EmptyPropertyTest.assertSame((Object)IntegerPropertyEditor.INSTANCE, (Object)property.getEditor());
        EmptyPropertyTest.assertOtherFeatures((Property)property);
    }

    private static void assertOtherFeatures(Property property) throws Exception {
        EmptyPropertyTest.assertNull((Object)property.getTitle());
        EmptyPropertyTest.assertFalse((boolean)property.isModified());
        EmptyPropertyTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)property.getValue());
        property.setValue(new Object());
        EmptyPropertyTest.assertFalse((boolean)property.isModified());
        EmptyPropertyTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)property.getValue());
    }
}

