/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.WrapperMethodInfo;
import org.eclipse.wb.core.model.association.WrappedObjectAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.WrapperMethodControlCreationSupport;
import org.eclipse.wb.internal.core.model.creation.WrapperMethodCreationSupport;
import org.eclipse.wb.internal.core.model.generation.GenerationSettings;
import org.eclipse.wb.internal.core.model.variable.WrapperMethodControlVariableSupport;
import org.eclipse.wb.internal.core.model.variable.description.FieldUniqueVariableDescription;
import org.eclipse.wb.internal.core.parser.JavaInfoResolver;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JPanelInfo;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class WrapperInfoTest
extends SwingModelTest {
    private static String COMPONENTS_HIERARCHY_PROVIDERS_POINT_ID = "org.eclipse.wb.core.componentsHierarchyProviders";

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_isWrapper_forInterface() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "      // filler", "  }", "}");
        WrapperInfoTest.assertFalse((boolean)WrapperMethodInfo.isWrapper((AstEditor)this.m_lastEditor, List.class));
    }

    @Test
    public void test_parse_noControl() throws Exception {
        WrapperInfoTest.configureWrapperContents();
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    TestWrapper wrapper = new TestWrapper(this);", "  }", "}");
        WrapperInfoTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/new TestWrapper(this)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {viewer: public javax.swing.JButton test.TestWrapper.getControl()} {viewer} {}", "    {new: test.TestWrapper} {local-unique: wrapper} {/new TestWrapper(this)/}");
        ComponentInfo wrappedComponent = (ComponentInfo)container.getChildrenComponents().get(0);
        WrapperInfoTest.assertInstanceOf(WrappedObjectAssociation.class, (Object)wrappedComponent.getAssociation());
        WrapperInfoTest.assertInstanceOf(WrapperMethodControlCreationSupport.class, (Object)wrappedComponent.getCreationSupport());
        WrapperInfoTest.assertInstanceOf(WrapperMethodControlVariableSupport.class, (Object)wrappedComponent.getVariableSupport());
        WrapperMethodInfo wrapper = (WrapperMethodInfo)wrappedComponent.getChildren(WrapperMethodInfo.class).get(0);
        WrapperInfoTest.assertSame((Object)wrapper.getWrapper().getWrappedInfo(), (Object)wrappedComponent);
    }

    @Test
    public void test_deleteWrapper() throws Exception {
        WrapperInfoTest.configureWrapperContents();
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    TestWrapper wrapper = new TestWrapper(this);", "    JButton button = wrapper.getControl();", "    button.setEnabled(false);", "  }", "  // filler filler filler", "}");
        WrapperInfoTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/new TestWrapper(this)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {viewer: public javax.swing.JButton test.TestWrapper.getControl()} {local-unique: button} {/wrapper.getControl()/ /button.setEnabled(false)/}", "    {new: test.TestWrapper} {local-unique: wrapper} {/new TestWrapper(this)/ /wrapper.getControl()/}");
        ComponentInfo wrapped = (ComponentInfo)container.getChildrenComponents().get(0);
        WrapperMethodInfo wrapper = (WrapperMethodInfo)wrapped.getChildren(WrapperMethodInfo.class).get(0);
        WrapperInfoTest.assertTrue((boolean)wrapper.canDelete());
        wrapper.delete();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "  }", "  // filler filler filler", "}");
    }

    @Test
    public void test_deleteWrapped() throws Exception {
        WrapperInfoTest.configureWrapperContents();
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    TestWrapper wrapper = new TestWrapper(this);", "    JButton button = wrapper.getControl();", "    button.setEnabled(false);", "  }", "  // filler filler filler", "}");
        WrapperInfoTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/new TestWrapper(this)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {viewer: public javax.swing.JButton test.TestWrapper.getControl()} {local-unique: button} {/wrapper.getControl()/ /button.setEnabled(false)/}", "    {new: test.TestWrapper} {local-unique: wrapper} {/new TestWrapper(this)/ /wrapper.getControl()/}");
        ComponentInfo wrapped = (ComponentInfo)container.getChildrenComponents().get(0);
        WrapperInfoTest.assertTrue((boolean)wrapped.canDelete());
        wrapped.delete();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "  }", "  // filler filler filler", "}");
    }

    @Test
    public void test_parse_aroundControl() throws Exception {
        WrapperInfoTest.configureWrapperContents();
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton panel = new JButton();", "    TestWrapper wrapper = new TestWrapper(panel);", "    add(panel);", "  }", "}");
        Assertions.assertThat((List)container.getChildren(WrapperMethodInfo.class)).isEmpty();
        ContainerInfo wrappedComponent = (ContainerInfo)container.getChildren(ContainerInfo.class).get(0);
        WrapperMethodInfo wrapper = (WrapperMethodInfo)wrappedComponent.getChildren(WrapperMethodInfo.class).get(0);
        WrapperInfoTest.assertSame((Object)wrapper.getWrapper().getWrappedInfo(), (Object)wrappedComponent);
        WrapperInfoTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(panel)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: panel} {/new JButton()/ /new TestWrapper(panel)/ /add(panel)/}", "    {new: test.TestWrapper} {local-unique: wrapper} {/new TestWrapper(panel)/}");
    }

    @Test
    public void test_materialize() throws Exception {
        WrapperInfoTest.configureWrapperContents();
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    TestWrapper wrapper = new TestWrapper(this);", "  }", "}");
        Assertions.assertThat((List)container.getChildren(WrapperMethodInfo.class)).isEmpty();
        ContainerInfo wrappedComponent = (ContainerInfo)container.getChildren(ContainerInfo.class).get(0);
        wrappedComponent.getChildren(WrapperMethodInfo.class).get(0);
        wrappedComponent.getPropertyByTitle("text").setValue((Object)"test");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    TestWrapper wrapper = new TestWrapper(this);", "    JButton button = wrapper.getControl();", "    button.setText('test');", "  }", "}");
    }

    @Test
    public void test_CREATE() throws Exception {
        WrapperInfoTest.configureWrapperContents();
        ContainerInfo container = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        WrapperMethodInfo wrapperInfo = (WrapperMethodInfo)WrapperInfoTest.createJavaInfo("test.TestWrapper");
        JavaInfo wrappedInfo = wrapperInfo.getWrapper().getWrappedInfo();
        CreationSupport creationSupport = wrappedInfo.getCreationSupport();
        WrapperInfoTest.assertInstanceOf(WrapperMethodCreationSupport.class, (Object)creationSupport);
        WrapperInfoTest.assertEquals((Object)"method: public javax.swing.JButton test.TestWrapper.getControl()", (Object)creationSupport.toString());
        ASTNode node = creationSupport.getNode();
        WrapperInfoTest.assertNull((Object)node);
        WrapperInfoTest.assertFalse((boolean)creationSupport.isJavaInfo(null));
        WrapperInfoTest.assertFalse((boolean)creationSupport.canReorder());
        WrapperInfoTest.assertFalse((boolean)creationSupport.canReparent());
        JavaInfoUtils.add((JavaInfo)wrappedInfo, null, (JavaInfo)container, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      TestWrapper testWrapper = new TestWrapper(this);", "      JButton button = testWrapper.getControl();", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_useFieldVariable() throws Exception {
        WrapperInfoTest.configureWrapperContents();
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "  }", "  // filler", "}"};
        ContainerInfo container = this.parseContainer(lines);
        WrapperMethodInfo wrapper = (WrapperMethodInfo)WrapperInfoTest.createJavaInfo("test.TestWrapper");
        JavaInfo wrapped = wrapper.getWrapper().getWrappedInfo();
        GenerationSettings settings = wrapper.getDescription().getToolkit().getGenerationSettings();
        settings.setVariable(FieldUniqueVariableDescription.INSTANCE);
        JavaInfoUtils.add((JavaInfo)wrapped, null, (JavaInfo)container, null);
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  private TestWrapper testWrapper;", "  public Test() {", "    {", "      testWrapper = new TestWrapper(this);", "      button = testWrapper.getControl();", "    }", "  }", "  // filler", "}");
    }

    @Test
    public void test_MOVE_noControl() throws Exception {
        WrapperInfoTest.configureWrapperContents();
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    TestWrapper wrapper = new TestWrapper(this);", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "    }", "  }", "}");
        ContainerInfo wrappedComponent = (ContainerInfo)container.getChildren(ContainerInfo.class).get(0);
        WrapperMethodInfo wrapper = (WrapperMethodInfo)wrappedComponent.getChildren(WrapperMethodInfo.class).get(0);
        JPanelInfo panel = (JPanelInfo)container.getChildren(JPanelInfo.class).get(0);
        JavaInfoUtils.move((JavaInfo)wrapper, null, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      TestWrapper wrapper = new TestWrapper(panel);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_withControl() throws Exception {
        WrapperInfoTest.configureWrapperContents();
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    TestWrapper wrapper = new TestWrapper(this);", "    JButton button = wrapper.getControl();", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "    }", "  }", "}");
        ContainerInfo wrappedComponent = (ContainerInfo)container.getChildren(ContainerInfo.class).get(0);
        WrapperMethodInfo wrapper = (WrapperMethodInfo)wrappedComponent.getChildren(WrapperMethodInfo.class).get(0);
        JPanelInfo panel = (JPanelInfo)container.getChildren(JPanelInfo.class).get(0);
        JavaInfoUtils.move((JavaInfo)wrapper, null, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      TestWrapper wrapper = new TestWrapper(panel);", "      JButton button = wrapper.getControl();", "    }", "  }", "}");
    }

    @Test
    public void test_clipboard() throws Exception {
        WrapperInfoTest.configureWrapperContents();
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel_1 = new JPanel();", "      add(panel_1);", "      TestWrapper wrapper = new TestWrapper(panel_1);", "      JButton button = wrapper.getControl();", "    }", "    {", "      JPanel panel_2 = new JPanel();", "      add(panel_2);", "    }", "  }", "}");
        container.refresh();
        JPanelInfo panel_1 = (JPanelInfo)container.getChildren(JPanelInfo.class).get(0);
        ContainerInfo wrappedComponent = (ContainerInfo)panel_1.getChildren(ContainerInfo.class).get(0);
        JPanelInfo panel_2 = (JPanelInfo)container.getChildren(JPanelInfo.class).get(1);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)wrappedComponent);
        ComponentInfo newComponent = (ComponentInfo)memento.create((JavaInfo)container);
        JavaInfoUtils.add((JavaInfo)newComponent, null, (JavaInfo)panel_2, null);
        memento.apply();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel_1 = new JPanel();", "      add(panel_1);", "      TestWrapper wrapper = new TestWrapper(panel_1);", "      JButton button = wrapper.getControl();", "    }", "    {", "      JPanel panel_2 = new JPanel();", "      add(panel_2);", "      {", "        TestWrapper wrapper = new TestWrapper(panel_2);", "        JButton button = wrapper.getControl();", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_exposed() throws Exception {
        WrapperInfoTest.setFileContentSrc("test/MyViewer.java", this.getTestSource("public class MyViewer extends java.awt.Component {", "  private JButton button;", "  public MyViewer(Container container) {", "    button = new JButton();", "    container.add(button);", "  }", "  public JButton getButton() {", "    return button;", "  }", "}"));
        WrapperInfoTest.setFileContentSrc("test/MyViewer.wbp-component.xml", WrapperInfoTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <model class='" + WrapperMethodInfo.class.getName() + "'/>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "  <parameters>", "    <parameter name='Wrapper.method'>getButton</parameter>", "  </parameters>", "</component>"));
        WrapperInfoTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private MyViewer viewer;", "  public MyPanel() {", "    viewer = new MyViewer(this);", "  }", "  public MyViewer getViewer() {", "    return viewer;", "  }", "}"));
        WrapperInfoTest.waitForAutoBuild();
        TestUtils.addDynamicExtension(COMPONENTS_HIERARCHY_PROVIDERS_POINT_ID, "  <provider class='" + SwingViewer_HierarchyProvider.class.getName() + "'/>");
        try {
            this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "    myPanel.getViewer();", "  }", "}");
            WrapperInfoTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(myPanel)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyPanel} {local-unique: myPanel} {/new MyPanel()/ /add(myPanel)/ /myPanel.getViewer()/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {viewer: public javax.swing.JButton test.MyViewer.getButton()} {viewer} {}", "      {method: public test.MyViewer test.MyPanel.getViewer()} {property} {/myPanel.getViewer()/}");
            this.refresh();
            Object viewer = WrapperInfoTest.getJavaInfoByName("getViewer()");
            MethodInvocation invocation = this.getNode("getViewer()", MethodInvocation.class);
            WrapperInfoTest.assertSame(viewer, (Object)JavaInfoResolver.getJavaInfo((JavaInfo)this.m_lastParseInfo, (Expression)invocation));
            ComponentInfo button = (ComponentInfo)viewer.getParent();
            button.delete();
            WrapperInfoTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(myPanel)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyPanel} {local-unique: myPanel} {/new MyPanel()/ /add(myPanel)/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {viewer: public javax.swing.JButton test.MyViewer.getButton()} {viewer} {}", "      {method: public test.MyViewer test.MyPanel.getViewer()} {property} {}");
        }
        finally {
            TestUtils.removeDynamicExtension(COMPONENTS_HIERARCHY_PROVIDERS_POINT_ID);
        }
    }

    public static void configureWrapperContents() throws Exception {
        WrapperInfoTest.setFileContentSrc("test/TestWrapper.java", WrapperInfoTest.getSource("package test;", "import java.awt.*;", "import javax.swing.*;", "public class TestWrapper {", "  JButton m_control;", "  public TestWrapper(Container parent){", "    m_control = new JButton();", "    m_control.setBounds(10, 10, 10, 10);", "    parent.add(m_control);", "  }", "  public TestWrapper(JButton button){", "    m_control = button;", "  }", "  public JButton getControl(){", "    return m_control;", "  }", "}"));
        WrapperInfoTest.setFileContentSrc("test/TestWrapper.wbp-component.xml", WrapperInfoTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <toolkit id='org.eclipse.wb.swing'/>", "  <model class='" + WrapperMethodInfo.class.getName() + "'/>", "  <creation>", "    <source><![CDATA[new test.TestWrapper(%parent%)]]></source>", "  </creation>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "    <constructor>", "      <parameter type='javax.swing.JButton' parent='true'>", "        <tag name='Wrapper.wrapped' value='true'/>", "      </parameter>", "    </constructor>", "  </constructors>", "  <parameters>", "    <parameter name='Wrapper.method'>getControl</parameter>", "  </parameters>", "</component>"));
        WrapperInfoTest.waitForAutoBuild();
    }

    public static final class SwingViewer_HierarchyProvider
    extends JavaInfoUtils.HierarchyProvider {
        public Object getParentObject(Object object) throws Exception {
            if (ReflectionUtils.isSuccessorOf(object.getClass(), (String)"test.MyViewer")) {
                Object control = ReflectionUtils.invokeMethod((Object)object, (String)"getButton()", (Object[])new Object[0]);
                return ReflectionUtils.invokeMethod((Object)control, (String)"getParent()", (Object[])new Object[0]);
            }
            return null;
        }

        public void add(JavaInfo host, JavaInfo exposed) throws Exception {
            Class componentClass = exposed.getDescription().getComponentClass();
            if (ReflectionUtils.isSuccessorOf((Class)componentClass, (String)"test.MyViewer")) {
                ((WrapperMethodInfo)exposed).getWrapper().configureHierarchy(host);
            }
        }
    }
}

