/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.ui.providers;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.util.Collection;
import javax.swing.Icon;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.internal.swing.databinding.Activator;

public final class TypeImageProvider {
    public static final ImageDescriptor OBJECT_IMAGE = Activator.getImageDescriptor("types/Object.png");
    public static final ImageDescriptor STRING_IMAGE = Activator.getImageDescriptor("types/String.png");
    public static final ImageDescriptor BOOLEAN_IMAGE = Activator.getImageDescriptor("types/Boolean.png");
    public static final ImageDescriptor NUMBER_IMAGE = Activator.getImageDescriptor("types/Number.png");
    public static final ImageDescriptor IMAGE_IMAGE = Activator.getImageDescriptor("types/Image.png");
    public static final ImageDescriptor COLOR_IMAGE = Activator.getImageDescriptor("types/Color.png");
    public static final ImageDescriptor FONT_IMAGE = Activator.getImageDescriptor("types/Font.png");
    public static final ImageDescriptor ARRAY_IMAGE = Activator.getImageDescriptor("types/Array.png");
    public static final ImageDescriptor COLLECTION_IMAGE = Activator.getImageDescriptor("types/Collection.png");
    public static final ImageDescriptor EL_PROPERTY_IMAGE = Activator.getImageDescriptor("el_property2.gif");
    public static final ImageDescriptor OBJECT_PROPERTY_IMAGE = Activator.getImageDescriptor("SelfObject.png");

    public static ImageDescriptor getImageDescriptor(Class<?> type) {
        if (type == null) {
            return OBJECT_IMAGE;
        }
        if (type == String.class || type == Byte.TYPE || type == Character.TYPE) {
            return STRING_IMAGE;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return BOOLEAN_IMAGE;
        }
        if (type == Integer.TYPE || type == Short.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE) {
            return NUMBER_IMAGE;
        }
        if (type.isArray()) {
            return ARRAY_IMAGE;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return COLLECTION_IMAGE;
        }
        if (type == Image.class || type == Icon.class) {
            return IMAGE_IMAGE;
        }
        if (type == Color.class) {
            return COLOR_IMAGE;
        }
        if (type == Font.class) {
            return FONT_IMAGE;
        }
        return OBJECT_IMAGE;
    }
}

