/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.property.editor.image.ImagePropertyEditor;
import org.eclipse.wb.tests.designer.swt.model.property.ImagePropertyEditorTest;
import org.eclipse.wb.tests.designer.swt.model.property.PropertyEditorTestUtils;
import org.eclipse.wb.tests.designer.tests.common.GenericPropertyNoValue;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ImagePropertyEditorTestNoManager
extends ImagePropertyEditorTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", false);
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_textSource_noValue() throws Exception {
        GenericPropertyNoValue property = new GenericPropertyNoValue(null, null, ImagePropertyEditor.INSTANCE);
        ImagePropertyEditorTestNoManager.assertNull((Object)PropertyEditorTestUtils.getText((Property)property));
        ImagePropertyEditorTestNoManager.assertNull((Object)PropertyEditorTestUtils.getClipboardSource((Property)property));
    }

    @Test
    public void test_textSource_nullValue() throws Exception {
        this.assert_getText_getClipboardSource_forSource("null", "(null)", "null");
    }

    @Test
    public void test_textSource_absolutePath() throws Exception {
        File file = ImagePropertyEditorTestNoManager.createTempImage();
        try {
            String path = FilenameUtils.separatorsToUnix((String)file.getCanonicalPath());
            this.assert_getText_getClipboardSource_forSource("new Image(null, \"" + path + "\")", "File: " + path, "new org.eclipse.swt.graphics.Image(null, \"" + path + "\")");
        }
        finally {
            file.delete();
        }
    }

    @Ignore
    @Test
    public void test_textSource_image_over_classpath() throws Exception {
        this.assert_getText_getClipboardSource_forSource("new Image(null, getClass().getResourceAsStream(\"/javax/swing/plaf/basic/icons/JavaCup16.png\"))", "Classpath: /javax/swing/plaf/basic/icons/JavaCup16.png", "new org.eclipse.swt.graphics.Image(null, {wbp_classTop}.getResourceAsStream(\"/javax/swing/plaf/basic/icons/JavaCup16.png\"))");
    }

    @Ignore
    @Test
    public void test_textSource_image_over_classpath_OtherClass() throws Exception {
        this.assert_getText_getClipboardSource_forSource("new Image(null, java.lang.String.class.getResourceAsStream(\"/javax/swing/plaf/basic/icons/JavaCup16.png\"))", "Classpath: /javax/swing/plaf/basic/icons/JavaCup16.png", "new org.eclipse.swt.graphics.Image(null, {wbp_classTop}.getResourceAsStream(\"/javax/swing/plaf/basic/icons/JavaCup16.png\"))");
    }
}

