/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.internal.core.model.generation.GenerationSettings;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.generation.statement.flat.FlatStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.RowDataInfo;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class RowLayoutTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_typeField() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    RowLayout layout = new RowLayout(SWT.VERTICAL);", "    setLayout(layout);", "  }", "}");
        RowLayoutInfo layout = (RowLayoutInfo)shell.getLayout();
        GenericProperty typeProperty = (GenericProperty)layout.getPropertyByTitle("type");
        typeProperty.setExpression("org.eclipse.swt.SWT.HORIZONTAL", (Object)256);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    RowLayout layout = new RowLayout(SWT.HORIZONTAL);", "    setLayout(layout);", "  }", "}");
        typeProperty.setExpression("org.eclipse.swt.SWT.VERTICAL", (Object)512);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    RowLayout layout = new RowLayout(SWT.VERTICAL);", "    setLayout(layout);", "  }", "}");
    }

    @Test
    public void test_isHorizontal_1() throws Exception {
        this.test_isHorizontal(new String[]{"class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new RowLayout(SWT.HORIZONTAL));", "  }", "}"});
    }

    @Test
    public void test_isHorizontal_2() throws Exception {
        this.test_isHorizontal(new String[]{"class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new RowLayout());", "  }", "}"});
    }

    private void test_isHorizontal(String[] lines) throws Exception {
        CompositeInfo shellInfo = this.parseComposite(lines);
        RowLayoutInfo layoutInfo = (RowLayoutInfo)shellInfo.getLayout();
        RowLayoutTest.assertNotNull((Object)layoutInfo);
        shellInfo.refresh();
        RowLayoutTest.assertTrue((boolean)layoutInfo.isHorizontal());
        Property property = layoutInfo.getPropertyByTitle("type");
        RowLayoutTest.assertNotNull((Object)property);
        property.setValue((Object)512);
        RowLayoutTest.assertFalse((boolean)layoutInfo.isHorizontal());
    }

    @Test
    public void test_AddControls() throws Exception {
        CompositeInfo shellInfo = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new RowLayout());", "  }", "}");
        RowLayoutTest.assertTrue((boolean)shellInfo.getChildrenControls().isEmpty());
        RowLayoutInfo layout = (RowLayoutInfo)shellInfo.getLayout();
        ControlInfo buttonInfo = BTestUtils.createButton();
        layout.command_CREATE(buttonInfo, null);
        RowLayoutTest.assertNotNull((Object)buttonInfo.getAssociation());
        RowLayoutTest.assertEquals((long)1L, (long)shellInfo.getChildrenControls().size());
        RowLayoutTest.assertSame((Object)buttonInfo, shellInfo.getChildrenControls().get(0));
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new RowLayout());", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "  }", "}");
        RowLayoutTest.assertRelatedNodes((JavaInfo)shellInfo, new String[]{"new Shell()", "shell.setLayout(new RowLayout())", "new Button(shell, SWT.NONE)"});
        ControlInfo labelInfo = BTestUtils.createControl("org.eclipse.swt.widgets.Label");
        layout.command_CREATE(labelInfo, buttonInfo);
        RowLayoutTest.assertNotNull((Object)labelInfo.getAssociation());
        RowLayoutTest.assertEquals((long)2L, (long)shellInfo.getChildrenControls().size());
        RowLayoutTest.assertSame((Object)labelInfo, shellInfo.getChildrenControls().get(0));
        RowLayoutTest.assertSame((Object)buttonInfo, shellInfo.getChildrenControls().get(1));
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new RowLayout());", "    {", "      Label label = new Label(shell, SWT.NONE);", "      label.setText('New Label');", "    }", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "  }", "}");
        RowLayoutTest.assertInstanceOf(RowDataInfo.class, (Object)LayoutInfo.getLayoutData((ControlInfo)labelInfo));
    }

    @Test
    public void test_MoveControls() throws Exception {
        CompositeInfo shellInfo = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new RowLayout());", "    {", "      Label label = new Label(shell, SWT.NONE);", "    }", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "    {", "      Combo combo = new Combo(shell, SWT.READ_ONLY);", "    }", "  }", "}");
        RowLayoutInfo layout = (RowLayoutInfo)shellInfo.getLayout();
        ControlInfo labelInfo = (ControlInfo)shellInfo.getChildrenControls().get(0);
        ControlInfo buttonInfo = (ControlInfo)shellInfo.getChildrenControls().get(1);
        ControlInfo comboInfo = (ControlInfo)shellInfo.getChildrenControls().get(2);
        Association labelAssociation = labelInfo.getAssociation();
        Association buttonAssociation = buttonInfo.getAssociation();
        Association comboAssociation = comboInfo.getAssociation();
        RowLayoutTest.assertNotNull((Object)labelAssociation);
        RowLayoutTest.assertNotNull((Object)buttonAssociation);
        RowLayoutTest.assertNotNull((Object)comboAssociation);
        layout.command_MOVE(comboInfo, buttonInfo);
        RowLayoutTest.assertSame((Object)labelInfo, shellInfo.getChildrenControls().get(0));
        RowLayoutTest.assertSame((Object)comboInfo, shellInfo.getChildrenControls().get(1));
        RowLayoutTest.assertSame((Object)buttonInfo, shellInfo.getChildrenControls().get(2));
        RowLayoutTest.assertSame((Object)labelAssociation, (Object)labelInfo.getAssociation());
        RowLayoutTest.assertSame((Object)buttonAssociation, (Object)buttonInfo.getAssociation());
        RowLayoutTest.assertSame((Object)comboAssociation, (Object)comboInfo.getAssociation());
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new RowLayout());", "    {", "      Label label = new Label(shell, SWT.NONE);", "    }", "    {", "      Combo combo = new Combo(shell, SWT.READ_ONLY);", "    }", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "  }", "}");
        layout.command_MOVE(labelInfo, null);
        RowLayoutTest.assertSame((Object)comboInfo, shellInfo.getChildrenControls().get(0));
        RowLayoutTest.assertSame((Object)buttonInfo, shellInfo.getChildrenControls().get(1));
        RowLayoutTest.assertSame((Object)labelInfo, shellInfo.getChildrenControls().get(2));
        RowLayoutTest.assertSame((Object)labelAssociation, (Object)labelInfo.getAssociation());
        RowLayoutTest.assertSame((Object)buttonAssociation, (Object)buttonInfo.getAssociation());
        RowLayoutTest.assertSame((Object)comboAssociation, (Object)comboInfo.getAssociation());
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new RowLayout());", "    {", "      Combo combo = new Combo(shell, SWT.READ_ONLY);", "    }", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "    {", "      Label label = new Label(shell, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_ReparentControls() throws Exception {
        CompositeInfo shellInfo = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new RowLayout());", "    {", "      Label label = new Label(shell, SWT.NONE);", "    }", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "    {", "      Composite composite = new Composite(shell, SWT.NONE);", "      composite.setLayout(new RowLayout());", "      {", "        Combo combo = new Combo(composite, SWT.READ_ONLY);", "      }", "    }", "  }", "}");
        RowLayoutTest.assertEquals((long)3L, (long)shellInfo.getChildrenControls().size());
        ControlInfo labelInfo = (ControlInfo)shellInfo.getChildrenControls().get(0);
        ControlInfo buttonInfo = (ControlInfo)shellInfo.getChildrenControls().get(1);
        CompositeInfo compositeInfo = (CompositeInfo)shellInfo.getChildrenControls().get(2);
        RowLayoutTest.assertEquals((long)1L, (long)compositeInfo.getChildrenControls().size());
        ControlInfo comboInfo = (ControlInfo)compositeInfo.getChildrenControls().get(0);
        RowLayoutInfo layoutInfo = (RowLayoutInfo)compositeInfo.getLayout();
        Association labelAssociation = labelInfo.getAssociation();
        Association buttonAssociation = buttonInfo.getAssociation();
        Association comboAssociation = comboInfo.getAssociation();
        RowLayoutTest.assertNotNull((Object)labelAssociation);
        RowLayoutTest.assertNotNull((Object)buttonAssociation);
        RowLayoutTest.assertNotNull((Object)comboAssociation);
        layoutInfo.command_MOVE(buttonInfo, comboInfo);
        RowLayoutTest.assertEquals((long)2L, (long)shellInfo.getChildrenControls().size());
        RowLayoutTest.assertEquals((long)2L, (long)compositeInfo.getChildrenControls().size());
        RowLayoutTest.assertSame((Object)labelInfo, shellInfo.getChildrenControls().get(0));
        RowLayoutTest.assertSame((Object)compositeInfo, shellInfo.getChildrenControls().get(1));
        RowLayoutTest.assertSame((Object)buttonInfo, compositeInfo.getChildrenControls().get(0));
        RowLayoutTest.assertSame((Object)comboInfo, compositeInfo.getChildrenControls().get(1));
        RowLayoutTest.assertSame((Object)labelAssociation, (Object)labelInfo.getAssociation());
        RowLayoutTest.assertSame((Object)buttonAssociation, (Object)buttonInfo.getAssociation());
        RowLayoutTest.assertSame((Object)comboAssociation, (Object)comboInfo.getAssociation());
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new RowLayout());", "    {", "      Label label = new Label(shell, SWT.NONE);", "    }", "    {", "      Composite composite = new Composite(shell, SWT.NONE);", "      composite.setLayout(new RowLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "      {", "        Combo combo = new Combo(composite, SWT.READ_ONLY);", "      }", "    }", "  }", "}");
        layoutInfo.command_MOVE(labelInfo, null);
        RowLayoutTest.assertEquals((long)1L, (long)shellInfo.getChildrenControls().size());
        RowLayoutTest.assertEquals((long)3L, (long)compositeInfo.getChildrenControls().size());
        RowLayoutTest.assertSame((Object)compositeInfo, shellInfo.getChildrenControls().get(0));
        RowLayoutTest.assertSame((Object)buttonInfo, compositeInfo.getChildrenControls().get(0));
        RowLayoutTest.assertSame((Object)comboInfo, compositeInfo.getChildrenControls().get(1));
        RowLayoutTest.assertSame((Object)labelInfo, compositeInfo.getChildrenControls().get(2));
        RowLayoutTest.assertSame((Object)labelAssociation, (Object)labelInfo.getAssociation());
        RowLayoutTest.assertSame((Object)buttonAssociation, (Object)buttonInfo.getAssociation());
        RowLayoutTest.assertSame((Object)comboAssociation, (Object)comboInfo.getAssociation());
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(shell, SWT.NONE);", "      composite.setLayout(new RowLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "      {", "        Combo combo = new Combo(composite, SWT.READ_ONLY);", "      }", "      {", "        Label label = new Label(composite, SWT.NONE);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_changeRowData() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new RowLayout());", "    {", "      Button button = new Button(shell, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        RowDataInfo dataInfo = (RowDataInfo)button.getChildrenJava().get(0);
        Property width = dataInfo.getPropertyByTitle("width");
        RowLayoutTest.assertNotNull((Object)width);
        RowLayoutTest.assertEquals((Object)-1, (Object)width.getValue());
        Property height = dataInfo.getPropertyByTitle("height");
        RowLayoutTest.assertNotNull((Object)height);
        RowLayoutTest.assertEquals((Object)-1, (Object)height.getValue());
        dataInfo.setWidth(40);
        RowLayoutTest.assertEquals((Object)40, (Object)width.getValue());
        dataInfo.setHeight(30);
        RowLayoutTest.assertEquals((Object)30, (Object)height.getValue());
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new RowLayout());", "    {", "      Button button = new Button(shell, SWT.NONE);", "      button.setLayoutData(new RowData(40, 30));", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_addBefore_nameConflict() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ", "    Button button = new Button(this, SWT.NONE);", "    button.setText('0');", "  }", "}");
        RowLayoutInfo rowLayout = (RowLayoutInfo)shell.getLayout();
        ControlInfo existingButton = (ControlInfo)shell.getChildrenControls().get(0);
        GenerationSettings generationSettings = shell.getDescription().getToolkit().getGenerationSettings();
        StatementGeneratorDescription oldStatement = generationSettings.getStatement();
        try {
            generationSettings.setStatement(FlatStatementGeneratorDescription.INSTANCE);
            ControlInfo newButton = BTestUtils.createButton();
            rowLayout.command_CREATE(newButton, existingButton);
        }
        finally {
            generationSettings.setStatement(oldStatement);
        }
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ", "    Button button_1 = new Button(this, SWT.NONE);", "    ", "    Button button = new Button(this, SWT.NONE);", "    button.setText('0');", "  }", "}");
    }
}

