/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.spring;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.spring.SpringAttachmentInfo;
import org.eclipse.wb.internal.swing.model.layout.spring.SpringLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.Test;

public class SpringAttachmentTest
extends AbstractLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getSpringSide() throws Exception {
        SpringAttachmentTest.assertSame((Object)"West", (Object)SpringAttachmentInfo.getSpringSide((int)1));
        SpringAttachmentTest.assertSame((Object)"East", (Object)SpringAttachmentInfo.getSpringSide((int)4));
        SpringAttachmentTest.assertSame((Object)"North", (Object)SpringAttachmentInfo.getSpringSide((int)8));
        SpringAttachmentTest.assertSame((Object)"South", (Object)SpringAttachmentInfo.getSpringSide((int)32));
        try {
            SpringAttachmentInfo.getSpringSide((int)-1);
            SpringAttachmentTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_getSpringSideSource() throws Exception {
        SpringAttachmentTest.assertEquals((Object)"javax.swing.SpringLayout.WEST", (Object)SpringAttachmentInfo.getSpringSideSource((int)1));
        SpringAttachmentTest.assertEquals((Object)"javax.swing.SpringLayout.EAST", (Object)SpringAttachmentInfo.getSpringSideSource((int)4));
        SpringAttachmentTest.assertEquals((Object)"javax.swing.SpringLayout.NORTH", (Object)SpringAttachmentInfo.getSpringSideSource((int)8));
        SpringAttachmentTest.assertEquals((Object)"javax.swing.SpringLayout.SOUTH", (Object)SpringAttachmentInfo.getSpringSideSource((int)32));
        try {
            SpringAttachmentInfo.getSpringSideSource((int)-1);
            SpringAttachmentTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_getFrameworkSide() throws Exception {
        SpringAttachmentTest.assertEquals((long)1L, (long)SpringAttachmentInfo.getFrameworkSide((String)"West"));
        SpringAttachmentTest.assertEquals((long)8L, (long)SpringAttachmentInfo.getFrameworkSide((String)"North"));
        SpringAttachmentTest.assertEquals((long)4L, (long)SpringAttachmentInfo.getFrameworkSide((String)"East"));
        SpringAttachmentTest.assertEquals((long)32L, (long)SpringAttachmentInfo.getFrameworkSide((String)"South"));
        try {
            SpringAttachmentInfo.getFrameworkSide((String)"no such side");
            SpringAttachmentTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_getAttchment() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertSame((Object)attachment, (Object)layout.getAttachmentLeft(button));
        SpringAttachmentTest.assertNotSame((Object)attachment, (Object)layout.getAttachmentRight(button));
        SpringAttachmentTest.assertNotSame((Object)attachment, (Object)layout.getAttachmentTop(button));
        SpringAttachmentTest.assertNotSame((Object)attachment, (Object)layout.getAttachmentBottom(button));
    }

    @Test
    public void test_getSide() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertEquals((long)1L, (long)attachment.getSide());
        attachment = layout.getAttachmentTop(button);
        SpringAttachmentTest.assertEquals((long)8L, (long)attachment.getSide());
        attachment = layout.getAttachmentRight(button);
        SpringAttachmentTest.assertEquals((long)4L, (long)attachment.getSide());
        attachment = layout.getAttachmentBottom(button);
        SpringAttachmentTest.assertEquals((long)32L, (long)attachment.getSide());
    }

    @Test
    public void test_isVirtual() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Rectangle modelBounds = button.getModelBounds();
        SpringAttachmentTest.assertEquals((long)modelBounds.x, (long)5L);
        SpringAttachmentTest.assertEquals((long)modelBounds.y, (long)10L);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        attachment = layout.getAttachmentTop(button);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        attachment = layout.getAttachmentRight(button);
        SpringAttachmentTest.assertTrue((boolean)attachment.isVirtual());
        attachment = layout.getAttachmentBottom(button);
        SpringAttachmentTest.assertTrue((boolean)attachment.isVirtual());
    }

    @Test
    public void test_getAnchor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JButton button_1 = new JButton();", "  private final JButton button_2 = new JButton();", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      add(button_1);", "      layout.putConstraint(SpringLayout.WEST, button_1, 5, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.NORTH, button_1, 10, SpringLayout.NORTH, this);", "    }", "    {", "      add(button_2);", "      layout.putConstraint(SpringLayout.WEST, button_2, 5, SpringLayout.EAST, button_1);", "      layout.putConstraint(SpringLayout.NORTH, button_2, 0, SpringLayout.NORTH, button_1);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        Rectangle bounds_1 = button_1.getModelBounds();
        Rectangle bounds_2 = button_2.getModelBounds();
        SpringAttachmentTest.assertEquals((long)bounds_1.x, (long)5L);
        SpringAttachmentTest.assertEquals((long)bounds_1.y, (long)10L);
        SpringAttachmentTest.assertEquals((long)bounds_2.x, (long)(bounds_1.right() + 5));
        SpringAttachmentTest.assertEquals((long)bounds_2.y, (long)bounds_1.y);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button_1);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((long)1L, (long)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((long)5L, (long)attachment.getOffset());
        attachment = layout.getAttachmentTop(button_1);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((long)8L, (long)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((long)10L, (long)attachment.getOffset());
        attachment = layout.getAttachmentLeft(button_2);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)button_1, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((long)4L, (long)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((long)5L, (long)attachment.getOffset());
        attachment = layout.getAttachmentTop(button_2);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)button_1, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((long)8L, (long)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((long)0L, (long)attachment.getOffset());
    }

    @Test
    public void test_getDistance() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.SOUTH, button, -10, SpringLayout.SOUTH, this);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((long)1L, (long)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((long)5L, (long)attachment.getOffset());
        attachment = layout.getAttachmentBottom(button);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((long)32L, (long)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((long)-10L, (long)attachment.getOffset());
    }

    @Test
    public void test_write_existingAttachment() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((long)1L, (long)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((long)5L, (long)attachment.getOffset());
        attachment.setOffset(10);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, 10, SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
        attachment.setAnchorSide(4);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, 10, SpringLayout.EAST, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_write_newAttachment() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertTrue((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame(null, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((long)0L, (long)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((long)0L, (long)attachment.getOffset());
        attachment.setAnchorComponent((ComponentInfo)panel);
        attachment.setAnchorSide(1);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
        SpringAttachmentTest.assertEquals((Object)"{new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/ /layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this)/}", (Object)button.toString());
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((long)1L, (long)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((long)5L, (long)attachment.getOffset());
    }

    @Test
    public void test_write_newAttachment_lazy() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton m_button;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    add(getButton());", "  }", "  private JButton getButton() {", "    if (m_button == null) {", "      m_button = new JButton();", "    }", "    return m_button;", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertTrue((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame(null, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((long)0L, (long)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((long)0L, (long)attachment.getOffset());
        attachment.setAnchorComponent((ComponentInfo)panel);
        attachment.setAnchorSide(1);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {", "  private JButton m_button;", "  private SpringLayout layout;", "  public Test() {", "    layout = new SpringLayout();", "    setLayout(layout);", "    add(getButton());", "  }", "  private JButton getButton() {", "    if (m_button == null) {", "      m_button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, m_button, 5, SpringLayout.WEST, this);", "    }", "    return m_button;", "  }", "}");
        SpringAttachmentTest.assertEquals((Object)"{new: javax.swing.JButton} {lazy: m_button getButton()} {/new JButton()/ /m_button/ /add(getButton())/ /layout.putConstraint(SpringLayout.WEST, m_button, 5, SpringLayout.WEST, this)/}", (Object)button.toString());
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((long)1L, (long)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((long)5L, (long)attachment.getOffset());
    }

    @Test
    public void test_write_newAttachment_sorted() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentTop(button);
        attachment.setAnchorComponent((ComponentInfo)panel);
        attachment.setAnchorSide(8);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button, 5, SpringLayout.NORTH, this);", "      add(button);", "    }", "  }", "}");
        attachment = layout.getAttachmentLeft(button);
        attachment.setAnchorComponent((ComponentInfo)panel);
        attachment.setAnchorSide(1);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button, 5, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
        attachment = layout.getAttachmentBottom(button);
        attachment.setAnchorComponent((ComponentInfo)panel);
        attachment.setAnchorSide(32);
        attachment.setOffset(-5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button, 5, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.SOUTH, button, -5, SpringLayout.SOUTH, this);", "      add(button);", "    }", "  }", "}");
        attachment = layout.getAttachmentRight(button);
        attachment.setAnchorComponent((ComponentInfo)panel);
        attachment.setAnchorSide(4);
        attachment.setOffset(-5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button, 5, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.SOUTH, button, -5, SpringLayout.SOUTH, this);", "      layout.putConstraint(SpringLayout.EAST, button, -5, SpringLayout.EAST, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_write_newAttachment_trailingSide() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentRight(button);
        SpringAttachmentTest.assertTrue((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame(null, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((long)0L, (long)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((long)0L, (long)attachment.getOffset());
        attachment.setAnchorComponent((ComponentInfo)panel);
        attachment.setAnchorSide(4);
        attachment.setOffset(-5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.EAST, button, -5, SpringLayout.EAST, this);", "      add(button);", "    }", "  }", "}");
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((long)4L, (long)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((long)-5L, (long)attachment.getOffset());
    }

    @Test
    public void test_write_newAttachment_backReference() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      add(buttonB);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(buttonB);
        attachment.setAnchorComponent(buttonA);
        attachment.setAnchorSide(1);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {", "  private JButton buttonA;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      layout.putConstraint(SpringLayout.WEST, buttonB, 5, SpringLayout.WEST, buttonA);", "      add(buttonB);", "    }", "  }", "}");
        SpringAttachmentTest.assertEquals((Object)"{new: javax.swing.JButton} {field-unique: buttonA} {/new JButton()/ /add(buttonA)/ /layout.putConstraint(SpringLayout.WEST, buttonB, 5, SpringLayout.WEST, buttonA)/}", (Object)buttonA.toString());
        SpringAttachmentTest.assertEquals((Object)"{new: javax.swing.JButton} {local-unique: buttonB} {/new JButton()/ /add(buttonB)/ /layout.putConstraint(SpringLayout.WEST, buttonB, 5, SpringLayout.WEST, buttonA)/}", (Object)buttonB.toString());
    }

    @Test
    public void test_write_newAttachment_forwardReference() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      add(buttonB);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(buttonA);
        attachment.setAnchorComponent(buttonB);
        attachment.setAnchorSide(1);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {", "  private JButton buttonA;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      layout.putConstraint(SpringLayout.WEST, buttonA, 5, SpringLayout.WEST, buttonB);", "      add(buttonB);", "    }", "  }", "}");
    }

    @Test
    public void test_write_updateAttachment_backReference() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      layout.putConstraint(SpringLayout.WEST, buttonB, 5, SpringLayout.WEST, this);", "      add(buttonB);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(buttonB);
        attachment.setAnchorComponent(buttonA);
        attachment.setAnchorSide(1);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {", "  private JButton buttonA;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      layout.putConstraint(SpringLayout.WEST, buttonB, 5, SpringLayout.WEST, buttonA);", "      add(buttonB);", "    }", "  }", "}");
    }

    @Test
    public void test_write_updateAttachment_forwardReference() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton buttonA = new JButton();", "      layout.putConstraint(SpringLayout.WEST, buttonA, 5, SpringLayout.WEST, this);", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      add(buttonB);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(buttonA);
        attachment.setAnchorComponent(buttonB);
        attachment.setAnchorSide(1);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {", "  private JButton buttonA;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      layout.putConstraint(SpringLayout.WEST, buttonA, 5, SpringLayout.WEST, buttonB);", "      add(buttonB);", "    }", "  }", "}");
    }

    @Test
    public void test_delete() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        attachment.delete();
        SpringAttachmentTest.assertTrue((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame(null, (Object)attachment.getAnchorComponent());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "      layout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);", "    }", "  }", "}");
    }

    @Test
    public void test_adjustAfterComponentMove_source() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton buttonA;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      layout.putConstraint(SpringLayout.WEST, buttonB, 0, SpringLayout.WEST, buttonA);", "      add(buttonB);", "    }", "  }", "}");
        panel.refresh();
        SpringAttachmentTest.assertNoErrors((JavaInfo)panel);
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(buttonB);
        panel.startEdit();
        JavaInfoUtils.move((JavaInfo)buttonB, null, (JavaInfo)panel, (JavaInfo)buttonA);
        this.assertEditor("public class Test extends JPanel {", "  private JButton buttonA;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton buttonB = new JButton();", "      layout.putConstraint(SpringLayout.WEST, buttonB, 0, SpringLayout.WEST, buttonA);", "      add(buttonB);", "    }", "    {", "      buttonA = new JButton();", "      add(buttonA);", "    }", "  }", "}");
        attachment.adjustAfterComponentMove();
        this.assertEditor("public class Test extends JPanel {", "  private JButton buttonA;", "  private JButton buttonB;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      buttonB = new JButton();", "      add(buttonB);", "    }", "    {", "      buttonA = new JButton();", "      layout.putConstraint(SpringLayout.WEST, buttonB, 0, SpringLayout.WEST, buttonA);", "      add(buttonA);", "    }", "  }", "}");
    }

    @Test
    public void test_adjustAfterComponentMove_anchor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton buttonA;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      layout.putConstraint(SpringLayout.WEST, buttonB, 0, SpringLayout.WEST, buttonA);", "      add(buttonB);", "    }", "  }", "}");
        panel.refresh();
        SpringAttachmentTest.assertNoErrors((JavaInfo)panel);
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        panel.startEdit();
        JavaInfoUtils.move((JavaInfo)buttonA, null, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {", "  private JButton buttonA;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton buttonB = new JButton();", "      add(buttonB);", "    }", "    {", "      buttonA = new JButton();", "      add(buttonA);", "    }", "    layout.putConstraint(SpringLayout.WEST, buttonB, 0, SpringLayout.WEST, buttonA);", "  }", "}");
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(buttonB);
        attachment.adjustAfterComponentMove();
        this.assertEditor("public class Test extends JPanel {", "  private JButton buttonA;", "  private JButton buttonB;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      buttonB = new JButton();", "      add(buttonB);", "    }", "    {", "      buttonA = new JButton();", "      layout.putConstraint(SpringLayout.WEST, buttonB, 0, SpringLayout.WEST, buttonA);", "      add(buttonA);", "    }", "  }", "}");
    }

    @Test
    public void test_adjustAfterComponentMove_anchor2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton buttonA;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton button_1 = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button_1, 0, SpringLayout.WEST, buttonA);", "      add(button_1);", "    }", "  }", "}");
        panel.refresh();
        SpringAttachmentTest.assertNoErrors((JavaInfo)panel);
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        panel.startEdit();
        JavaInfoUtils.move((JavaInfo)buttonA, null, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {", "  private JButton buttonA;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      buttonA = new JButton();", "      add(buttonA);", "    }", "    layout.putConstraint(SpringLayout.WEST, button_1, 0, SpringLayout.WEST, buttonA);", "  }", "}");
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(buttonB);
        attachment.adjustAfterComponentMove();
        this.assertEditor("public class Test extends JPanel {", "  private JButton buttonA;", "  private JButton button;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      button = new JButton();", "      add(button);", "    }", "    {", "      buttonA = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, 0, SpringLayout.WEST, buttonA);", "      add(buttonA);", "    }", "  }", "}");
    }
}

