/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gbl;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.gef.graphical.GraphicalViewer;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagLayoutInfo;
import org.eclipse.wb.os.OSSupport;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.eclipse.wb.tests.designer.swing.model.layout.gbl.AbstractGridBagLayoutTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class GridBagLayoutGefTest
extends SwingGefTest {
    ContainerInfo mainPanel;
    ContainerInfo panel_1;
    ComponentInfo button;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        AbstractGridBagLayoutTest.configureForTest();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        AbstractGridBagLayoutTest.configureDefaults();
        super.tearDown();
    }

    @Test
    public void test_replaceWithOther_andPaintDuringThis() throws Exception {
        this.mainPanel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    GridBagLayout gridBagLayout = new GridBagLayout();", "    gridBagLayout.columnWeights = new double[]{1.0};", "    gridBagLayout.rowWeights = new double[]{1.0};", "    setLayout(gridBagLayout);", "    {", "      JButton button = new JButton('New JButton');", "      add(button);", "    }", "  }", "}");
        this.button = (ComponentInfo)GridBagLayoutGefTest.getJavaInfoByName("button");
        this.canvas.select(this.button);
        GridBagLayoutGefTest.waitEventLoop(0);
        ExecutionUtils.runAsync((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ExecutionUtils.runLogUI((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        this.forcePaint(GridBagLayoutGefTest.this.m_headerHorizontal);
                        this.forcePaint(GridBagLayoutGefTest.this.m_headerVertical);
                    }

                    private void forcePaint(GraphicalViewer viewer) throws Exception {
                        FigureCanvas control = viewer.getControl();
                        Image image = OSSupport.get().makeShot((Control)control);
                        image.dispose();
                        control.getShell().setVisible(true);
                    }
                });
            }
        });
        LayoutInfo layout = (LayoutInfo)GridBagLayoutGefTest.createJavaInfo("java.awt.FlowLayout");
        this.mainPanel.setLayout(layout);
    }

    @Test
    public void test_JPopupMenu_select() throws Exception {
        this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton('button');", "      add(button, new GridBagConstraints());", "    }", "    {", "      JPopupMenu popupMenu = new JPopupMenu();", "      addPopup(this, popupMenu);", "    }", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        ComponentInfo popup = (ComponentInfo)GridBagLayoutGefTest.getJavaInfoByName("popupMenu");
        this.canvas.select(popup);
    }

    @Test
    public void test_JPopupMenu_drop() throws Exception {
        this.mainPanel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        ComponentInfo newPopup = (ComponentInfo)this.loadCreationTool("javax.swing.JPopupMenu");
        this.canvas.moveTo((Object)this.mainPanel, 100, 100);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(this.mainPanel));
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPopupMenu popupMenu = new JPopupMenu();", "      addPopup(this, popupMenu);", "    }", "    setLayout(new GridBagLayout());", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        this.canvas.assertPrimarySelected(newPopup);
    }

    @Test
    public void test_CREATE_inTree_empty() throws Exception {
        this.mainPanel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "  }", "}");
        this.loadCreationTool("javax.swing.JButton", "empty");
        this.tree.moveOn(this.mainPanel);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_DELETE_afterSelect() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n  public Test() {\n    setSize(50, 50);\n    GridBagLayout gridBagLayout = new GridBagLayout();\n    setLayout(gridBagLayout);\n\n    JPanel panel = new JPanel();\n    GridBagConstraints gbc_panel = new GridBagConstraints();\n    gbc_panel.ipady = 10;\n    gbc_panel.ipadx = 10;\n    gbc_panel.fill = GridBagConstraints.BOTH;\n    gbc_panel.gridx = 0;\n    gbc_panel.gridy = 0;\n    add(panel, gbc_panel);\n    panel.setLayout(null);\n\n    JPanel panel_1 = new JPanel();\n    GridBagConstraints gbc_panel_1 = new GridBagConstraints();\n    gbc_panel_1.ipady = 10;\n    gbc_panel_1.ipadx = 10;\n    gbc_panel_1.fill = GridBagConstraints.BOTH;\n    gbc_panel_1.gridx = 1;\n    gbc_panel_1.gridy = 1;\n    add(panel_1, gbc_panel_1);\n    panel_1.setLayout(null);\n  }\n}\n");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutGefTest.assertEquals((long)2L, (long)layout.getColumns().size());
        GridBagLayoutGefTest.assertEquals((long)2L, (long)layout.getRows().size());
        this.canvas.select(panel.getChildrenComponents().get(1));
        ((ComponentInfo)panel.getChildrenComponents().get(1)).delete();
        GridBagLayoutGefTest.assertEquals((long)1L, (long)layout.getColumns().size());
        GridBagLayoutGefTest.assertEquals((long)1L, (long)layout.getRows().size());
        this.assertEditor("public class Test extends JPanel {\n  public Test() {\n    setSize(50, 50);\n    GridBagLayout gridBagLayout = new GridBagLayout();\n    setLayout(gridBagLayout);\n\n    JPanel panel = new JPanel();\n    GridBagConstraints gbc_panel = new GridBagConstraints();\n    gbc_panel.ipady = 10;\n    gbc_panel.ipadx = 10;\n    gbc_panel.fill = GridBagConstraints.BOTH;\n    gbc_panel.gridx = 0;\n    gbc_panel.gridy = 0;\n    add(panel, gbc_panel);\n    panel.setLayout(null);\n  }\n}\n");
    }
}

