/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.swing.SwingToolkitDescription;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.editor.DesignerEditorTestCase;
import org.junit.After;
import org.junit.Before;

public abstract class SwingGefTest
extends DesignerEditorTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        SwingGefTest.configureDefaults(ToolkitProvider.DESCRIPTION);
        if (m_testProject == null) {
            SwingGefTest.do_projectCreate();
            this.configureNewProject();
        }
        SwingGefTest.configureForTest();
    }

    protected void configureNewProject() throws Exception {
    }

    @Override
    @After
    public void tearDown() throws Exception {
        SwingGefTest.configureDefaults();
        super.tearDown();
    }

    public static void configureForTest() {
        IPreferenceStore preferences = SwingToolkitDescription.INSTANCE.getPreferences();
        preferences.setValue("templateLayoutName", "${defaultName}");
    }

    public static void configureDefaults() {
        IPreferenceStore preferences = SwingToolkitDescription.INSTANCE.getPreferences();
        preferences.setToDefault("templateLayoutName");
    }

    protected ContainerInfo openContainer(String ... lines) throws Exception {
        return (ContainerInfo)this.openEditor(lines);
    }

    protected <T extends ObjectInfo> T openEditor(String ... lines) throws Exception {
        ICompilationUnit unit = this.createModelCompilationUnit("test", "Test.java", this.getTestSource(lines));
        this.openDesign(unit);
        return (T)this.m_contentJavaInfo;
    }

    protected void assertEditor(String ... lines) {
        AstEditor editor = EditorState.getActiveJavaInfo().getEditor();
        SwingGefTest.assertEditor(this.getTestSource(lines), editor);
    }

    public String getTestSource(String ... lines) {
        lines = SwingGefTest.getDoubleQuotes(lines);
        return SwingGefTest.getSource(new String[][]{{"package test;", "import java.awt.*;", "import java.awt.event.*;", "import javax.swing.*;", "import javax.swing.border.*;"}, lines});
    }

    protected final void prepareBox() throws Exception {
        this.prepareBox(100, 50);
    }

    protected final void prepareBox(int width, int height) throws Exception {
        SwingGefTest.setFileContentSrc("test/Box.java", this.getTestSource("public class Box extends JLabel {", "  public Box() {", "    setPreferredSize(new Dimension(" + width + ", " + height + "));", "    setBackground(Color.PINK);", "    setOpaque(true);", "  }", "  public Box(String text) {", "    this();", "    setText(text);", "  }", "}"));
        SwingGefTest.waitForAutoBuild();
    }

    protected final ComponentInfo loadCreationBox() throws Exception {
        return (ComponentInfo)this.loadCreationTool("test.Box");
    }

    protected final ComponentInfo loadButton() throws Exception {
        return (ComponentInfo)this.loadCreationTool("javax.swing.JButton", "empty");
    }

    protected final ComponentInfo loadButtonWithText() throws Exception {
        return (ComponentInfo)this.loadCreationTool("javax.swing.JButton");
    }
}

