/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.TestObjectInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.Test;

public class DeleteActionTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_ParentChild() throws Exception {
        ContainerInfo thisPanel = this.openContainer("// filler filler filler", "public class Test extends JPanel {", "\tpublic Test() {", "\t\t{", "\t\t\tJPanel panel = new JPanel();", "\t\t\tadd(panel);", "\t\t\t{", "\t\t\t\tJButton button = new JButton('New button');", "\t\t\t\tpanel.add(button);", "\t\t\t}", "\t\t}", "\t}", "}");
        ContainerInfo panel = (ContainerInfo)thisPanel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.select(panel, button);
        IAction deleteAction = this.getDeleteAction();
        DeleteActionTest.assertTrue((boolean)deleteAction.isEnabled());
        deleteAction.run();
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "\tpublic Test() {", "\t}", "}");
    }

    @Test
    public void test_canRootComponent() throws Exception {
        ContainerInfo panel = this.openContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "\tpublic Test() {", "\t  setEnabled(false);", "\t}", "}");
        this.canvas.select(panel);
        IAction deleteAction = this.getDeleteAction();
        DeleteActionTest.assertTrue((boolean)deleteAction.isEnabled());
        deleteAction.run();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "\tpublic Test() {", "\t}", "}");
    }

    @Test
    public void test_componentInTree_butNotOnDesign() throws Exception {
        ContainerInfo panel = this.openContainer("// filler filler filler", "public class Test extends JPanel {", "\tpublic Test() {", "\t}", "}");
        TestObjectInfo object = new TestObjectInfo("myObject"){

            public boolean canDelete() {
                return true;
            }

            public void delete() throws Exception {
                this.getParent().removeChild((ObjectInfo)this);
            }
        };
        panel.addChild((ObjectInfo)object);
        DeleteActionTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  myObject");
        panel.refresh();
        this.tree.setExpanded(panel, true);
        this.tree.select(new Object[]{object});
        IAction deleteAction = this.getDeleteAction();
        DeleteActionTest.assertTrue((boolean)deleteAction.isEnabled());
        deleteAction.run();
        DeleteActionTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_DesignPageFirst() throws Exception {
        IPreferenceStore preferences = DesignerPlugin.getPreferences();
        preferences.setValue("editor.layout", 1);
        try {
            ContainerInfo panel = this.openContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "\tpublic Test() {", "\t  add(new JButton('Some button'));", "\t}", "}");
            ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
            this.canvas.select(button);
            IAction deleteAction = this.getDeleteAction();
            DeleteActionTest.assertTrue((boolean)deleteAction.isEnabled());
            deleteAction.run();
            DeleteActionTest.assertEquals((Object)this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "\tpublic Test() {", "\t}", "}"), (Object)this.m_lastEditor.getModelUnit().getSource());
        }
        finally {
            preferences.setToDefault("editor.layout");
        }
    }
}

