/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor;

import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Tool;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wb.core.editor.IDesignPage;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.tools.CreationTool;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.parser.DatabindingRootProcessor;
import org.eclipse.wb.internal.core.databinding.parser.ParseState;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.editor.actions.DesignPageActions;
import org.eclipse.wb.internal.core.editor.multi.DesignerEditor;
import org.eclipse.wb.internal.core.editor.structure.DesignComponentsComposite;
import org.eclipse.wb.internal.core.editor.structure.components.IComponentsTree;
import org.eclipse.wb.internal.core.gef.part.DesignRootEditPart;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.gef.graphical.GraphicalViewer;
import org.eclipse.wb.internal.gef.tree.TreeViewer;
import org.eclipse.wb.internal.rcp.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.WidgetsObserveTypeContainer;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.core.model.parser.AbstractJavaInfoRelatedTest;
import org.eclipse.wb.tests.gef.GraphicalRobot;
import org.eclipse.wb.tests.gef.TreeRobot;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.After;
import org.junit.Before;

public abstract class DesignerEditorTestCase
extends AbstractJavaInfoRelatedTest {
    protected DesignerEditor m_designerEditor;
    protected IDesignPage m_designPage;
    protected DesignPageActions m_designPageActions;
    protected IComponentsTree m_componentsTree;
    protected PropertyTable m_propertyTable;
    protected JavaInfo m_contentJavaInfo;
    protected EditPart m_contentEditPart;
    protected GraphicalViewer m_viewerCanvas;
    protected GraphicalRobot canvas;
    protected GraphicalViewer m_headerHorizontal;
    protected GraphicalViewer m_headerVertical;
    protected TreeViewer m_viewerTree;
    protected TreeRobot tree;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        DesignerEditorTestCase.waitEventLoop(1);
        System.setProperty("FLAG_NO_PALETTE", "true");
        this.addExceptionsListener();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            System.clearProperty("FLAG_NO_PALETTE");
            DesignerEditorTestCase.waitEventLoop(0);
            TestUtils.closeAllEditors();
            DesignerEditorTestCase.waitEventLoop(0);
            this.removeExceptionsListener();
            this.assertNoLoggedExceptions();
        }
        finally {
            DesignerEditorTestCase.waitEventLoop(0);
            super.tearDown();
        }
    }

    protected static void assertEquals(Dimension expected, Dimension actual) {
        DesignerEditorTestCase.assertEquals((Object)expected, (Object)actual);
    }

    protected static void assertEquals(Dimension dimension, int width, int height) {
        DesignerEditorTestCase.assertEquals(new Dimension(width, height), dimension);
    }

    protected final void openDesign(IWizard wizard, IPackageFragment packageFragment, String fileName) throws Exception {
        new UiContext().executeAndCheck(context -> TestUtils.runWizard(wizard, (IStructuredSelection)new StructuredSelection((Object)packageFragment)), context -> {
            context.useShell(wizard.getWindowTitle());
            context.getTextByLabel("Name:").setText(fileName);
            context.clickButton("Finish");
        });
        ICompilationUnit cu = packageFragment.getCompilationUnit(fileName + ".java");
        this.openDesign(cu);
    }

    protected final void openDesign(ICompilationUnit unit) throws Exception {
        this.openEditor(unit);
        this.openDesignPage();
        this.fetchDesignViewers();
        this.fetchContentFields();
    }

    protected final void openEditor(ICompilationUnit unit) throws Exception {
        IWorkbenchPage activePage = DesignerPlugin.getActiveWorkbenchWindow().getActivePage();
        this.m_designerEditor = (DesignerEditor)IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)unit.getUnderlyingResource()), (String)"org.eclipse.wb.core.guiEditor");
        DesignerEditorTestCase.assertNotNull((Object)this.m_designerEditor);
        activePage.toggleZoom(activePage.getActivePartReference());
        DesignerEditorTestCase.waitEventLoop(1);
    }

    protected final void openSourcePage() throws Exception {
        this.m_designerEditor.getMultiMode().showSource();
        DesignerEditorTestCase.waitEventLoop(1);
    }

    protected final void openDesignPage() throws Exception {
        this.m_designerEditor.getMultiMode().showDesign();
        DesignerEditorTestCase.waitEventLoop(1);
    }

    protected void fetchDesignViewers() {
        this.m_designPage = this.m_designerEditor.getMultiMode().getDesignPage();
        Object designComposite = ReflectionUtils.getFieldObject((Object)this.m_designPage, (String)"m_designComposite");
        this.m_designPageActions = (DesignPageActions)ReflectionUtils.getFieldObject((Object)designComposite, (String)"m_pageActions");
        Object viewersComposite = ReflectionUtils.getFieldObject((Object)designComposite, (String)"m_viewersComposite");
        this.m_viewerCanvas = (GraphicalViewer)ReflectionUtils.getFieldObject((Object)viewersComposite, (String)"m_viewer");
        DesignerEditorTestCase.assertNotNull((Object)this.m_viewerCanvas);
        DesignerEditorTestCase.assertNotNull((Object)this.m_viewerCanvas.getEditDomain());
        this.canvas = new GraphicalRobot(this.m_viewerCanvas);
        this.m_headerHorizontal = (GraphicalViewer)ReflectionUtils.getFieldObject((Object)viewersComposite, (String)"m_horizontalViewer");
        this.m_headerVertical = (GraphicalViewer)ReflectionUtils.getFieldObject((Object)viewersComposite, (String)"m_verticalViewer");
        Object componentsComposite = ReflectionUtils.getFieldObject((Object)designComposite, (String)"m_componentsComposite");
        Object treePage = ReflectionUtils.getFieldObject((Object)componentsComposite, (String)"m_treePage");
        this.m_viewerTree = (TreeViewer)ReflectionUtils.getFieldObject((Object)treePage, (String)"m_viewer");
        DesignerEditorTestCase.assertNotNull((Object)this.m_viewerTree);
        DesignerEditorTestCase.assertNotNull((Object)this.m_viewerTree.getEditDomain());
        this.tree = new TreeRobot(this.m_viewerTree);
        DesignerEditorTestCase.assertSame((Object)this.m_viewerCanvas.getEditDomain(), (Object)this.m_viewerTree.getEditDomain());
    }

    protected void fetchContentFields() {
        DesignRootEditPart designRootEditPart = (DesignRootEditPart)this.m_viewerCanvas.getRootEditPart().getContents();
        this.m_contentEditPart = designRootEditPart.getJavaRootEditPart();
        this.m_contentJavaInfo = (JavaInfo)this.m_contentEditPart.getModel();
        this.m_lastEditor = this.m_contentJavaInfo.getEditor();
        UiContext uiContext = new UiContext();
        uiContext.useShell(DesignerPlugin.getShell().getText());
        DesignComponentsComposite componentComposite = uiContext.findFirstWidget(DesignComponentsComposite.class);
        Object componentPropertyPage = ReflectionUtils.getFieldObject((Object)componentComposite, (String)"m_propertiesPage");
        this.m_propertyTable = (PropertyTable)ReflectionUtils.getFieldObject((Object)componentPropertyPage, (String)"m_propertyTable");
        DesignPageSite designPageSite = DesignPageSite.Helper.getSite((ObjectInfo)this.m_contentJavaInfo);
        this.m_componentsTree = designPageSite.getComponentTree();
    }

    protected final void assertTreeSelectionModels(Object ... models) {
        IStructuredSelection selection = (IStructuredSelection)this.m_componentsTree.getSelectionProvider().getSelection();
        Object[] actualModels = selection.toArray();
        DesignerEditorTestCase.assertTrue((boolean)ArrayUtils.isEquals((Object)models, (Object)actualModels));
    }

    protected final void assertSelectionModels(Object ... models) {
        List editParts = this.m_viewerCanvas.getSelectedEditParts();
        DesignerEditorTestCase.assertEquals((long)models.length, (long)editParts.size());
        int i = 0;
        while (i < models.length) {
            Object model = models[i];
            EditPart editPart = (EditPart)editParts.get(i);
            DesignerEditorTestCase.assertSame((Object)model, (Object)editPart.getModel());
            ++i;
        }
    }

    protected final <T extends JavaInfo> T loadCreationTool(String componentClassName) throws Exception {
        return this.loadCreationTool(componentClassName, null);
    }

    protected final <T extends JavaInfo> T loadCreationTool(String componentClassName, String creationId) throws Exception {
        Class<?> componentClass = EditorState.get((AstEditor)this.m_lastEditor).getEditorLoader().loadClass(componentClassName);
        ConstructorCreationSupport creationSupport = new ConstructorCreationSupport(creationId, true);
        final JavaInfo newComponent = JavaInfoUtils.getWrapped((JavaInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, componentClass, (CreationSupport)creationSupport));
        newComponent.putArbitraryValue((Object)"manuallyCreatedComponent", (Object)Boolean.TRUE);
        ICreationFactory factory = new ICreationFactory(){

            public void activate() {
            }

            public Object getNewObject() {
                return newComponent;
            }
        };
        CreationTool creationTool = new CreationTool(factory);
        this.m_viewerCanvas.getEditDomain().setActiveTool((Tool)creationTool);
        return (T)newComponent;
    }

    protected final DatabindingsProvider getDatabindingsProvider() throws Exception {
        ParseState parseState = (ParseState)DatabindingRootProcessor.STATES.get(this.m_lastEditor.getModelUnit());
        DesignerEditorTestCase.assertNotNull((Object)parseState);
        DesignerEditorTestCase.assertNotNull((Object)parseState.databindingsProvider);
        DesignerEditorTestCase.assertInstanceOf(DatabindingsProvider.class, (Object)parseState.databindingsProvider);
        return (DatabindingsProvider)parseState.databindingsProvider;
    }

    protected final void assertJavaInfo(String infoName) throws Exception {
        DatabindingsProvider provider = this.getDatabindingsProvider();
        WidgetsObserveTypeContainer container = (WidgetsObserveTypeContainer)provider.getContainer(ObserveType.WIDGETS);
        DesignerEditorTestCase.assertNotNull((Object)container);
        DesignerEditorTestCase.assertNotNull((Object)container.resolve(DesignerEditorTestCase.getJavaInfoByName(infoName)));
    }

    protected final void assertJavaSelection(int expectedOffset, int expectedLength) {
        ISelectionProvider selectionProvider = this.m_designerEditor.getSelectionProvider();
        ITextSelection selection = (ITextSelection)selectionProvider.getSelection();
        DesignerEditorTestCase.assertEquals((long)expectedOffset, (long)selection.getOffset());
        DesignerEditorTestCase.assertEquals((long)expectedLength, (long)selection.getLength());
    }

    protected final IAction getDeleteAction() {
        IActionBars actionBars = this.m_designerEditor.getEditorSite().getActionBars();
        return actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
    }

    protected final IAction getCutAction() {
        IActionBars actionBars = this.m_designerEditor.getEditorSite().getActionBars();
        return actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
    }

    protected final IAction getCopyAction() {
        IActionBars actionBars = this.m_designerEditor.getEditorSite().getActionBars();
        return actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
    }

    protected final IAction getPasteAction() {
        IActionBars actionBars = this.m_designerEditor.getEditorSite().getActionBars();
        return actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
    }

    protected final void doCopyPaste(JavaInfo javaInfo) {
        this.canvas.select(javaInfo);
        IAction copyAction = this.getCopyAction();
        DesignerEditorTestCase.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        DesignerEditorTestCase.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
    }
}

