/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.databinding.rcp;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.junit.BeforeClass;
import org.junit.Test;

public class UtilsTest
extends AbstractJavaTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        UtilsTest.do_projectCreate();
    }

    @Test
    public void test_getNodeReference() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {", "  private String m_name;", "  private String m_name2 = '123';", "  private Test test = null;", "  public void foo() {", "    foo(m_name);", "    foo(this.m_name2);", "    foo(getName());", "    foo(this.test.getName());", "    foo(getTest().test.getName());", "    m_name = getName();", "    this.m_name = m_name2;", "    Test.this.m_name = m_name2;", "    test.m_name2 = '4567';", "    new String('aaa');", "  }", "  String getName() {", "    return m_name;", "  }", "  Test getTest() {", "    return this;", "  }", "  void foo(String value) {", "  }", "}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        UtilsTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        UtilsTest.assertNotNull((Object)statements);
        UtilsTest.assertEquals((long)10L, (long)statements.size());
        MethodInvocation invocation0 = UtilsTest.getMethodInvocation(statements, 0);
        UtilsTest.assertEquals((Object)"m_name", (Object)CoreUtils.getNodeReference((ASTNode)((ASTNode)DomGenerics.arguments((MethodInvocation)invocation0).get(0))));
        MethodInvocation invocation1 = UtilsTest.getMethodInvocation(statements, 1);
        UtilsTest.assertEquals((Object)"m_name2", (Object)CoreUtils.getNodeReference((ASTNode)((ASTNode)DomGenerics.arguments((MethodInvocation)invocation1).get(0))));
        MethodInvocation invocation2 = UtilsTest.getMethodInvocation(statements, 2);
        UtilsTest.assertEquals((Object)"getName()", (Object)CoreUtils.getNodeReference((ASTNode)((ASTNode)DomGenerics.arguments((MethodInvocation)invocation2).get(0))));
        MethodInvocation invocation3 = UtilsTest.getMethodInvocation(statements, 3);
        UtilsTest.assertEquals((Object)"test.getName()", (Object)CoreUtils.getNodeReference((ASTNode)((ASTNode)DomGenerics.arguments((MethodInvocation)invocation3).get(0))));
        MethodInvocation invocation4 = UtilsTest.getMethodInvocation(statements, 4);
        UtilsTest.assertEquals((Object)"getTest().test.getName()", (Object)CoreUtils.getNodeReference((ASTNode)((ASTNode)DomGenerics.arguments((MethodInvocation)invocation4).get(0))));
        Assignment assignment5 = UtilsTest.getAssignment(statements, 5);
        UtilsTest.assertEquals((Object)"m_name", (Object)CoreUtils.getNodeReference((ASTNode)assignment5.getLeftHandSide()));
        Assignment assignment6 = UtilsTest.getAssignment(statements, 6);
        UtilsTest.assertEquals((Object)"m_name", (Object)CoreUtils.getNodeReference((ASTNode)assignment6.getLeftHandSide()));
        Assignment assignment7 = UtilsTest.getAssignment(statements, 7);
        UtilsTest.assertEquals((Object)"m_name", (Object)CoreUtils.getNodeReference((ASTNode)assignment7.getLeftHandSide()));
        Assignment assignment8 = UtilsTest.getAssignment(statements, 8);
        UtilsTest.assertEquals((Object)"test.Test.m_name2", (Object)CoreUtils.getNodeReference((ASTNode)assignment8.getLeftHandSide()));
        ClassInstanceCreation creation = UtilsTest.getClassInstanceCreation(statements, 9);
        try {
            CoreUtils.getNodeReference((ASTNode)creation);
        }
        catch (AssertionFailedException e) {
            UtilsTest.assertEquals((Object)("Unknown reference: " + String.valueOf(creation)), (Object)e.getMessage());
        }
    }

    @Test
    public void test_getMethodSignature() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {", "  void foo() {", "    System.getProperty('os.name');", "  }", "}");
        MethodDeclaration[] methods = type.getMethods();
        List statements = DomGenerics.statements((Block)methods[0].getBody());
        ExpressionStatement statement = (ExpressionStatement)statements.get(0);
        UtilsTest.assertEquals((Object)"java.lang.System.getProperty(java.lang.String)", (Object)CoreUtils.getMethodSignature((MethodInvocation)((MethodInvocation)statement.getExpression())));
    }

    @Test
    public void test_getCreationSignature() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {", "  void foo() {", "    new String('string');", "  }", "}");
        MethodDeclaration[] methods = type.getMethods();
        List statements = DomGenerics.statements((Block)methods[0].getBody());
        ExpressionStatement statement = (ExpressionStatement)statements.get(0);
        UtilsTest.assertEquals((Object)"java.lang.String.<init>(java.lang.String)", (Object)CoreUtils.getCreationSignature((ClassInstanceCreation)((ClassInstanceCreation)statement.getExpression())));
    }

    @Test
    public void test_getDefaultString() throws Exception {
        UtilsTest.assertEquals((Object)"default", (Object)CoreUtils.getDefaultString(null, null, (String)"default"));
        UtilsTest.assertEquals((Object)"default", (Object)CoreUtils.getDefaultString(null, (String)"prefix", (String)"default"));
        UtilsTest.assertEquals((Object)"|string|", (Object)CoreUtils.getDefaultString((String)"string", (String)"|", (String)"default"));
        UtilsTest.assertEquals((Object)"|string|", (Object)CoreUtils.getDefaultString((String)"string", (String)"|", null));
    }

    @Test
    public void test_joinStrings() throws Exception {
        UtilsTest.assertEquals((Object)"", (Object)CoreUtils.joinStrings(null, (String[])new String[0]));
        UtilsTest.assertEquals((Object)"", (Object)CoreUtils.joinStrings((String)"delimeter", (String[])new String[0]));
        UtilsTest.assertEquals((Object)"1, 2, 3, 4", (Object)CoreUtils.joinStrings((String)", ", (String[])new String[]{"1", "2", null, "3", "4"}));
        UtilsTest.assertEquals((Object)"1, 2, 3, 4", (Object)CoreUtils.joinStrings((String)", ", (String[])new String[]{null, "1", "2", "3", "4"}));
        UtilsTest.assertEquals((Object)"1, 2, 3, 4", (Object)CoreUtils.joinStrings((String)", ", (String[])new String[]{"1", "2", "3", "4", null}));
    }

    @Test
    public void test_loadClass() throws Exception {
        UtilsTest.assertSame(String.class, (Object)CoreUtils.loadClass((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"java.lang.String"));
        UtilsTest.assertNull((Object)CoreUtils.loadClass((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"java.lang.Strong"));
    }

    @Test
    public void test_isAssignableFrom1() throws Exception {
        UtilsTest.assertTrue((boolean)CoreUtils.isAssignableFrom(Object.class, String.class));
        UtilsTest.assertFalse((boolean)CoreUtils.isAssignableFrom(null, String.class));
    }

    @Test
    public void test_isAssignableFrom2() throws Exception {
        UtilsTest.assertTrue((boolean)CoreUtils.isAssignableFrom((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"java.lang.Object", String.class));
        UtilsTest.assertFalse((boolean)CoreUtils.isAssignableFrom((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"java.lang.OBJECT", String.class));
    }

    static MethodInvocation getMethodInvocation(List<?> statements, int index) {
        ExpressionStatement statement = (ExpressionStatement)statements.get(index);
        return (MethodInvocation)statement.getExpression();
    }

    static Assignment getAssignment(List<?> statements, int index) {
        ExpressionStatement statement = (ExpressionStatement)statements.get(index);
        return (Assignment)statement.getExpression();
    }

    static ClassInstanceCreation getClassInstanceCreation(List<?> statements, int index) {
        ExpressionStatement statement = (ExpressionStatement)statements.get(index);
        return (ClassInstanceCreation)statement.getExpression();
    }
}

