/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.jdt.core;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.reflect.ProjectClassLoader;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.core.TestProject;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.junit.Before;
import org.junit.Test;

public class CodeUtilsTest
extends AbstractJavaTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            CodeUtilsTest.do_projectCreate();
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getShortClass() {
        CodeUtilsTest.assertEquals((Object)"boolean", (Object)CodeUtils.getShortClass((String)"boolean"));
        CodeUtilsTest.assertEquals((Object)"List", (Object)CodeUtils.getShortClass((String)"java.util.List"));
        CodeUtilsTest.assertEquals((Object)"Sub", (Object)CodeUtils.getShortClass((String)"test.MyPanel$Sub"));
    }

    @Test
    public void test_getPackage() {
        CodeUtilsTest.assertEquals((Object)"", (Object)CodeUtils.getPackage((String)"SimpleName"));
        CodeUtilsTest.assertEquals((Object)"java.util", (Object)CodeUtils.getPackage((String)"java.util.List"));
    }

    @Test
    public void test_isSamePackage() {
        CodeUtilsTest.assertTrue((boolean)CodeUtils.isSamePackage((String)"java.util.List", (String)"java.util.Set"));
        CodeUtilsTest.assertFalse((boolean)CodeUtils.isSamePackage((String)"java.util.List", (String)"java.lang.Object"));
    }

    @Test
    public void test_join_1() {
        CodeUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"aaa"}, (Object)CodeUtils.join(null, (String)"aaa")));
        CodeUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"aaa", "bbb", "ccc"}, (Object)CodeUtils.join((String[])new String[]{"aaa", "bbb"}, (String)"ccc")));
    }

    @Test
    public void test_join_2() {
        CodeUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"aaa", "bbb"}, (Object)CodeUtils.join(null, (String[])new String[]{"aaa", "bbb"})));
        CodeUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"aaa", "bbb"}, (Object)CodeUtils.join((String[])new String[]{"aaa", "bbb"}, null)));
        CodeUtilsTest.assertTrue((boolean)ArrayUtils.isEquals((Object)new String[]{"aaa", "bbb", "ccc"}, (Object)CodeUtils.join((String[])new String[]{"aaa", "bbb"}, (String[])new String[]{"ccc"})));
    }

    @Test
    public void test_join_3() {
        String[] a = new String[]{"a", "aa"};
        String[] b = new String[]{"b", "bb"};
        String[] c = new String[]{"c", "cc"};
        Object[] result = CodeUtils.join((String[])a, (String[])b, (String[])c);
        CodeUtilsTest.assertArrayEquals((Object[])result, (Object[])new String[]{"a", "aa", "b", "bb", "c", "cc"});
    }

    @Test
    public void test_getSource() throws Exception {
        CodeUtilsTest.assertEquals((Object)"aaa\nbbb\nccc", (Object)CodeUtils.getSource((String[])new String[]{"aaa", "bbb", "ccc"}));
    }

    @Test
    public void test_generateUniqueName() throws Exception {
        CodeUtilsTest.assertSame((Object)"base", (Object)CodeUtils.generateUniqueName((String)"base", o -> true));
        CodeUtilsTest.assertEquals((Object)"base_3", (Object)CodeUtils.generateUniqueName((String)"base", name -> !name.equals("base") && !name.equals("base_1") && !name.equals("base_2")));
    }

    @Test
    public void test_clearHiddenCode_parsing() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler", "public class Test {", "  int field; //$hide$", "}");
        CodeUtilsTest.assertEquals((long)0L, (long)typeDeclaration.getFields().length);
    }

    @Test
    public void test_clearHiddenCode_block() throws Exception {
        String[] lines_1 = new String[]{"000", "1//$hide>>$1", "222", "333", "4//$hide<<$4", "555"};
        String[] lines_2 = new String[]{"000", "1//         ", "   ", "   ", "            ", "555"};
        this.check_clearHiddenCode(lines_1, lines_2);
    }

    @Test
    public void test_clearHiddenCode_withSpace_line() throws Exception {
        String[] lines_1 = new String[]{"000", "111// $hide$", "222"};
        String[] lines_2 = new String[]{"000", "            ", "222"};
        this.check_clearHiddenCode(lines_1, lines_2);
    }

    @Test
    public void test_clearHiddenCode_withSpace_block() throws Exception {
        String[] lines_1 = new String[]{"000", "1// $hide>>$11", "222", "3// $hide<<$33", "444"};
        String[] lines_2 = new String[]{"000", "1//           ", "   ", "              ", "444"};
        this.check_clearHiddenCode(lines_1, lines_2);
    }

    @Test
    public void test_clearHiddenCode_blockNoBegin() throws Exception {
        String[] lines_1 = new String[]{"000", "222", "333", "//$hide<<$", "444"};
        try {
            this.check_clearHiddenCode(lines_1, ArrayUtils.EMPTY_STRING_ARRAY);
            CodeUtilsTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void test_clearHiddenCode_blockNoEnd() throws Exception {
        String[] lines_1 = new String[]{"000", "//$hide>>$", "222", "333", "444"};
        try {
            this.check_clearHiddenCode(lines_1, ArrayUtils.EMPTY_STRING_ARRAY);
            CodeUtilsTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void test_clearHiddenCode_blockWrongSequence() throws Exception {
        String[] lines_1 = new String[]{"000", "//$hide<<$", "222", "333", "//$hide>>$", "444"};
        try {
            this.check_clearHiddenCode(lines_1, ArrayUtils.EMPTY_STRING_ARRAY);
            CodeUtilsTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void test_clearHiddenCode_line() throws Exception {
        String[] lines_1 = new String[]{"000", "222 //$hide$", "333"};
        String[] lines_2 = new String[]{"000", "            ", "333"};
        this.check_clearHiddenCode(lines_1, lines_2);
    }

    private void check_clearHiddenCode(String[] lines, String[] expectedLines) throws Exception {
        String source = StringUtils.join((Object[])lines, (String)"\n");
        String expectedSource = StringUtils.join((Object[])expectedLines, (String)"\n");
        try {
            String clearedSource = (String)ReflectionUtils.invokeMethod(CodeUtils.class, (String)"clearHiddenCode(java.lang.String)", (Object[])new Object[]{source});
            CodeUtilsTest.assertEquals((Object)expectedSource, (Object)clearedSource);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getCause();
        }
    }

    @Test
    public void test_getProjectClassLoader() throws Exception {
        CodeUtilsTest.setFileContentSrc("test/Test.java", CodeUtilsTest.getSourceDQ("package test;", "public class Test {", "}"));
        CodeUtilsTest.waitForAutoBuild();
        ProjectClassLoader projectClassLoader = CodeUtils.getProjectClassLoader((IJavaProject)m_testProject.getJavaProject());
        projectClassLoader.loadClass("test.Test");
    }

    @DisposeProjectAfter
    @Test
    public void test_getSourceContainers_notJavaProject() throws Exception {
        ProjectUtils.removeNature((IProject)m_project, (String)"org.eclipse.jdt.core.javanature");
        List sourceContainers = CodeUtils.getSourceContainers((IJavaProject)m_javaProject, (boolean)true);
        Assertions.assertThat((List)sourceContainers).isEmpty();
    }

    @Test
    public void test_getSourceContainers_1() throws Exception {
        IJavaProject javaProject = m_testProject.getJavaProject();
        List sourceContainers = CodeUtils.getSourceContainers((IJavaProject)javaProject, (boolean)true);
        Assertions.assertThat((List)sourceContainers).hasSize(1);
        CodeUtilsTest.assertEquals((Object)"/TestProject/src", (Object)((IContainer)sourceContainers.get(0)).getFullPath().toString());
    }

    @DisposeProjectAfter
    @Test
    public void test_getSourceContainers_2() throws Exception {
        Object[] rawClasspath = m_javaProject.getRawClasspath();
        rawClasspath = (IClasspathEntry[])ArrayUtils.remove((Object[])rawClasspath, (int)(rawClasspath.length - 1));
        m_javaProject.setRawClasspath((IClasspathEntry[])rawClasspath, (IProgressMonitor)new NullProgressMonitor());
        m_testProject.addSourceFolder("/TestProject");
        List sourceContainers = CodeUtils.getSourceContainers((IJavaProject)m_javaProject, (boolean)true);
        Assertions.assertThat((List)sourceContainers).hasSize(1);
        CodeUtilsTest.assertEquals((Object)"/TestProject", (Object)((IContainer)sourceContainers.get(0)).getFullPath().toString());
    }

    @DisposeProjectAfter
    @Test
    public void test_getSourceContainers_3() throws Exception {
        TestProject myProject = new TestProject("myProject");
        IJavaProject myJavaProject = myProject.getJavaProject();
        try {
            ProjectUtils.requireProject((IJavaProject)m_javaProject, (IJavaProject)myJavaProject);
            List sourceContainers = CodeUtils.getSourceContainers((IJavaProject)m_javaProject, (boolean)true);
            Assertions.assertThat((List)sourceContainers).hasSize(2);
            CodeUtilsTest.assertEquals((Object)"/TestProject/src", (Object)((IContainer)sourceContainers.get(0)).getFullPath().toString());
            CodeUtilsTest.assertEquals((Object)"/myProject/src", (Object)((IContainer)sourceContainers.get(1)).getFullPath().toString());
        }
        finally {
            myProject.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_getSourceContainers_4() throws Exception {
        TestProject myProject = new TestProject("myProject");
        IJavaProject myJavaProject = myProject.getJavaProject();
        try {
            ProjectUtils.requireProject((IJavaProject)m_javaProject, (IJavaProject)myJavaProject);
            ProjectUtils.requireProject((IJavaProject)myJavaProject, (IJavaProject)m_javaProject);
            List sourceContainers = CodeUtils.getSourceContainers((IJavaProject)m_javaProject, (boolean)true);
            Assertions.assertThat((List)sourceContainers).hasSize(2);
            CodeUtilsTest.assertEquals((Object)"/TestProject/src", (Object)((IContainer)sourceContainers.get(0)).getFullPath().toString());
            CodeUtilsTest.assertEquals((Object)"/myProject/src", (Object)((IContainer)sourceContainers.get(1)).getFullPath().toString());
        }
        finally {
            myProject.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_geSourceContainers_notExistingSourceFolder() throws Exception {
        m_testProject.addSourceFolder("/TestProject/src2");
        List sourceContainers = CodeUtils.getSourceContainers((IJavaProject)m_javaProject, (boolean)true);
        Assertions.assertThat((List)sourceContainers).hasSize(1);
        CodeUtilsTest.assertEquals((Object)"/TestProject/src", (Object)((IContainer)sourceContainers.get(0)).getFullPath().toString());
    }

    @DisposeProjectAfter
    @Test
    public void test_getSourceContainers_PDE() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null);
        TestProject fragmentProject = new TestProject("TestProject_ru");
        try {
            PdeProjectConversionUtils.convertToPDE(fragmentProject.getProject(), "TestProject");
            CodeUtilsTest.waitForAutoBuild();
            List sourceContainers = CodeUtils.getSourceContainers((IJavaProject)m_testProject.getJavaProject(), (boolean)true);
            Assertions.assertThat((List)sourceContainers).hasSize(2);
            CodeUtilsTest.assertEquals((Object)"/TestProject/src", (Object)((IContainer)sourceContainers.get(0)).getFullPath().toString());
            CodeUtilsTest.assertEquals((Object)"/TestProject_ru/src", (Object)((IContainer)sourceContainers.get(1)).getFullPath().toString());
        }
        finally {
            fragmentProject.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_getSourceContainers_PDE_noJavaNature() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_project, null);
        TestProject fragmentProject = new TestProject("TestProject_ru");
        try {
            PdeProjectConversionUtils.convertToPDE(fragmentProject.getProject(), "TestProject");
            ProjectUtils.removeNature((IProject)fragmentProject.getProject(), (String)"org.eclipse.jdt.core.javanature");
            CodeUtilsTest.waitForAutoBuild();
            List sourceContainers = CodeUtils.getSourceContainers((IJavaProject)m_javaProject, (boolean)true);
            Assertions.assertThat((List)sourceContainers).hasSize(1);
            CodeUtilsTest.assertEquals((Object)"/TestProject/src", (Object)((IContainer)sourceContainers.get(0)).getFullPath().toString());
        }
        finally {
            fragmentProject.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_getSourceContainers_PDE_oldNotOSGi() throws Exception {
        CodeUtilsTest.setFileContent("plugin.xml", CodeUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<plugin name='foo' id='some.id'>", "</plugin>"));
        CodeUtilsTest.waitForAutoBuild();
        List sourceContainers = CodeUtils.getSourceContainers((IJavaProject)m_testProject.getJavaProject(), (boolean)true);
        Assertions.assertThat((List)sourceContainers).hasSize(1);
        CodeUtilsTest.assertEquals((Object)"/TestProject/src", (Object)((IContainer)sourceContainers.get(0)).getFullPath().toString());
    }

    @Test
    public void test_getPackageFragmentRoot_1() throws Exception {
        IType type = this.createModelType("test", "Test.java", CodeUtilsTest.getSourceDQ("package test;", "public class Test {", "  public Test() {", "  }", "}"));
        String expectedPath = "/TestProject/src";
        IType element = null;
        IPackageFragmentRoot packageFragmentRoot = CodeUtils.getPackageFragmentRoot(element);
        CodeUtilsTest.assertNull((Object)packageFragmentRoot);
        element = type;
        packageFragmentRoot = CodeUtils.getPackageFragmentRoot((IJavaElement)element);
        CodeUtilsTest.assertPackageFragmentRootPath(expectedPath, packageFragmentRoot);
        element = type.getCompilationUnit();
        packageFragmentRoot = CodeUtils.getPackageFragmentRoot((IJavaElement)element);
        CodeUtilsTest.assertPackageFragmentRootPath(expectedPath, packageFragmentRoot);
        element = type.getMethods()[0];
        packageFragmentRoot = CodeUtils.getPackageFragmentRoot((IJavaElement)element);
        CodeUtilsTest.assertPackageFragmentRootPath(expectedPath, packageFragmentRoot);
    }

    @Test
    public void test_getPackageFragmentRoot_2() throws Exception {
        try {
            IJavaProject javaProject;
            IJavaProject element = javaProject = m_testProject.getJavaProject();
            IPackageFragmentRoot packageFragmentRoot = CodeUtils.getPackageFragmentRoot((IJavaElement)element);
            CodeUtilsTest.assertPackageFragmentRootPath("/TestProject/src", packageFragmentRoot);
        }
        finally {
            CodeUtilsTest.do_projectDispose();
            CodeUtilsTest.do_projectCreate();
        }
    }

    @Test
    public void test_getPackageFragmentRoot_3() throws Exception {
        try {
            IJavaProject javaProject = m_testProject.getJavaProject();
            Object[] rawClasspath = javaProject.getRawClasspath();
            rawClasspath = (IClasspathEntry[])ArrayUtils.remove((Object[])rawClasspath, (int)(rawClasspath.length - 1));
            javaProject.setRawClasspath((IClasspathEntry[])rawClasspath, (IProgressMonitor)new NullProgressMonitor());
            rawClasspath = javaProject.getRawClasspath();
            rawClasspath = (IClasspathEntry[])ArrayUtils.add((Object[])rawClasspath, (Object)JavaCore.newSourceEntry((IPath)new Path("/TestProject")));
            javaProject.setRawClasspath((IClasspathEntry[])rawClasspath, (IProgressMonitor)new NullProgressMonitor());
            IJavaProject element = javaProject;
            IPackageFragmentRoot packageFragmentRoot = CodeUtils.getPackageFragmentRoot((IJavaElement)element);
            CodeUtilsTest.assertPackageFragmentRootPath("/TestProject", packageFragmentRoot);
        }
        finally {
            CodeUtilsTest.do_projectDispose();
            CodeUtilsTest.do_projectCreate();
        }
    }

    private static void assertPackageFragmentRootPath(String expectedPath, IPackageFragmentRoot packageFragmentRoot) throws Exception {
        CodeUtilsTest.assertEquals((Object)expectedPath, (Object)packageFragmentRoot.getUnderlyingResource().getFullPath().toString());
    }

    @Test
    public void test_findPrimaryType_ok() throws Exception {
        ICompilationUnit compilationUnit = this.createModelCompilationUnit("test", "Test.java", CodeUtilsTest.getSourceDQ("package test;", "class test_private_class {", "}", "public class Test {", "}"));
        IType primaryType = CodeUtils.findPrimaryType((ICompilationUnit)compilationUnit);
        CodeUtilsTest.assertNotNull((Object)primaryType);
        CodeUtilsTest.assertTrue((boolean)primaryType.getElementName().equals("Test"));
    }

    @Test
    public void test_findPrimaryType_no() throws Exception {
        ICompilationUnit compilationUnit = this.createModelCompilationUnit("test", "Test.java", CodeUtilsTest.getSourceDQ("package test;", "class test_private_class {", "}", "class test_private_class2 {", "}"));
        IType primaryType = CodeUtils.findPrimaryType((ICompilationUnit)compilationUnit);
        CodeUtilsTest.assertNull((Object)primaryType);
    }

    @Test
    public void test_searchReferences_IType_IField() throws Exception {
        IType targetType = this.createModelCompilationUnit("test", "Target.java", CodeUtilsTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Target {", "}")).getTypes()[0];
        this.createModelCompilationUnit("test", "Test.java", CodeUtilsTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "  private Target myTarget;", "}"));
        List references = CodeUtils.searchReferences((IType)targetType);
        Assertions.assertThat((List)references).hasSize(1);
        IField fieldElement = (IField)references.get(0);
        CodeUtilsTest.assertEquals((Object)"myTarget", (Object)fieldElement.getElementName());
    }

    @Test
    public void test_searchReferences_IType_IAnnotation() throws Exception {
        IType targetType = this.createModelCompilationUnit("test", "MyAnnotation.java", CodeUtilsTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public @interface MyAnnotation {", "}")).getTypes()[0];
        this.createModelCompilationUnit("test", "Test.java", CodeUtilsTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "@MyAnnotation", "public class Test {", "}"));
        List references = CodeUtils.searchReferences((IType)targetType);
        Assertions.assertThat((List)references).hasSize(1);
        IAnnotation annotation = (IAnnotation)references.get(0);
        CodeUtilsTest.assertEquals((Object)"MyAnnotation", (Object)annotation.getElementName());
    }

    @Test
    public void test_searchReferences_IField() throws Exception {
        IField targetField = this.createModelCompilationUnit("test", "Target.java", CodeUtilsTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Target {", "  int myField;", "}")).getTypes()[0].getFields()[0];
        IType type = this.createModelCompilationUnit("test", "Test.java", CodeUtilsTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "  void foo(Target t) {", "    t.myField = 1;", "  }", "}")).getTypes()[0];
        List references = CodeUtils.searchReferences((IField)targetField);
        Assertions.assertThat((List)references).hasSize(1);
        IMethod methodElement = (IMethod)references.get(0);
        CodeUtilsTest.assertEquals((Object)type.getMethods()[0], (Object)methodElement);
        CodeUtilsTest.assertEquals((Object)"foo", (Object)methodElement.getElementName());
    }

    @Test
    public void test_getType() throws Exception {
        IType listType;
        IJavaProject javaProject = m_testProject.getJavaProject();
        IType element = listType = javaProject.findType("java.util.List");
        CodeUtilsTest.assertEquals((Object)"java.util.List", (Object)CodeUtils.getType((IJavaElement)element).getFullyQualifiedName());
        element = listType.getMethods()[0];
        CodeUtilsTest.assertEquals((Object)"java.util.List", (Object)CodeUtils.getType((IJavaElement)element).getFullyQualifiedName());
        element = listType.getClassFile();
        CodeUtilsTest.assertEquals((Object)"java.util.List", (Object)CodeUtils.getType((IJavaElement)element).getFullyQualifiedName());
        IType type = this.createModelType("test", "Test.java", CodeUtilsTest.getSourceDQ("package test;", "public class Test {", "}", "", "class NonMainType {", "}"));
        ICompilationUnit element2 = type.getCompilationUnit();
        CodeUtilsTest.assertEquals((Object)"test.Test", (Object)CodeUtils.getType((IJavaElement)element2).getFullyQualifiedName());
        element = null;
        CodeUtilsTest.assertNull((Object)CodeUtils.getType((IJavaElement)element));
    }

    @Test
    public void test_getResolvedTypeName() throws Exception {
        ICompilationUnit unit = this.createModelCompilationUnit("test", "Test.java", CodeUtilsTest.getSourceDQ("package test;", "import java.util.*;", "public class Test {", "}"));
        IType type = unit.getTypes()[0];
        CodeUtilsTest.assertEquals((Object)"int", (Object)CodeUtils.getResolvedTypeName((IType)type, (String)"I"));
        CodeUtilsTest.assertEquals((Object)"long", (Object)CodeUtils.getResolvedTypeName((IType)type, (String)"J"));
        CodeUtilsTest.assertEquals((Object)"int[]", (Object)CodeUtils.getResolvedTypeName((IType)type, (String)"[I"));
        CodeUtilsTest.assertEquals((Object)"int[][]", (Object)CodeUtils.getResolvedTypeName((IType)type, (String)"[[I"));
        CodeUtilsTest.assertEquals((Object)"java.util.List", (Object)CodeUtils.getResolvedTypeName((IType)type, (String)"QList;"));
        CodeUtilsTest.assertNull((Object)CodeUtils.getResolvedTypeName((IType)type, (String)"QNoSuchName;"));
    }

    @Test
    public void test_getResolvedTypeName_forTypeVariable_hasBounds() throws Exception {
        IType type = this.createModelType("test", "Test.java", CodeUtilsTest.getSource("package test;", "public class Test<E extends java.awt.Component> {", "  // filler", "}"));
        CodeUtilsTest.assertEquals((Object)"java.awt.Component", (Object)CodeUtils.getResolvedTypeName((IType)type, (String)"TE;"));
        CodeUtilsTest.assertEquals((Object)"java.awt.Component", (Object)CodeUtils.getResolvedTypeName((IType)type, (String)"QE;"));
    }

    @Test
    public void test_getResolvedTypeName_forTypeVariable_noBounds() throws Exception {
        IType type = this.createModelType("test", "Test.java", CodeUtilsTest.getSource("package test;", "public class Test<E> {", "  // filler filler filler", "}"));
        CodeUtilsTest.assertEquals((Object)"java.lang.Object", (Object)CodeUtils.getResolvedTypeName((IType)type, (String)"TE;"));
        CodeUtilsTest.assertEquals((Object)"java.lang.Object", (Object)CodeUtils.getResolvedTypeName((IType)type, (String)"QE;"));
    }

    @Test
    public void test_getMethodSignature() throws Exception {
        ICompilationUnit unit = this.createModelCompilationUnit("test", "Test.java", CodeUtilsTest.getSourceDQ("package test;", "import java.util.ArrayList;", "class Test {", "  void foo() {", "  }", "  void foo(int p1) {", "  }", "  void foo(int p1, float p2) {", "  }", "  void foo(int[][] p1) {", "  }", "  void foo(java.util.List list) {", "  }", "  void foo(ArrayList list) {", "  }", "  void foo(ArrayList [] list[]) {", "  }", "  Test(int a) {", "  }", "}"));
        IMethod[] methods = unit.getTypes()[0].getMethods();
        CodeUtilsTest.assertEquals((Object)"foo()", (Object)CodeUtils.getMethodSignature((IMethod)methods[0]));
        CodeUtilsTest.assertEquals((Object)"foo(int)", (Object)CodeUtils.getMethodSignature((IMethod)methods[1]));
        CodeUtilsTest.assertEquals((Object)"foo(int,float)", (Object)CodeUtils.getMethodSignature((IMethod)methods[2]));
        CodeUtilsTest.assertEquals((Object)"foo(int[][])", (Object)CodeUtils.getMethodSignature((IMethod)methods[3]));
        CodeUtilsTest.assertEquals((Object)"foo(java.util.List)", (Object)CodeUtils.getMethodSignature((IMethod)methods[4]));
        CodeUtilsTest.assertEquals((Object)"foo(java.util.ArrayList)", (Object)CodeUtils.getMethodSignature((IMethod)methods[5]));
        CodeUtilsTest.assertEquals((Object)"foo(java.util.ArrayList[][])", (Object)CodeUtils.getMethodSignature((IMethod)methods[6]));
        CodeUtilsTest.assertEquals((Object)"<init>(int)", (Object)CodeUtils.getMethodSignature((IMethod)methods[7]));
    }

    @Test
    public void test_getMethodSignature_withGenerics() throws Exception {
        IType type = this.createModelType("test", "Test.java", CodeUtilsTest.getSourceDQ("package test;", "import java.awt.Component;", "public class Test<T extends Component> {", "  void foo(T component) {", "  }", "}"));
        IMethod method = type.getMethods()[0];
        CodeUtilsTest.assertEquals((Object)"foo(java.awt.Component)", (Object)CodeUtils.getMethodSignature((IMethod)method));
    }

    @Test
    public void test_getMethodSignature_withGenerics_array() throws Exception {
        IType type = m_javaProject.findType("javax.swing.JComboBox");
        IMethod method = type.getMethod("JComboBox", new String[]{"[TE;"});
        CodeUtilsTest.assertEquals((Object)"<init>(java.lang.Object[])", (Object)CodeUtils.getMethodSignature((IMethod)method));
    }

    @Test
    public void test_findMethod_withType() throws Exception {
        IType aType = this.createModelCompilationUnit("test", "A.java", CodeUtilsTest.getSourceDQ("package test;", "public class A {", "  public void foo() {", "  }", "}")).getTypes()[0];
        IType bType = this.createModelCompilationUnit("test", "B.java", CodeUtilsTest.getSourceDQ("package test;", "public class B extends A {", "  public void bar() {", "  }", "}")).getTypes()[0];
        IMethod method = CodeUtils.findMethod((IType)aType, (String)"foo()");
        CodeUtilsTest.assertSame((Object)aType.getMethods()[0], (Object)method);
        method = CodeUtils.findMethod((IType)bType, (String)"foo()");
        CodeUtilsTest.assertSame((Object)aType.getMethods()[0], (Object)method);
        method = CodeUtils.findMethod((IType)bType, (String)"bar()");
        CodeUtilsTest.assertSame((Object)bType.getMethods()[0], (Object)method);
        method = CodeUtils.findMethod(null, (String)"noMatter()");
        CodeUtilsTest.assertNull((Object)method);
        method = CodeUtils.findMethod((IType)bType, (String)"noSuchMethod()");
        CodeUtilsTest.assertNull((Object)method);
    }

    @Test
    public void test_findMethod() throws Exception {
        ICompilationUnit aUnit = this.createModelCompilationUnit("test", "A.java", CodeUtilsTest.getSourceDQ("package test;", "class A {", "  A() {", "  }", "  void foo() {", "  }", "  void bar() {", "  }", "}"));
        this.createModelCompilationUnit("test", "B.java", CodeUtilsTest.getSourceDQ("// filler filler filler filler filler", "package test;", "class B extends A {", "  void foo() {", "  }", "}"));
        TypeDeclaration type = this.createTypeDeclaration_Test("class Test {", "  void test() {", "    (new A()).foo();", "    (new B()).foo();", "  }", "}");
        IJavaProject project = this.m_lastEditor.getJavaProject();
        IMethod method = CodeUtils.findMethod((IJavaProject)project, (String)"test.A", (String)"<init>()");
        CodeUtilsTest.assertSame((Object)aUnit.getTypes()[0].getMethods()[0], (Object)method);
        method = CodeUtils.findMethod((IJavaProject)project, (String)"test.B", (String)"bar()");
        CodeUtilsTest.assertSame((Object)aUnit.getTypes()[0].getMethods()[2], (Object)method);
        IMethodBinding[] methodBindings = CodeUtilsTest.getInvocationBindings(type, 0);
        IMethodBinding methodBinding = methodBindings[0];
        IMethod method2 = CodeUtils.findMethod((IJavaProject)project, (IMethodBinding)methodBinding);
        CodeUtilsTest.assertNotNull((Object)method2);
        CodeUtilsTest.assertEquals((Object)"A", (Object)method2.getDeclaringType().getElementName());
        methodBinding = methodBindings[1];
        method2 = CodeUtils.findMethod((IJavaProject)project, (IMethodBinding)methodBinding);
        CodeUtilsTest.assertNotNull((Object)method2);
        CodeUtilsTest.assertEquals((Object)"B", (Object)method2.getDeclaringType().getElementName());
    }

    @Test
    public void test_findMethod_withGenerics() throws Exception {
        IType type = this.createModelType("test", "Test.java", CodeUtilsTest.getSourceDQ("package test;", "import java.awt.Component;", "public class Test<T extends Component> {", "  void foo(T component) {", "  }", "}"));
        IMethod method = CodeUtils.findMethod((IType)type, (String)"foo(java.awt.Component)");
        CodeUtilsTest.assertNotNull((Object)method);
        CodeUtilsTest.assertTrue((boolean)method.exists());
        CodeUtilsTest.assertEquals((Object)"foo", (Object)method.getElementName());
    }

    @Test
    public void test_findMethod_noSuchType() throws Exception {
        CodeUtilsTest.assertNull((Object)CodeUtils.findMethod((IJavaProject)m_testProject.getJavaProject(), (String)"no.such.Type", (String)"foo()"));
    }

    @Test
    public void test_findMethods() throws Exception {
        ICompilationUnit aUnit = this.createModelCompilationUnit("test", "A.java", CodeUtilsTest.getSourceDQ("package test;", "class A {", "  void foo() {", "  }", "  void bar() {", "  }", "}"));
        IType aType = aUnit.getTypes()[0];
        IMethod[] methods = CodeUtils.findMethods((IType)aType, (String[])new String[]{"foo()", "bar()", "baz()"});
        CodeUtilsTest.assertEquals((Object)"foo", (Object)methods[0].getElementName());
        CodeUtilsTest.assertEquals((Object)"bar", (Object)methods[1].getElementName());
        CodeUtilsTest.assertNull((Object)methods[2]);
    }

    @Test
    public void test_findMethods_List() throws Exception {
        ICompilationUnit aUnit = this.createModelCompilationUnit("test", "A.java", CodeUtilsTest.getSourceDQ("package test;", "class A {", "  void foo() {", "  }", "  void bar() {", "  }", "}"));
        IType aType = aUnit.getTypes()[0];
        List methods = CodeUtils.findMethods((IType)aType, List.of("foo()", "bar()", "baz()"));
        Assertions.assertThat((List)methods).hasSize(3);
        CodeUtilsTest.assertEquals((Object)"foo", (Object)((IMethod)methods.get(0)).getElementName());
        CodeUtilsTest.assertEquals((Object)"bar", (Object)((IMethod)methods.get(1)).getElementName());
        CodeUtilsTest.assertSame(null, methods.get(2));
    }

    @Test
    public void test_findMethodWithGeneric() throws Exception {
        ICompilationUnit aUnit = this.createModelCompilationUnit("test", "A.java", CodeUtilsTest.getSourceDQ("package test;", "class A {", "  void foo(java.util.List<Integer> a) {", "  }", "}"));
        IType aType = aUnit.getTypes()[0];
        IMethod method = CodeUtils.findMethodSingleType((IType)aType, (String)"foo(java.util.List)");
        CodeUtilsTest.assertNotNull((Object)method);
        CodeUtilsTest.assertEquals((Object)"foo", (Object)method.getElementName());
    }

    @Test
    public void test_isSuccessorOf_1() throws Exception {
        IJavaProject javaProject = m_testProject.getJavaProject();
        IType typeList = javaProject.findType("java.util.List");
        IType typeMap = javaProject.findType("java.util.Map");
        IType typeAbstractList = javaProject.findType("java.util.AbstractList");
        CodeUtilsTest.assertTrue((boolean)CodeUtils.isSuccessorOf((IType)javaProject.findType("java.util.ArrayList"), (IType)typeList));
        CodeUtilsTest.assertTrue((boolean)CodeUtils.isSuccessorOf((IType)javaProject.findType("java.util.LinkedList"), (IType)typeList));
        CodeUtilsTest.assertTrue((boolean)CodeUtils.isSuccessorOf((IType)javaProject.findType("java.util.ArrayList"), (IType)typeAbstractList));
        CodeUtilsTest.assertTrue((boolean)CodeUtils.isSuccessorOf((IType)javaProject.findType("java.util.LinkedList"), (IType)typeAbstractList));
        CodeUtilsTest.assertFalse((boolean)CodeUtils.isSuccessorOf((IType)javaProject.findType("java.util.ArrayList"), (IType)typeMap));
        CodeUtilsTest.assertFalse((boolean)CodeUtils.isSuccessorOf((IType)javaProject.findType("java.util.LinkedList"), (IType)typeMap));
    }

    @Test
    public void test_isSuccessorOf_2() throws Exception {
        IJavaProject javaProject = m_testProject.getJavaProject();
        String typeList = "java.util.List";
        String typeMap = "java.util.Map";
        String typeAbstractList = "java.util.AbstractList";
        CodeUtilsTest.assertFalse((boolean)CodeUtils.isSuccessorOf((IType)javaProject.findType("java.util.ArrayList"), (String)"no.such.Type"));
        CodeUtilsTest.assertTrue((boolean)CodeUtils.isSuccessorOf((IType)javaProject.findType("java.util.ArrayList"), (String)typeList));
        CodeUtilsTest.assertTrue((boolean)CodeUtils.isSuccessorOf((IType)javaProject.findType("java.util.LinkedList"), (String)typeList));
        CodeUtilsTest.assertTrue((boolean)CodeUtils.isSuccessorOf((IType)javaProject.findType("java.util.ArrayList"), (String)typeAbstractList));
        CodeUtilsTest.assertTrue((boolean)CodeUtils.isSuccessorOf((IType)javaProject.findType("java.util.LinkedList"), (String)typeAbstractList));
        CodeUtilsTest.assertFalse((boolean)CodeUtils.isSuccessorOf((IType)javaProject.findType("java.util.ArrayList"), (String)typeMap));
        CodeUtilsTest.assertFalse((boolean)CodeUtils.isSuccessorOf((IType)javaProject.findType("java.util.LinkedList"), (String)typeMap));
    }

    @Test
    public void test_findSuperMethod() throws Exception {
        ICompilationUnit aUnit = this.createModelCompilationUnit("test", "A.java", CodeUtilsTest.getSourceDQ("package test;", "class A {", "  void foo() {", "  }", "  void baz() {", "  }", "}"));
        this.createModelCompilationUnit("test", "B.java", CodeUtilsTest.getSourceDQ("package test;", "class B extends A {", "}"));
        ICompilationUnit cUnit = this.createModelCompilationUnit("test", "C.java", CodeUtilsTest.getSourceDQ("package test;", "class C extends B {", "  void foo() {", "  }", "  void bar() {", "  }", "}"));
        IMethod[] aMethods = aUnit.getTypes()[0].getMethods();
        IMethod[] cMethods = cUnit.getTypes()[0].getMethods();
        CodeUtilsTest.assertSame((Object)aMethods[0], (Object)CodeUtils.findSuperMethod((IMethod)cMethods[0]));
        CodeUtilsTest.assertNull((Object)CodeUtils.findSuperMethod((IMethod)cMethods[1]));
        CodeUtilsTest.assertNull((Object)CodeUtils.findSuperMethod((IMethod)aMethods[1]));
    }

    @Test
    public void test_findField_1() throws Exception {
        IJavaProject javaProject = m_testProject.getJavaProject();
        CodeUtilsTest.setFileContentSrc("test/PrefConstants.java", CodeUtilsTest.getSourceDQ("package test;", "public interface PrefConstants {", "  int field = 0;", "}"));
        CodeUtilsTest.assertNull((Object)CodeUtils.findField((IJavaProject)javaProject, (String)"no.such.Type", (String)"noMatter"));
        CodeUtilsTest.assertNull((Object)CodeUtils.findField((IJavaProject)javaProject, (String)"test.PrefConstants", (String)"noSuchField"));
        IField field = CodeUtils.findField((IJavaProject)javaProject, (String)"test.PrefConstants", (String)"field");
        CodeUtilsTest.assertNotNull((Object)field);
        CodeUtilsTest.assertEquals((Object)"field", (Object)field.getElementName());
    }

    @Test
    public void test_findField_2() throws Exception {
        IJavaProject javaProject = m_testProject.getJavaProject();
        this.createModelType("test", "A.java", CodeUtilsTest.getSourceDQ("package test;", "public class A {", "  int field;", "}"));
        this.createModelType("test", "B.java", CodeUtilsTest.getSourceDQ("package test;", "public class B extends A {", "  int otherField;", "}"));
        CodeUtilsTest.assertNull((Object)CodeUtils.findField((IJavaProject)javaProject, (String)"test.B", (String)"noSuchField"));
        IField field = CodeUtils.findField((IJavaProject)javaProject, (String)"test.B", (String)"field");
        CodeUtilsTest.assertNotNull((Object)field);
        CodeUtilsTest.assertEquals((Object)"field", (Object)field.getElementName());
        CodeUtilsTest.assertEquals((Object)"test.A", (Object)field.getDeclaringType().getFullyQualifiedName());
        field = CodeUtils.findField((IJavaProject)javaProject, (String)"test.B", (String)"otherField");
        CodeUtilsTest.assertNotNull((Object)field);
        CodeUtilsTest.assertEquals((Object)"otherField", (Object)field.getElementName());
        CodeUtilsTest.assertEquals((Object)"test.B", (Object)field.getDeclaringType().getFullyQualifiedName());
    }

    @Test
    public void test_findField_3() throws Exception {
        IJavaProject javaProject = m_testProject.getJavaProject();
        this.createModelType("test", "IA.java", CodeUtilsTest.getSourceDQ("package test;", "public interface IA {", "  int fieldA = 0;", "}"));
        this.createModelType("test", "IB.java", CodeUtilsTest.getSourceDQ("package test;", "public interface IB extends IA {", "  int fieldB = 0;", "}"));
        this.createModelType("test", "C.java", CodeUtilsTest.getSourceDQ("package test;", "public class C implements IB {", "}"));
        CodeUtilsTest.assertNull((Object)CodeUtils.findField((IJavaProject)javaProject, (String)"test.C", (String)"noSuchField"));
        IField field = CodeUtils.findField((IJavaProject)javaProject, (String)"test.C", (String)"fieldA");
        CodeUtilsTest.assertNotNull((Object)field);
        CodeUtilsTest.assertEquals((Object)"fieldA", (Object)field.getElementName());
        CodeUtilsTest.assertEquals((Object)"test.IA", (Object)field.getDeclaringType().getFullyQualifiedName());
        field = CodeUtils.findField((IJavaProject)javaProject, (String)"test.C", (String)"fieldB");
        CodeUtilsTest.assertNotNull((Object)field);
        CodeUtilsTest.assertEquals((Object)"fieldB", (Object)field.getElementName());
        CodeUtilsTest.assertEquals((Object)"test.IB", (Object)field.getDeclaringType().getFullyQualifiedName());
    }

    static IMethodBinding[] getInvocationBindings(TypeDeclaration typeDeclaration, int index) {
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[index];
        List statements = DomGenerics.statements((Block)methodDeclaration.getBody());
        IMethodBinding[] methodBindings = new IMethodBinding[statements.size()];
        int i = 0;
        while (i < statements.size()) {
            ExpressionStatement statement = (ExpressionStatement)statements.get(i);
            MethodInvocation invocation = (MethodInvocation)statement.getExpression();
            methodBindings[i] = AstNodeUtils.getMethodBinding((MethodInvocation)invocation);
            ++i;
        }
        return methodBindings;
    }
}

