/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.base64;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.internal.core.utils.base64.Base64Utils;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.Test;

public class Base64UtilsTest
extends DesignerTestCase {
    private static final String UNENCODED_STRING = "some string to encode";
    private static final String ENCODED_STRING = "c29tZSBzdHJpbmcgdG8gZW5jb2Rl";
    private static final byte[] UNENCODED_BYTES;
    private static final String ENCODED_BYTES = "EFA0qtwAAM8r8Q==";

    static {
        byte[] byArray = new byte[10];
        byArray[0] = 16;
        byArray[1] = 80;
        byArray[2] = 52;
        byArray[3] = -86;
        byArray[4] = -36;
        byArray[7] = -49;
        byArray[8] = 43;
        byArray[9] = -15;
        UNENCODED_BYTES = byArray;
    }

    @Test
    public void test_encodeString() throws Exception {
        String encodedString = Base64Utils.encode((String)UNENCODED_STRING);
        Base64UtilsTest.assertEquals((Object)ENCODED_STRING, (Object)encodedString);
        Base64UtilsTest.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)encodedString));
    }

    @Test
    public void test_encodeBytes() throws Exception {
        String encodedString = Base64Utils.encode((byte[])UNENCODED_BYTES);
        Base64UtilsTest.assertEquals((Object)ENCODED_BYTES, (Object)encodedString);
        Base64UtilsTest.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)encodedString));
    }

    @Test
    public void test_decodeString() throws Exception {
        String decodedString = Base64Utils.decode((String)ENCODED_STRING);
        Base64UtilsTest.assertEquals((Object)UNENCODED_STRING, (Object)decodedString);
    }

    @Test
    public void test_decodeBytes() throws Exception {
        byte[] decodedBytes = Base64Utils.decodeToBytes((String)ENCODED_BYTES);
        Base64UtilsTest.assertTrue((boolean)Arrays.equals(UNENCODED_BYTES, decodedBytes));
    }
}

