/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.ast;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.internal.core.utils.ast.AstVisitorEx;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.junit.Before;
import org.junit.Test;

public class AstVisitorExTest
extends AbstractJavaTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            AstVisitorExTest.do_projectCreate();
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_preVisit_ASTNode() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstVisitorExTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "}"));
        compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

            public void preVisitEx(ASTNode node) throws Exception {
            }
        });
        final Exception expected = new Exception("pre");
        try {
            compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

                public void preVisitEx(ASTNode node) throws Exception {
                    throw expected;
                }
            });
            AstVisitorExTest.fail();
        }
        catch (Throwable e) {
            AstVisitorExTest.assertSame((Object)expected, (Object)e);
        }
    }

    @Test
    public void test_postVisit_ASTNode() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstVisitorExTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "}"));
        compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

            public void postVisitEx(ASTNode node) throws Exception {
            }
        });
        final Exception expected = new Exception("post");
        try {
            compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

                public void postVisitEx(ASTNode node) throws Exception {
                    throw expected;
                }
            });
            AstVisitorExTest.fail();
        }
        catch (Throwable e) {
            AstVisitorExTest.assertSame((Object)expected, (Object)e);
        }
    }

    @Test
    public void test_visit_QualifiedName() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstVisitorExTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "  java.lang.Object o = null;", "}"));
        compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

            public boolean visitEx(QualifiedName node) throws Exception {
                return true;
            }
        });
        final Exception expected = new Exception("visit");
        try {
            compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

                public boolean visitEx(QualifiedName node) throws Exception {
                    throw expected;
                }
            });
            AstVisitorExTest.fail();
        }
        catch (Throwable e) {
            AstVisitorExTest.assertSame((Object)expected, (Object)e);
        }
    }

    @Test
    public void test_endVisit_QualifiedName() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstVisitorExTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "  java.lang.Object o = null;", "}"));
        final Exception expected = new Exception("endVisit");
        compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

            public void endVisitEx(QualifiedName node) throws Exception {
                super.endVisitEx(node);
            }
        });
        try {
            compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

                public void endVisitEx(QualifiedName node) throws Exception {
                    throw expected;
                }
            });
            AstVisitorExTest.fail();
        }
        catch (Throwable e) {
            AstVisitorExTest.assertSame((Object)expected, (Object)e);
        }
    }

    @Test
    public void test_endVisit_MethodInvocation() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstVisitorExTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "  private Test() {", "    System.out.println();", "  }", "}"));
        compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

            public void endVisitEx(MethodInvocation node) throws Exception {
                super.endVisitEx(node);
            }
        });
        final Exception expected = new Exception("endVisit");
        try {
            compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

                public void endVisitEx(MethodInvocation node) throws Exception {
                    throw expected;
                }
            });
            AstVisitorExTest.fail();
        }
        catch (Throwable e) {
            AstVisitorExTest.assertSame((Object)expected, (Object)e);
        }
    }

    @Test
    public void test_endVisit_SuperMethodInvocation() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstVisitorExTest.getSourceDQ("// filler filler filler filler filler", "package test;", "public class Test extends javax.swing.JPanel {", "  private Test() {", "    super.setEnabled(true);", "  }", "}"));
        compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

            public void endVisitEx(SuperMethodInvocation node) throws Exception {
                super.endVisitEx(node);
            }
        });
        final Exception expected = new Exception("endVisit");
        try {
            compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

                public void endVisitEx(SuperMethodInvocation node) throws Exception {
                    throw expected;
                }
            });
            AstVisitorExTest.fail();
        }
        catch (Throwable e) {
            AstVisitorExTest.assertSame((Object)expected, (Object)e);
        }
    }

    @Test
    public void test_endVisit_TypeDeclaration() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstVisitorExTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "}"));
        compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

            public void endVisitEx(TypeDeclaration node) throws Exception {
                super.endVisitEx(node);
            }
        });
        final Exception expected = new Exception("endVisit");
        try {
            compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

                public void endVisitEx(TypeDeclaration node) throws Exception {
                    throw expected;
                }
            });
            AstVisitorExTest.fail();
        }
        catch (Throwable e) {
            AstVisitorExTest.assertSame((Object)expected, (Object)e);
        }
    }

    @Test
    public void test_endVisit_TryStatement() throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit("test", "Test.java", AstVisitorExTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class Test {", "  public Test() {", "    try {} finally {}", "  }", "}"));
        compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

            public void endVisitEx(TryStatement node) throws Exception {
                super.endVisitEx(node);
            }
        });
        final Exception expected = new Exception("endVisit");
        try {
            compilationUnit.accept((ASTVisitor)new AstVisitorEx(){

                public void endVisitEx(TryStatement node) throws Exception {
                    throw expected;
                }
            });
            AstVisitorExTest.fail();
        }
        catch (Throwable e) {
            AstVisitorExTest.assertSame((Object)expected, (Object)e);
        }
    }
}

