/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wb.internal.core.utils.GenericTypeError;
import org.eclipse.wb.internal.core.utils.GenericTypeResolver;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.Test;

public class GenericsUtilsTest
extends DesignerTestCase {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_first() throws Exception {
        String firstObject = "123";
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(firstObject);
        objects.add(555);
        StructuredSelection selection = new StructuredSelection(objects);
        GenericsUtilsTest.assertSame((Object)firstObject, (Object)GenericsUtils.first((ISelection)selection));
        GenericsUtilsTest.assertSame((Object)firstObject, (Object)GenericsUtils.first((ISelection)selection));
    }

    @Test
    public void test_iterable() throws Exception {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add("123");
        objects.add(555);
        StructuredSelection selection = new StructuredSelection(objects);
        Iterable iterable = GenericsUtils.iterable((ISelection)selection);
        Iterator iterator = iterable.iterator();
        GenericsUtilsTest.assertTrue((boolean)iterator.hasNext());
        GenericsUtilsTest.assertSame(objects.get(0), iterator.next());
        GenericsUtilsTest.assertTrue((boolean)iterator.hasNext());
        GenericsUtilsTest.assertSame(objects.get(1), iterator.next());
        GenericsUtilsTest.assertFalse((boolean)iterator.hasNext());
        iterator = iterable.iterator();
        try {
            iterator.remove();
            GenericsUtilsTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void test_iterableSelection() throws Exception {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add("123");
        objects.add(555);
        StructuredSelection selection = new StructuredSelection(objects);
        ISelectionProvider selectionProvider = new ISelectionProvider((ISelection)selection){
            private final /* synthetic */ ISelection val$selection;
            {
                this.val$selection = iSelection;
            }

            public ISelection getSelection() {
                return this.val$selection;
            }

            public void setSelection(ISelection _selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }
        };
        Iterable iterable = GenericsUtils.iterableSelection((ISelectionProvider)selectionProvider);
        Iterator iterator = iterable.iterator();
        GenericsUtilsTest.assertTrue((boolean)iterator.hasNext());
        GenericsUtilsTest.assertSame(objects.get(0), iterator.next());
        GenericsUtilsTest.assertTrue((boolean)iterator.hasNext());
        GenericsUtilsTest.assertSame(objects.get(1), iterator.next());
        GenericsUtilsTest.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void test_get() throws Exception {
        Object[] objects = new Object[]{"0", 1, 2.2};
        GenericsUtilsTest.assertEquals((Object)"0", (Object)GenericsUtils.get(String.class, (Object[])objects));
        GenericsUtilsTest.assertEquals((Object)1, (Object)GenericsUtils.get(Integer.class, (Object[])objects));
        GenericsUtilsTest.assertEquals((Object)2.2, (Object)GenericsUtils.get(Double.class, (Object[])objects));
        GenericsUtilsTest.assertEquals(null, (Object)GenericsUtils.get(Float.class, (Object[])objects));
    }

    @Test
    public void test_get_fromList() throws Exception {
        List<Double> objects = List.of("0", Integer.valueOf(1), Double.valueOf(2.2));
        GenericsUtilsTest.assertEquals((Object)"0", (Object)GenericsUtils.get(String.class, objects));
        GenericsUtilsTest.assertEquals((Object)1, (Object)GenericsUtils.get(Integer.class, objects));
        GenericsUtilsTest.assertEquals((Object)2.2, (Object)GenericsUtils.get(Double.class, objects));
        GenericsUtilsTest.assertEquals(null, (Object)GenericsUtils.get(Float.class, objects));
    }

    @Test
    public void test_select() throws Exception {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add("111");
        objects.add("222");
        objects.add(333);
        objects.add(444);
        List stringList = GenericsUtils.select(objects, String.class);
        GenericsUtilsTest.assertEquals((long)2L, (long)stringList.size());
        GenericsUtilsTest.assertEquals((Object)"111", stringList.get(0));
        GenericsUtilsTest.assertEquals((Object)"222", stringList.get(1));
        List integerList = GenericsUtils.select(objects, Integer.class);
        GenericsUtilsTest.assertEquals((long)2L, (long)integerList.size());
        GenericsUtilsTest.assertEquals((Object)333, integerList.get(0));
        GenericsUtilsTest.assertEquals((Object)444, integerList.get(1));
    }

    @Test
    public void test_cast() throws Exception {
        ArrayList<String> objects = new ArrayList<String>();
        objects.add("111");
        objects.add("222");
        List stringList = GenericsUtils.cast(objects);
        Assertions.assertThat((List)stringList).containsExactly((Object[])new String[]{"111", "222"});
    }

    @Test
    public void test_asList_1() throws Exception {
        List list = GenericsUtils.asList((Object[])new String[]{"111", "222"}, (Object)"333");
        GenericsUtilsTest.assertEquals((long)3L, (long)list.size());
        GenericsUtilsTest.assertSame((Object)"111", list.get(0));
        GenericsUtilsTest.assertSame((Object)"222", list.get(1));
        GenericsUtilsTest.assertSame((Object)"333", list.get(2));
    }

    @Test
    public void test_asList_2() throws Exception {
        List list = GenericsUtils.asList(null, (Object)"111");
        GenericsUtilsTest.assertEquals((long)1L, (long)list.size());
        GenericsUtilsTest.assertSame((Object)"111", list.get(0));
    }

    @Test
    public void test_singletonList_1() throws Exception {
        Assertions.assertThat((List)GenericsUtils.singletonList(null)).isEmpty();
    }

    @Test
    public void test_singletonList_2() throws Exception {
        String element = "theElement";
        Assertions.assertThat((List)GenericsUtils.singletonList((Object)element)).containsExactly((Object[])new String[]{element});
    }

    @Test
    public void test_getPrevOrNull_index() throws Exception {
        List<String> elements = List.of("000", "111", "222");
        GenericsUtilsTest.assertSame(null, (Object)GenericsUtils.getPrevOrNull(elements, (int)0));
        GenericsUtilsTest.assertSame((Object)"000", (Object)GenericsUtils.getPrevOrNull(elements, (int)1));
        GenericsUtilsTest.assertSame((Object)"111", (Object)GenericsUtils.getPrevOrNull(elements, (int)2));
    }

    @Test
    public void test_getPrevOrNull_element() throws Exception {
        List<String> elements = List.of("000", "111", "222");
        GenericsUtilsTest.assertSame((Object)"000", (Object)GenericsUtils.getPrevOrNull(elements, (Object)"111"));
        GenericsUtilsTest.assertSame((Object)"111", (Object)GenericsUtils.getPrevOrNull(elements, (Object)"222"));
        GenericsUtilsTest.assertNull((Object)GenericsUtils.getPrevOrNull(elements, (Object)"000"));
        GenericsUtilsTest.assertNull((Object)GenericsUtils.getPrevOrNull(elements, (Object)"no such element"));
    }

    @Test
    public void test_getPrevOrLast_element() throws Exception {
        List<String> elements = List.of("000", "111", "222");
        GenericsUtilsTest.assertNull((Object)GenericsUtils.getPrevOrLast(Collections.emptyList(), (Object)"no matter"));
        GenericsUtilsTest.assertSame((Object)"111", (Object)GenericsUtils.getPrevOrLast(elements, (Object)"222"));
        GenericsUtilsTest.assertSame((Object)"000", (Object)GenericsUtils.getPrevOrLast(elements, (Object)"111"));
        GenericsUtilsTest.assertSame((Object)"222", (Object)GenericsUtils.getPrevOrLast(elements, (Object)"000"));
        GenericsUtilsTest.assertNull((Object)GenericsUtils.getPrevOrNull(elements, (Object)"no such element"));
    }

    @Test
    public void test_getNextOrNull_index() throws Exception {
        List<String> elements = List.of("000", "111", "222");
        GenericsUtilsTest.assertSame((Object)"111", (Object)GenericsUtils.getNextOrNull(elements, (int)0));
        GenericsUtilsTest.assertSame((Object)"222", (Object)GenericsUtils.getNextOrNull(elements, (int)1));
        GenericsUtilsTest.assertNull((Object)GenericsUtils.getNextOrNull(elements, (int)2));
    }

    @Test
    public void test_getNextOrNull_element() throws Exception {
        List<String> elements = List.of("000", "111", "222");
        GenericsUtilsTest.assertSame((Object)"111", (Object)GenericsUtils.getNextOrNull(elements, (Object)"000"));
        GenericsUtilsTest.assertSame((Object)"222", (Object)GenericsUtils.getNextOrNull(elements, (Object)"111"));
        GenericsUtilsTest.assertNull((Object)GenericsUtils.getNextOrNull(elements, (Object)"222"));
        GenericsUtilsTest.assertNull((Object)GenericsUtils.getNextOrNull(elements, (Object)"no such element"));
    }

    @Test
    public void test_getNextOrFirst_element() throws Exception {
        List<String> elements = List.of("000", "111", "222");
        GenericsUtilsTest.assertNull((Object)GenericsUtils.getNextOrFirst(Collections.emptyList(), (Object)"no matter"));
        GenericsUtilsTest.assertSame((Object)"111", (Object)GenericsUtils.getNextOrFirst(elements, (Object)"000"));
        GenericsUtilsTest.assertSame((Object)"222", (Object)GenericsUtils.getNextOrFirst(elements, (Object)"111"));
        GenericsUtilsTest.assertSame((Object)"000", (Object)GenericsUtils.getNextOrFirst(elements, (Object)"222"));
        GenericsUtilsTest.assertNull((Object)GenericsUtils.getNextOrNull(elements, (Object)"no such element"));
    }

    @Test
    public void test_getFirstOrNull() throws Exception {
        GenericsUtilsTest.assertNull((Object)GenericsUtils.getFirstOrNull(Collections.emptyList()));
        GenericsUtilsTest.assertSame((Object)"000", (Object)GenericsUtils.getFirstOrNull(List.of("000", "111", "222")));
    }

    @Test
    public void test_getLastOrNull() throws Exception {
        GenericsUtilsTest.assertNull((Object)GenericsUtils.getLastOrNull(Collections.emptyList()));
        GenericsUtilsTest.assertSame((Object)"222", (Object)GenericsUtils.getLastOrNull(List.of("000", "111", "222")));
    }

    @Test
    public void test_getLast() throws Exception {
        try {
            GenericsUtilsTest.assertNull((Object)GenericsUtils.getLast(Collections.emptyList()));
            GenericsUtilsTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        GenericsUtilsTest.assertSame((Object)"222", (Object)GenericsUtils.getLast(List.of("000", "111", "222")));
    }

    @Test
    public void test_areAdjacent() throws Exception {
        GenericsUtilsTest.assertTrue((boolean)GenericsUtils.areAdjacent(Collections.emptyList(), Collections.emptyList()));
        GenericsUtilsTest.assertTrue((boolean)GenericsUtils.areAdjacent(List.of("a"), List.of("a")));
        GenericsUtilsTest.assertTrue((boolean)GenericsUtils.areAdjacent(List.of("a", "b", "c"), List.of("a")));
        GenericsUtilsTest.assertTrue((boolean)GenericsUtils.areAdjacent(List.of("a", "b", "c"), List.of("a", "b")));
        GenericsUtilsTest.assertTrue((boolean)GenericsUtils.areAdjacent(List.of("a", "b", "c"), List.of("b", "c")));
        GenericsUtilsTest.assertFalse((boolean)GenericsUtils.areAdjacent(List.of("a", "b", "c"), List.of("a", "c")));
    }

    @Test
    public void test_getEnumStrings() throws Exception {
        GenericsUtilsTest.assertArrayEquals((Object[])GenericsUtils.getEnumStrings((Enum[])new MyEnum[]{MyEnum.A, MyEnum.B}), (Object[])new String[]{"A", "B"});
    }

    @Test
    public void test_getEnumValue() throws Exception {
        GenericsUtilsTest.assertSame((Object)((Object)MyEnum.B), (Object)GenericsUtils.getEnumValue((String)"B", (Enum[])new MyEnum[]{MyEnum.A, MyEnum.B, MyEnum.C}));
        GenericsUtilsTest.assertSame(null, (Object)GenericsUtils.getEnumValue((String)"B", (Enum[])new MyEnum[]{MyEnum.A}));
    }

    @Test
    public void test_getEnumValues_byString() throws Exception {
        MyEnum[] expectedValues = new MyEnum[]{MyEnum.A, MyEnum.B};
        MyEnum[] actualValues = (MyEnum[])GenericsUtils.getEnumValues(MyEnum.class, (String[])new String[]{"A", "B"});
        GenericsUtilsTest.assertArrayEquals((Object[])actualValues, (Object[])expectedValues);
        try {
            GenericsUtils.getEnumValues(MyEnum.class, (String[])new String[]{"noSuchElement"});
            GenericsUtilsTest.fail();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void test_getEnumValues_filter() throws Exception {
        MyEnum[] expectedValues = new MyEnum[]{MyEnum.B, MyEnum.C};
        MyEnum[] actualValues = (MyEnum[])GenericsUtils.getEnumValues(MyEnum.class, t -> t == MyEnum.B || t == MyEnum.C);
        GenericsUtilsTest.assertArrayEquals((Object[])actualValues, (Object[])expectedValues);
    }

    @Test
    public void test_getTypeName_badTypeToResolve() throws Exception {
        try {
            GenericsUtils.getTypeName((GenericTypeResolver)GenericTypeResolver.EMPTY, null);
            GenericsUtilsTest.fail();
        }
        catch (GenericTypeError genericTypeError) {
            // empty catch block
        }
    }

    @Test
    public void test_getTypeName_noSuchTypeVariable() throws Exception {
        try {
            class Foo<A> {
                Foo() {
                }
            }
            TypeVariable typeVariable = Foo.class.getTypeParameters()[0];
            GenericsUtils.getTypeName((GenericTypeResolver)GenericTypeResolver.EMPTY, typeVariable);
            GenericsUtilsTest.fail();
        }
        catch (GenericTypeError genericTypeError) {
            // empty catch block
        }
    }

    @Test
    public void test_getTypeName_fixed_hasVariable() throws Exception {
        GenericTypeResolver resolver = GenericTypeResolver.fixed((String)"A", String.class);
        class Foo<A> {
            Foo() {
            }
        }
        TypeVariable typeVariable = Foo.class.getTypeParameters()[0];
        String actualParameterType = GenericsUtils.getTypeName((GenericTypeResolver)resolver, typeVariable);
        GenericsUtilsTest.assertEquals((Object)"java.lang.String", (Object)actualParameterType);
    }

    @Test
    public void test_getTypeName_fixed_noSuchVariable() throws Exception {
        GenericTypeResolver resolver = GenericTypeResolver.fixed((String)"A", String.class);
        class Foo<B> {
            Foo() {
            }
        }
        TypeVariable typeVariable = Foo.class.getTypeParameters()[0];
        try {
            GenericsUtils.getTypeName((GenericTypeResolver)resolver, typeVariable);
            GenericsUtilsTest.fail();
        }
        catch (GenericTypeError genericTypeError) {
            // empty catch block
        }
    }

    @Test
    public void test_getTypeName_Class() throws Exception {
        String actualParameterType = GenericsUtils.getTypeName((GenericTypeResolver)GenericTypeResolver.EMPTY, String.class);
        GenericsUtilsTest.assertEquals((Object)"java.lang.String", (Object)actualParameterType);
    }

    @Test
    public void test_getTypeName_innerClass() throws Exception {
        String actualParameterType = GenericsUtils.getTypeName((GenericTypeResolver)GenericTypeResolver.EMPTY, Map.Entry.class);
        GenericsUtilsTest.assertEquals((Object)"java.util.Map.Entry", (Object)actualParameterType);
    }

    @Test
    public void test_getTypeName_TypeVariable() throws Exception {
        class Listener<E> {
            Listener() {
            }

            void handle(E event) {
            }
        }
        Method method_handle = ReflectionUtils.getMethod(Listener.class, (String)"handle", (Class[])new Class[]{Object.class});
        GenericsUtilsTest.assertNotNull((Object)method_handle);
        Type parameterTypeToResolve = method_handle.getGenericParameterTypes()[0];
        GenericsUtilsTest.assertEquals((Object)"E", (Object)parameterTypeToResolve.toString());
        class Widget {
            Widget() {
            }

            public void addListener(Listener<String> listener) {
            }
        }
        Method method_addListener = ReflectionUtils.getMethod(Widget.class, (String)"addListener", (Class[])new Class[]{Listener.class});
        GenericTypeResolver resolver = GenericTypeResolver.argumentOfMethod((GenericTypeResolver)GenericTypeResolver.EMPTY, (Method)method_addListener, (int)0);
        String actualParameterType = GenericsUtils.getTypeName((GenericTypeResolver)resolver, (Type)parameterTypeToResolve);
        GenericsUtilsTest.assertEquals((Object)"java.lang.String", (Object)actualParameterType);
    }

    @Test
    public void test_getTypeName_TypeVariable_deepResolving() throws Exception {
        class Listener<L1, L2> {
            Listener() {
            }

            void handle(Event<L1, L2> event) {
            }
        }
        class Event<E1, E2> {
            E1 value1;
            E2 value2;

            Event() {
            }
        }
        Method method_handle = ReflectionUtils.getMethod(Listener.class, (String)"handle", (Class[])new Class[]{Event.class});
        GenericsUtilsTest.assertNotNull((Object)method_handle);
        Type parameterTypeToResolve = method_handle.getGenericParameterTypes()[0];
        GenericsUtilsTest.assertEquals((Object)(Event.class.getName() + "<L1, L2>"), (Object)parameterTypeToResolve.toString());
        class Widget {
            Widget() {
            }

            public void addListener(Listener<String, Integer> listener) {
            }
        }
        Method method_addListener = ReflectionUtils.getMethod(Widget.class, (String)"addListener", (Class[])new Class[]{Listener.class});
        GenericTypeResolver resolver = GenericTypeResolver.argumentOfMethod((GenericTypeResolver)GenericTypeResolver.EMPTY, (Method)method_addListener, (int)0);
        String actualParameterType = GenericsUtils.getTypeName((GenericTypeResolver)resolver, (Type)parameterTypeToResolve);
        GenericsUtilsTest.assertEquals((Object)(Event.class.getName() + "<java.lang.String, java.lang.Integer>"), (Object)actualParameterType);
    }

    @Test
    public void test_getTypeName_TypeVariable_actualInSuperclass() throws Exception {
        class Listener<L> {
            Listener() {
            }

            void handle(Event<L> event) {
            }
        }
        class Event<T> {
            Event() {
            }
        }
        Method method_handle = ReflectionUtils.getMethod(Listener.class, (String)"handle", (Class[])new Class[]{Event.class});
        GenericsUtilsTest.assertNotNull((Object)method_handle);
        Type parameterTypeToResolve = method_handle.getGenericParameterTypes()[0];
        GenericsUtilsTest.assertEquals((Object)(Event.class.getName() + "<L>"), (Object)parameterTypeToResolve.toString());
        class ConcreteWidget2
        extends 1ConcreteWidget {
            ConcreteWidget2() {
                class ConcreteWidget
                extends GenericWidget<String> {
                    ConcreteWidget() {
                        class GenericWidget<V> {
                            GenericWidget() {
                            }

                            public void addListener(Listener<V> listener) {
                            }
                        }
                    }
                }
            }
        }
        Method method_addListener = ReflectionUtils.getMethod(ConcreteWidget2.class, (String)"addListener", (Class[])new Class[]{Listener.class});
        GenericTypeResolver superClassResolver = GenericTypeResolver.superClass((GenericTypeResolver)GenericTypeResolver.EMPTY, ConcreteWidget2.class, GenericWidget.class);
        GenericTypeResolver resolver = GenericTypeResolver.argumentOfMethod((GenericTypeResolver)superClassResolver, (Method)method_addListener, (int)0);
        String actualParameterType = GenericsUtils.getTypeName((GenericTypeResolver)resolver, (Type)parameterTypeToResolve);
        GenericsUtilsTest.assertEquals((Object)(Event.class.getName() + "<java.lang.String>"), (Object)actualParameterType);
    }

    @Test
    public void test_getTypeName_TypeVariable_askParent() throws Exception {
        class GenericWidget<D> {
            GenericWidget() {
            }

            public void addListener(Listener<D> listener) {
            }
        }
        class Listener<L> {
            Listener() {
            }

            void handle(3Event<L> event) {
            }
        }
        Method method_addListener = ReflectionUtils.getMethod(GenericWidget.class, (String)"addListener", (Class[])new Class[]{Listener.class});
        Type parameterTypeToResolve = method_addListener.getGenericParameterTypes()[0];
        class ActualWidget
        extends GenericWidget<String> {
            ActualWidget() {
            }
        }
        GenericTypeResolver superClassResolver = GenericTypeResolver.superClass((GenericTypeResolver)GenericTypeResolver.EMPTY, ActualWidget.class, GenericWidget.class);
        GenericTypeResolver resolver = GenericTypeResolver.argumentOfMethod((GenericTypeResolver)superClassResolver, (Method)method_addListener, (int)0);
        String actualParameterType = GenericsUtils.getTypeName((GenericTypeResolver)resolver, (Type)parameterTypeToResolve);
        GenericsUtilsTest.assertEquals((Object)(Listener.class.getName() + "<java.lang.String>"), (Object)actualParameterType);
    }

    @Test
    public void test_getTypeName_resolveFromSuperInterface() throws Exception {
        Method method = Inter.class.getDeclaredMethod("setValue", Object.class);
        Type typeToResolve = method.getGenericParameterTypes()[0];
        GenericsUtilsTest.assertEquals((Object)"E", (Object)typeToResolve.toString());
        abstract class Sub
        extends 1Super<String> {
            Sub() {
                abstract class Super<T>
                implements Inter<T> {
                    Super() {
                    }
                }
            }
        }
        GenericTypeResolver resolver = GenericTypeResolver.superClass((GenericTypeResolver)GenericTypeResolver.EMPTY, Sub.class, Inter.class);
        String actualParameterType = GenericsUtils.getTypeName((GenericTypeResolver)resolver, (Type)typeToResolve);
        GenericsUtilsTest.assertEquals((Object)"java.lang.String", (Object)actualParameterType);
    }

    @Test
    public void test_getTypeName_resolveFromSuperClass() throws Exception {
        class Super<T> {
            Super() {
            }

            void setValue(T value) {
            }
        }
        Method method = Super.class.getDeclaredMethod("setValue", Object.class);
        Type typeToResolve = method.getGenericParameterTypes()[0];
        GenericsUtilsTest.assertEquals((Object)"T", (Object)typeToResolve.toString());
        class Sub
        extends Super<String> {
            Sub() {
            }
        }
        GenericTypeResolver resolver = GenericTypeResolver.superClass((GenericTypeResolver)GenericTypeResolver.EMPTY, Sub.class, Super.class);
        String actualParameterType = GenericsUtils.getTypeName((GenericTypeResolver)resolver, (Type)typeToResolve);
        GenericsUtilsTest.assertEquals((Object)"java.lang.String", (Object)actualParameterType);
    }

    @Test
    public void test_getTypeName_TypeVariable_WildcardType() throws Exception {
        class Listener<E> {
            Listener() {
            }

            void handle(E event) {
            }
        }
        Method method_handle = ReflectionUtils.getMethod(Listener.class, (String)"handle", (Class[])new Class[]{Object.class});
        GenericsUtilsTest.assertNotNull((Object)method_handle);
        Type parameterTypeToResolve = method_handle.getGenericParameterTypes()[0];
        class Widget {
            Widget() {
            }

            public void addListener(Listener<? extends String> listener) {
            }
        }
        Method method_addListener = ReflectionUtils.getMethod(Widget.class, (String)"addListener", (Class[])new Class[]{Listener.class});
        GenericTypeResolver resolver = GenericTypeResolver.argumentOfMethod((GenericTypeResolver)GenericTypeResolver.EMPTY, (Method)method_addListener, (int)0);
        String actualParameterType = GenericsUtils.getTypeName((GenericTypeResolver)resolver, (Type)parameterTypeToResolve);
        GenericsUtilsTest.assertEquals((Object)"java.lang.String", (Object)actualParameterType);
    }

    @Test
    public void test_getTypeName_TypeVariable_withEnclosingTypeArguments() throws Exception {
        class Listener<E> {
            Listener() {
            }

            void handle(E event) {
            }
        }
        Method method_handle = ReflectionUtils.getMethod(Listener.class, (String)"handle", (Class[])new Class[]{Object.class});
        GenericsUtilsTest.assertNotNull((Object)method_handle);
        Type parameterTypeToResolve = method_handle.getGenericParameterTypes()[0];
        class Widget<D> {
            Widget() {
            }

            public void addListener(Listener<D> listener) {
            }
        }
        Method method_addListener = ReflectionUtils.getMethod(Widget.class, (String)"addListener", (Class[])new Class[]{Listener.class});
        GenericTypeResolver parentResolver = GenericTypeResolver.fixed((String)"D", String.class);
        GenericTypeResolver resolver = GenericTypeResolver.argumentOfMethod((GenericTypeResolver)parentResolver, (Method)method_addListener, (int)0);
        String actualParameterType = GenericsUtils.getTypeName((GenericTypeResolver)resolver, (Type)parameterTypeToResolve);
        GenericsUtilsTest.assertEquals((Object)"java.lang.String", (Object)actualParameterType);
        parentResolver = GenericTypeResolver.fixed((String)"D", Integer.class);
        resolver = GenericTypeResolver.argumentOfMethod((GenericTypeResolver)parentResolver, (Method)method_addListener, (int)0);
        actualParameterType = GenericsUtils.getTypeName((GenericTypeResolver)resolver, (Type)parameterTypeToResolve);
        GenericsUtilsTest.assertEquals((Object)"java.lang.Integer", (Object)actualParameterType);
    }

    @Test
    public void test_getTypeName_TypeVariable_withEnclosingTypeArguments2() throws Exception {
        class Listener<E> {
            Listener() {
            }

            void handle(E event) {
            }
        }
        Method method_handle = ReflectionUtils.getMethod(Listener.class, (String)"handle", (Class[])new Class[]{Object.class});
        GenericsUtilsTest.assertNotNull((Object)method_handle);
        Type parameterTypeToResolve = method_handle.getGenericParameterTypes()[0];
        class Widget<D> {
            Widget() {
            }

            public void addListener(Listener<D> listener) {
            }
        }
        Method method_addListener = ReflectionUtils.getMethod(Widget.class, (String)"addListener", (Class[])new Class[]{Listener.class});
        GenericTypeResolver parentResolver = GenericTypeResolver.fixed((String)"X2", String.class);
        class Widget_2<X2>
        extends 1Widget_1<X2> {
            Widget_2() {
                class Widget_1<X1>
                extends Widget<X1> {
                    Widget_1() {
                    }
                }
            }
        }
        GenericTypeResolver parentResolver2 = GenericTypeResolver.superClass((GenericTypeResolver)parentResolver, Widget_2.class, Widget.class);
        GenericTypeResolver resolver = GenericTypeResolver.argumentOfMethod((GenericTypeResolver)parentResolver2, (Method)method_addListener, (int)0);
        String actualParameterType = GenericsUtils.getTypeName((GenericTypeResolver)resolver, (Type)parameterTypeToResolve);
        GenericsUtilsTest.assertEquals((Object)"java.lang.String", (Object)actualParameterType);
    }

    static interface Inter<E> {
        public void setValue(E var1);
    }

    private static enum MyEnum {
        A,
        B,
        C;

    }
}

