/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls.ui;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.nls.ui.NlsDialog;
import org.eclipse.wb.internal.core.nls.ui.PropertiesComposite;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.nls.ui.AbstractDialogTest;
import org.eclipse.wb.tests.gef.UIRunnable;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class PropertiesCompositeTest
extends AbstractDialogTest {
    @Test
    public void test_noSources() throws Exception {
        String initialSource = this.getTestSource("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                TabItem[] tabItems = PropertiesCompositeTest.assertItems(tabFolder, new String[]{"Properties"});
                List sourcesList = UiContext.findFirstWidget((Widget)tabItems[0], List.class);
                PropertiesCompositeTest.assertEquals((long)0L, (long)sourcesList.getItemCount());
            }
        });
    }

    @Test
    public void test_possibleSources() throws Exception {
        PropertiesCompositeTest.setFileContentSrc("test/messages.properties", PropertiesCompositeTest.getSourceDQ("#Direct ResourceBundle", "frame.title=My JFrame"));
        PropertiesCompositeTest.setFileContentSrc("test/messages2.properties", PropertiesCompositeTest.getSourceDQ("#Direct ResourceBundle", "frame.name=My name"));
        String initialSource = this.getTestSource("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                TabItem[] tabItems = PropertiesCompositeTest.assertItems(tabFolder, new String[]{"test.messages", "test.messages2", "Properties"});
                List sourcesList = UiContext.findFirstWidget((Widget)tabItems[2], List.class);
                PropertiesCompositeTest.assertItems(sourcesList, new String[]{"test.messages (Direct ResourceBundle usage)", "test.messages2 (Direct ResourceBundle usage)"});
            }
        });
    }

    @Test
    public void test_existingSources() throws Exception {
        PropertiesCompositeTest.setFileContentSrc("test/messages.properties", PropertiesCompositeTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        PropertiesCompositeTest.setFileContentSrc("test/messages_it.properties", PropertiesCompositeTest.getSourceDQ("frame.title=My JFrame IT"));
        PropertiesCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                TabItem[] tabItems = PropertiesCompositeTest.assertItems(tabFolder, new String[]{"test.messages", "Properties"});
                List sourcesList = UiContext.findFirstWidget((Widget)tabItems[1], List.class);
                PropertiesCompositeTest.assertItems(sourcesList, new String[]{"test.messages (Direct ResourceBundle usage)"});
            }
        });
    }

    @Test
    public void test_properties() throws Exception {
        PropertiesCompositeTest.setFileContentSrc("test/messages.properties", PropertiesCompositeTest.getSourceDQ("#Direct ResourceBundle"));
        String initialSource = this.getTestSource("public class Test extends JFrame {", "  public Test() {", "    setTitle(\"My JFrame\");", "    {", "      JButton button = new JButton(\"New button\");", "      getContentPane().add(button, BorderLayout.NORTH);", "    }", "    {", "      JTextField textField = new JTextField();", "      getContentPane().add(textField, BorderLayout.SOUTH);", "    }", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                TabItem[] tabItems = PropertiesCompositeTest.assertItems(tabFolder, new String[]{"test.messages", "Properties"});
                PropertiesComposite propertiesComposite = (PropertiesComposite)tabItems[1].getControl();
                List sourcesList = UiContext.findFirstWidget((Widget)propertiesComposite, List.class);
                PropertiesCompositeTest.assertNotNull((Object)sourcesList);
                Tree propertiesTree = UiContext.findFirstWidget((Widget)propertiesComposite, Tree.class);
                PropertiesCompositeTest.assertNotNull((Object)propertiesTree);
                Button externalizeButton = context.getButtonByText("E&xternalize");
                PropertiesCompositeTest.assertNotNull((Object)externalizeButton);
                PropertiesCompositeTest.assertNotNull((Object)PropertiesCompositeTest.getItem(propertiesTree, new String[]{"(javax.swing.JFrame)", "title: My JFrame"}));
                PropertiesCompositeTest.assertNotNull((Object)PropertiesCompositeTest.getItem(propertiesTree, new String[]{"(javax.swing.JFrame)", "getContentPane()", "button", "text: New button"}));
                PropertiesCompositeTest.assertNull((Object)PropertiesCompositeTest.getItem(propertiesTree, new String[]{"(javax.swing.JFrame)", "getContentPane()", "textField"}));
                TreeItem buttonItem = PropertiesCompositeTest.getItem(propertiesTree, new String[]{"(javax.swing.JFrame)", "getContentPane()", "button"});
                TreeItem buttonTextItem = PropertiesCompositeTest.getItem(buttonItem, new String[]{"text: New button"}, 0);
                PropertiesCompositeTest.assertFalse((boolean)externalizeButton.isEnabled());
                PropertiesCompositeTest.assertTrue((boolean)buttonItem.getGrayed());
                PropertiesCompositeTest.assertFalse((boolean)buttonItem.getChecked());
                PropertiesCompositeTest.assertFalse((boolean)buttonTextItem.getChecked());
                PropertiesCompositeTest.setChecked(buttonItem, true);
                PropertiesCompositeTest.assertTrue((boolean)buttonItem.getChecked());
                PropertiesCompositeTest.assertTrue((boolean)buttonTextItem.getChecked());
                PropertiesCompositeTest.assertTrue((boolean)externalizeButton.isEnabled());
                PropertiesCompositeTest.assertTrue((boolean)externalizeButton.isEnabled());
                sourcesList.deselectAll();
                sourcesList.notifyListeners(13, null);
                PropertiesCompositeTest.assertFalse((boolean)externalizeButton.isEnabled());
                sourcesList.select(0);
                sourcesList.notifyListeners(13, null);
                PropertiesCompositeTest.assertTrue((boolean)externalizeButton.isEnabled());
                context.clickButton("&Enable all");
                PropertiesCompositeTest.assertTrue((boolean)buttonTextItem.getChecked());
                context.clickButton("D&isable all");
                PropertiesCompositeTest.assertFalse((boolean)buttonTextItem.getChecked());
                PropertiesCompositeTest.setChecked(buttonItem, true);
                context.clickButton("E&xternalize");
                PropertiesCompositeTest.assertNull((Object)PropertiesCompositeTest.getItem(propertiesTree, new String[]{"(javax.swing.JFrame)", "getContentPane()", "button", "text: New button"}));
                PropertiesCompositeTest.assertNull((Object)PropertiesCompositeTest.getItem(propertiesTree, new String[]{"(javax.swing.JFrame)", "getContentPane()", "button"}));
                PropertiesCompositeTest.assertNull((Object)PropertiesCompositeTest.getItem(propertiesTree, new String[]{"(javax.swing.JFrame)", "getContentPane()"}));
                IEditableSource editableSource = (IEditableSource)ReflectionUtils.invokeMethod((Object)propertiesComposite, (String)"getSelectedSource()", (Object[])new Object[0]);
                PropertiesCompositeTest.assertEquals((Object)"New button", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "Test.button.text"));
            }
        });
    }

    @Test
    public void test_open_NewSourceDialog() throws Exception {
        String initialSource = this.getTestSource("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                TabItem[] tabItems = PropertiesCompositeTest.assertItems(tabFolder, new String[]{"Properties"});
                List sourcesList = UiContext.findFirstWidget((Widget)tabItems[0], List.class);
                PropertiesCompositeTest.assertEquals((long)0L, (long)sourcesList.getItemCount());
                context.executeAndCheck(new UIRunnable(){

                    @Override
                    public void run(UiContext context2) throws Exception {
                        context2.clickButton("&New...");
                    }
                }, new UIRunnable(){

                    @Override
                    public void run(UiContext context2) throws Exception {
                        context2.useShell("New source");
                        context2.clickButton("OK");
                    }
                });
            }
        });
    }

    private static TreeItem getItem(Tree tree, String[] pathElements) {
        TreeItem rootItem;
        TreeItem[] treeItems = tree.getItems();
        PropertiesCompositeTest.assertTrue((treeItems.length <= 1 ? 1 : 0) != 0);
        if (treeItems.length == 1 && (rootItem = treeItems[0]).getText().equals(pathElements[0])) {
            return PropertiesCompositeTest.getItem(rootItem, pathElements, 1);
        }
        return null;
    }

    private static TreeItem getItem(TreeItem item, String[] pathElements, int pathIndex) {
        if (pathElements.length == pathIndex) {
            return item;
        }
        String pathElement = pathElements[pathIndex];
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            TreeItem child = children[i];
            if (child.getText().equals(pathElement)) {
                return PropertiesCompositeTest.getItem(child, pathElements, pathIndex + 1);
            }
            ++i;
        }
        return null;
    }

    private static void setChecked(TreeItem item, boolean checked) {
        item.setChecked(checked);
        Event event = new Event();
        event.item = item;
        event.detail = 32;
        Tree tree = item.getParent();
        tree.notifyListeners(13, event);
    }
}

