/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls.ui;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.nls.ui.NewSourceDialog;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UIRunnable;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class NewSourceDialogTest
extends SwingModelTest {
    @Test
    public void test_openDialog() throws Exception {
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        final NewSourceDialog newSourceDialog = new NewSourceDialog(null, (JavaInfo)frame);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                newSourceDialog.open();
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                NewSourceDialogTest.assertNotNull((Object)context.getButtonByText("Classic Eclipse messages class"));
                NewSourceDialogTest.assertNotNull((Object)context.getButtonByText("Modern Eclipse messages class"));
                NewSourceDialogTest.assertNotNull((Object)context.getButtonByText("Direct ResourceBundle usage"));
                NewSourceDialogTest.assertNotNull((Object)context.getButtonByText("ResourceBundle in field"));
                context.clickButton("Cancel");
            }
        });
    }

    @Test
    public void test_DirectSource() throws Exception {
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        final NewSourceDialog newSourceDialog = new NewSourceDialog(null, (JavaInfo)frame);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                newSourceDialog.open();
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                Button okButton = context.getButtonByText("OK");
                context.selectButton("Direct ResourceBundle usage");
                try {
                    StyledText styledText = context.findFirstWidget(StyledText.class);
                    NewSourceDialogTest.assertEquals((Object)"button.setText( ResourceBundle.getBundle(\"full.bundle.name\").getString(\"some.key\") );", (Object)styledText.getText());
                    Text sourceFolderText = (Text)context.getControlAfterLabel("Source folder:");
                    NewSourceDialogTest.assertEquals((Object)"TestProject/src", (Object)sourceFolderText.getText());
                    sourceFolderText.setText("no-such-folder");
                    sourceFolderText.notifyListeners(24, null);
                    NewSourceDialogTest.assertFalse((boolean)okButton.getEnabled());
                    sourceFolderText.setText("TestProject/src");
                    sourceFolderText.notifyListeners(24, null);
                    NewSourceDialogTest.assertTrue((boolean)okButton.getEnabled());
                    Text packageText = (Text)context.getControlAfterLabel("Package:");
                    NewSourceDialogTest.assertEquals((Object)"test", (Object)packageText.getText());
                    packageText.setText("no-such-package");
                    packageText.notifyListeners(24, null);
                    NewSourceDialogTest.assertFalse((boolean)okButton.getEnabled());
                    packageText.setText("test");
                    packageText.notifyListeners(24, null);
                    NewSourceDialogTest.assertTrue((boolean)okButton.getEnabled());
                    Text fileText = (Text)context.getControlAfterLabel("Property file name:");
                    NewSourceDialogTest.assertEquals((Object)"messages.properties", (Object)fileText.getText());
                    fileText.setText("bad-file-name");
                    fileText.notifyListeners(24, null);
                    NewSourceDialogTest.assertFalse((boolean)okButton.getEnabled());
                    fileText.setText("messages.properties");
                    fileText.notifyListeners(24, null);
                    NewSourceDialogTest.assertTrue((boolean)okButton.getEnabled());
                }
                finally {
                    context.clickButton("OK");
                }
            }
        });
    }
}

