/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.generic;

import org.eclipse.jface.action.IAction;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.Ignore;
import org.junit.Test;

public abstract class FlowContainerAbstractGefTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_canvas_CREATE_empty() throws Exception {
        this.prepareFlowPanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "    }", "  }", "}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        Object newButton = this.loadCreationTool("javax.swing.JButton", "empty");
        this.canvas.moveTo((Object)panel, 100, 100);
        this.canvas.assertEmptyFlowContainerFeedback(panel, true);
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.canvas.assertNoFeedbacks();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton button = new JButton();", "        panel.add(button);", "      }", "    }", "  }", "}");
        this.canvas.assertPrimarySelected(newButton);
    }

    @Test
    public void test_canvas_CREATE() throws Exception {
        this.prepareFlowPanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton existingButton = new JButton();", "        panel.add(existingButton);", "      }", "    }", "  }", "}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo existingButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        Object newButton = this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)existingButton, 0, 0);
        this.canvas.assertFeedbacks(this.canvas.getLinePredicate(existingButton, 1));
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.canvas.assertNoFeedbacks();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton button = new JButton('New button');", "        panel.add(button);", "      }", "      {", "        JButton existingButton = new JButton();", "        panel.add(existingButton);", "      }", "    }", "  }", "}");
        this.canvas.assertPrimarySelected(newButton);
    }

    @Test
    public void test_canvas_MOVE() throws Exception {
        this.prepareFlowPanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton buttonA = new JButton();", "        panel.add(buttonA);", "      }", "      {", "        JButton buttonB = new JButton();", "        panel.add(buttonB);", "      }", "    }", "  }", "}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        this.canvas.beginDrag(buttonB, 10, 10).dragTo(buttonA);
        this.canvas.assertFeedbacks(this.canvas.getLinePredicate(buttonA, 1));
        this.canvas.assertCommandNotNull();
        this.canvas.endDrag();
        this.canvas.assertNoFeedbacks();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton buttonB = new JButton();", "        panel.add(buttonB);", "      }", "      {", "        JButton buttonA = new JButton();", "        panel.add(buttonA);", "      }", "    }", "  }", "}");
    }

    @Ignore
    @Test
    public void test_canvas_PASTE() throws Exception {
        this.prepareFlowPanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton existingButton = new JButton();", "        panel.add(existingButton);", "      }", "    }", "    {", "      JButton rootButton = new JButton('A');", "      add(rootButton, BorderLayout.NORTH);", "    }", "  }", "}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo existingButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo rootButton = (ComponentInfo)mainPanel.getChildrenComponents().get(1);
        this.canvas.select(rootButton);
        IAction copyAction = this.getCopyAction();
        FlowContainerAbstractGefTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        FlowContainerAbstractGefTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        this.canvas.moveTo((Object)panel, 0, 0);
        this.canvas.moveTo((Object)existingButton, 0, 0);
        this.canvas.assertFeedbacks(this.canvas.getLinePredicate(existingButton, 1));
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.canvas.assertNoFeedbacks();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton button = new JButton('A');", "        panel.add(button);", "      }", "      {", "        JButton existingButton = new JButton();", "        panel.add(existingButton);", "      }", "    }", "    {", "      JButton rootButton = new JButton('A');", "      add(rootButton, BorderLayout.NORTH);", "    }", "  }", "}");
        ComponentInfo newButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.assertPrimarySelected(newButton);
    }

    @Test
    public void test_canvas_ADD() throws Exception {
        this.prepareFlowPanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton existingButton = new JButton();", "        panel.add(existingButton);", "      }", "    }", "    {", "      JButton rootButton = new JButton();", "      add(rootButton, BorderLayout.NORTH);", "    }", "  }", "}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo existingButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo rootButton = (ComponentInfo)mainPanel.getChildrenComponents().get(1);
        this.canvas.beginDrag(rootButton).dragTo(existingButton);
        this.canvas.assertFeedbacks(this.canvas.getLinePredicate(existingButton, 1));
        this.canvas.assertCommandNotNull();
        this.canvas.endDrag();
        this.canvas.assertNoFeedbacks();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton rootButton = new JButton();", "        panel.add(rootButton);", "      }", "      {", "        JButton existingButton = new JButton();", "        panel.add(existingButton);", "      }", "    }", "  }", "}");
        this.canvas.assertPrimarySelected(rootButton);
    }

    @Test
    public void test_tree_CREATE() throws Exception {
        this.prepareFlowPanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton existingButton = new JButton();", "        panel.add(existingButton);", "      }", "    }", "  }", "}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo existingButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        Object newButton = this.loadCreationTool("javax.swing.JButton");
        this.tree.moveBefore(existingButton);
        this.tree.assertFeedback_before(existingButton);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.tree.assertFeedback_empty();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton button = new JButton('New button');", "        panel.add(button);", "      }", "      {", "        JButton existingButton = new JButton();", "        panel.add(existingButton);", "      }", "    }", "  }", "}");
        this.tree.assertPrimarySelected(newButton);
    }

    @Test
    public void test_tree_MOVE() throws Exception {
        this.prepareFlowPanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton buttonA = new JButton();", "        panel.add(buttonA);", "      }", "      {", "        JButton buttonB = new JButton();", "        panel.add(buttonB);", "      }", "    }", "  }", "}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        this.canvas.select(buttonB);
        this.tree.startDrag(buttonB);
        this.tree.dragBefore(buttonA);
        this.tree.assertFeedback_before(buttonA);
        this.tree.assertCommandNotNull();
        this.tree.endDrag();
        this.tree.assertFeedback_empty();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton buttonB = new JButton();", "        panel.add(buttonB);", "      }", "      {", "        JButton buttonA = new JButton();", "        panel.add(buttonA);", "      }", "    }", "  }", "}");
    }

    @Ignore
    @Test
    public void test_tree_PASTE() throws Exception {
        this.prepareFlowPanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton existingButton = new JButton();", "        panel.add(existingButton);", "      }", "    }", "    {", "      JButton rootButton = new JButton('A');", "      add(rootButton, BorderLayout.NORTH);", "    }", "  }", "}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo existingButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo rootButton = (ComponentInfo)mainPanel.getChildrenComponents().get(1);
        this.canvas.select(rootButton);
        IAction copyAction = this.getCopyAction();
        FlowContainerAbstractGefTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        FlowContainerAbstractGefTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        this.tree.moveOn(panel);
        this.tree.moveBefore(existingButton);
        this.tree.assertFeedback_before(existingButton);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.tree.assertFeedback_empty();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton button = new JButton('A');", "        panel.add(button);", "      }", "      {", "        JButton existingButton = new JButton();", "        panel.add(existingButton);", "      }", "    }", "    {", "      JButton rootButton = new JButton('A');", "      add(rootButton, BorderLayout.NORTH);", "    }", "  }", "}");
        ComponentInfo newButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.tree.assertPrimarySelected(newButton);
    }

    @Test
    public void test_tree_ADD() throws Exception {
        this.prepareFlowPanel();
        ContainerInfo mainPanel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton existingButton = new JButton();", "        panel.add(existingButton);", "      }", "    }", "    {", "      JButton rootButton = new JButton();", "      add(rootButton, BorderLayout.NORTH);", "    }", "  }", "}");
        ContainerInfo panel = (ContainerInfo)mainPanel.getChildrenComponents().get(0);
        ComponentInfo existingButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo rootButton = (ComponentInfo)mainPanel.getChildrenComponents().get(1);
        this.tree.startDrag(rootButton);
        this.tree.dragBefore(existingButton);
        this.tree.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      FlowPanel panel = new FlowPanel();", "      add(panel);", "      {", "        JButton rootButton = new JButton();", "        panel.add(rootButton);", "      }", "      {", "        JButton existingButton = new JButton();", "        panel.add(existingButton);", "      }", "    }", "  }", "}");
        this.tree.assertPrimarySelected(rootButton);
    }

    protected abstract void prepareFlowPanel() throws Exception;
}

