/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.eval.primities;

import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.tests.designer.core.eval.AbstractEngineTest;
import org.junit.BeforeClass;
import org.junit.Test;

public class IntegerTest
extends AbstractEngineTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        IntegerTest.do_projectCreate();
    }

    @Test
    public void test_int_value() throws Exception {
        this.check_int("1", 1);
    }

    @Test
    public void test_int_positive_value() throws Exception {
        this.check_int("+2", 2);
    }

    @Test
    public void test_int_value_hex() throws Exception {
        this.check_int("0x0A", 10);
    }

    @Test
    public void test_int_value_oct() throws Exception {
        this.check_int("010", 8);
    }

    @Test
    public void test_int_negative_value() throws Exception {
        this.check_int("-1", -1);
    }

    @Test
    public void test_int_negate() throws Exception {
        this.check_int("~1", -2);
    }

    @Test
    public void test_int_shift_left() throws Exception {
        this.check_int("1 << 3", 8);
    }

    @Test
    public void test_int_shift_right() throws Exception {
        this.check_int("16 >> 2", 4);
    }

    @Test
    public void test_int_shift_right2() throws Exception {
        this.check_int("-16 >> 2", -4);
    }

    @Test
    public void test_int_shift_right3() throws Exception {
        this.check_int("-16 >>> 2", 0x3FFFFFFC);
    }

    @Test
    public void test_int_plus() throws Exception {
        this.check_int("1 + 2", 3);
    }

    @Test
    public void test_int_plus3() throws Exception {
        this.check_int("1 + 2 + 3", 6);
    }

    @Test
    public void test_int_plus4() throws Exception {
        this.check_int("1 + 2 + 3 + 4", 10);
    }

    @Test
    public void test_int_plus_char() throws Exception {
        this.check_int("1 + '0'", 49);
    }

    @Test
    public void test_int_plus_char2() throws Exception {
        this.check_int("'0' + '1'", 97);
    }

    @Test
    public void test_int_minus() throws Exception {
        this.check_int("5 - 1", 4);
    }

    @Test
    public void test_int_mul() throws Exception {
        this.check_int("2 * 3", 6);
    }

    @Test
    public void test_int_div() throws Exception {
        this.check_int("6 / 2", 3);
    }

    @Test
    public void test_int_div2() throws Exception {
        this.check_int("5 / 2", 2);
    }

    @Test
    public void test_int_mod() throws Exception {
        this.check_int("5 % 2", 1);
    }

    @Test
    public void test_int_mod2() throws Exception {
        this.check_int("-5 % 3", -2);
    }

    @Test
    public void test_int_or_exclusive() throws Exception {
        this.check_int("1 ^ 2", 3);
    }

    @Test
    public void test_int_or() throws Exception {
        this.check_int("1 | 2", 3);
    }

    @Test
    public void test_int_or3() throws Exception {
        this.check_int("1 | 2 | 4", 7);
    }

    @Test
    public void test_int_and() throws Exception {
        this.check_int("5 & 2", 0);
    }

    @Test
    public void test_int_and2() throws Exception {
        this.check_int("7 & 11", 3);
    }

    @Test
    public void test_int_and3() throws Exception {
        this.check_int("7 & 11 & 6", 2);
    }

    @Test
    public void test_short_cast() throws Exception {
        this.check_short("(short)1", (short)1);
    }

    @Test
    public void test_int_as_sum_of_shorts() throws Exception {
        this.check_int("(short)2 + (short)3", 5);
    }

    @Test
    public void test_PostfixExpression_increment() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {", "  public int root() {", "    int value = 4;", "    value++;", "    return value;", "  }", "}");
        Object actual = this.evaluateSingleMethod(typeDeclaration, "root()");
        IntegerTest.assertEquals((Object)5, (Object)actual);
    }

    @Test
    public void test_PostfixExpression_decrement() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {", "  public int root() {", "    int value = 4;", "    value--;", "    return value;", "  }", "}");
        Object actual = this.evaluateSingleMethod(typeDeclaration, "root()");
        IntegerTest.assertEquals((Object)3, (Object)actual);
    }

    private void check_short(String expression, short expected) throws Exception {
        Object actual = this.evaluateExpression(expression, "short");
        IntegerTest.assertEquals((Object)expected, (Object)actual);
    }

    private void check_int(String expression, int expected) throws Exception {
        Object actual = this.evaluateExpression(expression, "int");
        IntegerTest.assertEquals((Object)expected, (Object)actual);
    }
}

