/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.editor.actions.assistant;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.core.controls.CSpinner;
import org.eclipse.wb.core.controls.CSpinnerDeferredNotifier;
import org.eclipse.wb.core.editor.actions.assistant.ILayoutAssistantPage;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public abstract class AbstractAssistantPage
extends Composite
implements ILayoutAssistantPage {
    private static final Object NO_VALUE = new Object();
    private final List<ObjectInfo> m_selection;
    private final List<PropertyInfo> m_properties = new ArrayList<PropertyInfo>();
    private boolean m_saving;

    public AbstractAssistantPage(Composite parent, Object selection) {
        super(parent, 0);
        this.m_selection = selection instanceof List ? (List<Object>)selection : Collections.singletonList((ObjectInfo)selection);
    }

    @Override
    public final boolean isPageValid() {
        for (ObjectInfo object : this.m_selection) {
            ObjectInfo parent = object.getParent();
            if (parent.getChildren().contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void updatePage() {
        if (!this.m_saving) {
            for (PropertyInfo property : this.m_properties) {
                property.showValue();
            }
        }
    }

    protected Property getCustomProperty(Object object, String propertyName) throws Exception {
        return null;
    }

    protected ObjectInfo getEditObject() {
        return this.m_selection.get(0);
    }

    private static Property getReflectionProperty(Object object, String propertyName) {
        propertyName = StringUtils.capitalize((String)propertyName);
        Class<?> objectClass = object.getClass();
        String getName = "get" + propertyName;
        String setName = "set" + propertyName;
        Method getMethod = null;
        Method setMethod = null;
        Method[] methodArray = objectClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (getMethod == null && getName.equals(method.getName()) && method.getParameterTypes().length == 0) {
                getMethod = method;
                if (setMethod != null) {
                    break;
                }
            } else if (setMethod == null && setName.equals(method.getName()) && method.getParameterTypes().length == 1) {
                setMethod = method;
                if (getMethod != null) break;
            }
            ++n2;
        }
        if (getMethod != null && setMethod != null) {
            return new ReflectionProperty(getMethod, setMethod, object);
        }
        return null;
    }

    protected boolean add(PropertyInfo propertyInfo) {
        return this.m_properties.add(propertyInfo);
    }

    protected final Text addStringProperty(Composite parent, String property, String title) {
        new Label(parent, 0).setText(title);
        Text text = new Text(parent, 2048);
        GridDataFactory.create((Control)text).hintHC(10).fillH();
        StringPropertyInfo propertyInfo = new StringPropertyInfo(property, text);
        this.add(propertyInfo);
        return text;
    }

    protected final Text addStringProperty(Composite parent, String property) {
        return this.addStringProperty(parent, property, property);
    }

    protected final Button addBooleanProperty(Composite parent, String property, String title) {
        Button button = new Button(parent, 32);
        button.setText(title);
        BooleanPropertyInfo propertyInfo = new BooleanPropertyInfo(property, button);
        this.add(propertyInfo);
        return button;
    }

    protected final Button addBooleanProperty(Composite parent, String property) {
        return this.addBooleanProperty(parent, property, property);
    }

    protected final Group addBooleanProperties(Composite parent, String title, String[][] propertyAndTitleArray) {
        Group group = new Group(parent, 0);
        GridLayoutFactory.create((Composite)group);
        group.setText(title);
        int i = 0;
        while (i < propertyAndTitleArray.length) {
            String[] propertyAndTitle = propertyAndTitleArray[i];
            Button button = this.addBooleanProperty((Composite)group, propertyAndTitle[0], propertyAndTitle[1]);
            GridDataFactory.create((Control)button).fillH();
            ++i;
        }
        return group;
    }

    protected final Group addBooleanProperties(Composite parent, String title, String[] propertyArray) {
        Group group = new Group(parent, 0);
        GridLayoutFactory.create((Composite)group);
        group.setText(title);
        int i = 0;
        while (i < propertyArray.length) {
            String property = propertyArray[i];
            Button button = this.addBooleanProperty((Composite)group, property);
            GridDataFactory.create((Control)button).fillH();
            ++i;
        }
        return group;
    }

    protected final Group addChoiceProperty(Composite parent, String property, String title, Object[][] titleAndValueArray) {
        Group group = new Group(parent, 0);
        group.setText(title);
        GridLayoutFactory.create((Composite)group);
        ChoicePropertyInfo propertyInfo = new ChoicePropertyInfo(property);
        this.add(propertyInfo);
        int i = 0;
        while (i < titleAndValueArray.length) {
            Button trueButton = new Button((Composite)group, 16);
            GridDataFactory.create((Control)trueButton).fillH();
            Object[] titleAndValue = titleAndValueArray[i];
            String buttonTitle = (String)titleAndValue[0];
            Object value = titleAndValue[1];
            trueButton.setText(buttonTitle);
            propertyInfo.addButton(trueButton, value);
            ++i;
        }
        return group;
    }

    protected final Group addEnumProperty(Composite parent, String property, String title, String enumClassName) {
        ClassLoader classLoader = GlobalState.getClassLoader();
        try {
            Object[][] titleAndValueArray;
            Class<?> enumClass = classLoader.loadClass(enumClassName);
            if (enumClass.isEnum()) {
                Enum[] constants = (Enum[])enumClass.getEnumConstants();
                titleAndValueArray = new Object[constants.length][2];
                int i = 0;
                while (i < constants.length) {
                    Enum constantValue = constants[i];
                    titleAndValueArray[i][0] = constantValue.name();
                    titleAndValueArray[i][1] = constantValue;
                    ++i;
                }
            } else {
                titleAndValueArray = new Object[][]{new Object[0]};
            }
            return this.addChoiceProperty(parent, property, title, titleAndValueArray);
        }
        catch (ClassNotFoundException e) {
            DesignerPlugin.log(e);
            return new Group(parent, 0);
        }
    }

    protected final Group addStaticFieldsProperty(Composite parent, String property, String title, String className, String[] fieldNames) {
        Object[][] titleAndValueArray = new Object[fieldNames.length][2];
        ClassLoader classLoader = GlobalState.getClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(className);
            int i = 0;
            while (i < fieldNames.length) {
                titleAndValueArray[i][0] = fieldNames[i];
                titleAndValueArray[i][1] = ReflectionUtils.getFieldObject(clazz, fieldNames[i]);
                ++i;
            }
            return this.addChoiceProperty(parent, property, title, titleAndValueArray);
        }
        catch (ClassNotFoundException e) {
            DesignerPlugin.log(e);
            return new Group(parent, 0);
        }
    }

    protected final void addIntegerProperty(Composite parent, String property, String title, int minValue, int maxValue) {
        new Label(parent, 0).setText(title);
        CSpinner spinner = new CSpinner(parent, 2048);
        GridDataFactory.create((Control)spinner).hintHC(10);
        spinner.setMinimum(minValue);
        spinner.setMaximum(maxValue);
        IntegerPropertyInfo propertyInfo = new IntegerPropertyInfo(property, spinner);
        this.add(propertyInfo);
    }

    protected final void addIntegerProperty(Composite parent, String property, String title, int minValue) {
        this.addIntegerProperty(parent, property, title, minValue, Integer.MAX_VALUE);
    }

    protected final void addIntegerProperty(Composite parent, String property, String title) {
        this.addIntegerProperty(parent, property, title, 0);
    }

    protected final void addIntegerProperty(Composite parent, String property) {
        this.addIntegerProperty(parent, property, property);
    }

    protected final void addIntegerProperties(Composite parent, String[][] propertyAndTitleArray) {
        int i = 0;
        while (i < propertyAndTitleArray.length) {
            String[] propertyAndTitle = propertyAndTitleArray[i];
            this.addIntegerProperty(parent, propertyAndTitle[0], propertyAndTitle[1]);
            ++i;
        }
    }

    protected final Group addIntegerProperties(Composite parent, String title, String[][] propertyAndTitleArray) {
        Group group = new Group(parent, 0);
        group.setText(title);
        GridLayoutFactory.create((Composite)group).columns(2);
        int i = 0;
        while (i < propertyAndTitleArray.length) {
            String[] propertyAndTitle = propertyAndTitleArray[i];
            this.addIntegerProperty((Composite)group, propertyAndTitle[0], propertyAndTitle[1]);
            ++i;
        }
        return group;
    }

    protected final Group addIntegerProperties(Composite parent, String title, String[][] propertyAndTitleArray, int[] minumunValues) {
        Group group = new Group(parent, 0);
        group.setText(title);
        GridLayoutFactory.create((Composite)group).columns(2);
        int i = 0;
        while (i < propertyAndTitleArray.length) {
            String[] propertyAndTitle = propertyAndTitleArray[i];
            this.addIntegerProperty((Composite)group, propertyAndTitle[0], propertyAndTitle[1], minumunValues[i]);
            ++i;
        }
        return group;
    }

    protected final void addDoubleProperty(Composite parent, String property, String title, double minValue, double maxValue, int digits) {
        int multiplier = (int)Math.pow(10.0, digits);
        new Label(parent, 0).setText(title);
        CSpinner spinner = new CSpinner(parent, 2048);
        GridDataFactory.create((Control)spinner).hintHC(10);
        spinner.setMinimum((int)(minValue * (double)multiplier));
        spinner.setMaximum((int)(maxValue * (double)multiplier));
        spinner.setDigits(digits);
        DoublePropertyInfo propertyInfo = new DoublePropertyInfo(property, spinner, multiplier);
        this.add(propertyInfo);
    }

    protected final void addDoubleProperty(Composite parent, String property, String title, double minValue) {
        this.addDoubleProperty(parent, property, title, minValue, Double.MAX_VALUE, 1);
    }

    protected final void addDoubleProperty(Composite parent, String property, String title) {
        this.addDoubleProperty(parent, property, title, 0.0);
    }

    protected final void addDoubleProperty(Composite parent, String property) {
        this.addDoubleProperty(parent, property, property, 0.0);
    }

    protected final void addDoubleProperties(Composite parent, String[][] propertyAndTitleArray) {
        int i = 0;
        while (i < propertyAndTitleArray.length) {
            String[] propertyAndTitle = propertyAndTitleArray[i];
            this.addDoubleProperty(parent, propertyAndTitle[0], propertyAndTitle[1]);
            ++i;
        }
    }

    protected final Group addDoubleProperties(Composite parent, String title, String[][] propertyAndTitleArray) {
        Group group = new Group(parent, 0);
        group.setText(title);
        GridLayoutFactory.create((Composite)group).columns(2);
        int i = 0;
        while (i < propertyAndTitleArray.length) {
            String[] propertyAndTitle = propertyAndTitleArray[i];
            this.addDoubleProperty((Composite)group, propertyAndTitle[0], propertyAndTitle[1]);
            ++i;
        }
        return group;
    }

    protected final Group addDoubleProperties(Composite parent, String title, String[][] propertyAndTitleArray, double[] minumunValues) {
        Group group = new Group(parent, 0);
        group.setText(title);
        GridLayoutFactory.create((Composite)group).columns(2);
        int i = 0;
        while (i < propertyAndTitleArray.length) {
            String[] propertyAndTitle = propertyAndTitleArray[i];
            this.addDoubleProperty((Composite)group, propertyAndTitle[0], propertyAndTitle[1], minumunValues[i]);
            ++i;
        }
        return group;
    }

    protected final Label addFiller(Composite parent) {
        return new Label(parent, 0);
    }

    static /* synthetic */ Object access$0() {
        return NO_VALUE;
    }

    private final class BooleanPropertyInfo
    extends PropertyInfo {
        private final Button m_button;

        public BooleanPropertyInfo(String property, Button button) {
            super(property);
            this.m_button = button;
            this.m_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BooleanPropertyInfo.this.saveValue();
                }
            });
        }

        @Override
        public void showValue() {
            Object value = this.getValue();
            if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                this.m_button.setSelection(boolValue.booleanValue());
            } else {
                this.m_button.setSelection(false);
            }
        }

        @Override
        protected void doSaveValue() {
            this.setValue(this.m_button.getSelection());
        }
    }

    private final class ChoicePropertyInfo
    extends PropertyInfo {
        private final List<Button> m_buttons;
        private final Listener m_listener;

        public ChoicePropertyInfo(String property) {
            super(property);
            this.m_buttons = new ArrayList<Button>();
            this.m_listener = new Listener(){

                public void handleEvent(Event event) {
                    ChoicePropertyInfo.this.saveValue();
                }
            };
        }

        public void addButton(Button button, Object value) {
            button.setData(value);
            button.addListener(13, this.m_listener);
            this.m_buttons.add(button);
        }

        @Override
        public void showValue() {
            Object value = this.getValue();
            for (Button button : this.m_buttons) {
                Object buttonValue = button.getData();
                button.setSelection(ObjectUtils.equals((Object)value, (Object)buttonValue));
            }
        }

        @Override
        protected void doSaveValue() {
            for (Button button : this.m_buttons) {
                if (!button.getSelection()) continue;
                Object buttonValue = button.getData();
                this.setValue(buttonValue);
            }
        }
    }

    private final class DoublePropertyInfo
    extends PropertyInfo {
        private final CSpinner m_spinner;
        private final double m_multiplier;
        private final Listener m_listener;

        public DoublePropertyInfo(String property, CSpinner spinner, double multiplier) {
            super(property);
            this.m_listener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.doit) {
                        DoublePropertyInfo.this.saveValue();
                    }
                }
            };
            this.m_spinner = spinner;
            this.m_multiplier = multiplier;
            new CSpinnerDeferredNotifier(this.m_spinner, 500, this.m_listener);
        }

        @Override
        public void showValue() {
            Object value = this.getValue();
            if (value instanceof Number) {
                Number numberValue = (Number)value;
                this.m_spinner.setSelection((int)(numberValue.doubleValue() * this.m_multiplier));
            } else {
                this.m_spinner.setSelection(this.m_spinner.getMinimum());
            }
        }

        @Override
        protected void doSaveValue() {
            this.setValue((double)this.m_spinner.getSelection() / this.m_multiplier);
        }
    }

    private final class IntegerPropertyInfo
    extends PropertyInfo {
        private final CSpinner m_spinner;
        private final Listener m_listener;

        public IntegerPropertyInfo(String property, CSpinner spinner) {
            super(property);
            this.m_listener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.doit) {
                        IntegerPropertyInfo.this.saveValue();
                    }
                }
            };
            this.m_spinner = spinner;
            new CSpinnerDeferredNotifier(this.m_spinner, 500, this.m_listener);
        }

        @Override
        public void showValue() {
            Object value = this.getValue();
            if (value instanceof Integer) {
                Integer intValue = (Integer)value;
                this.m_spinner.setSelection(intValue);
            } else {
                this.m_spinner.setSelection(this.m_spinner.getMinimum());
            }
        }

        @Override
        protected void doSaveValue() {
            this.setValue(this.m_spinner.getSelection());
        }
    }

    protected static abstract class InternalProperty
    extends Property {
        public InternalProperty() {
            super(null);
        }

        @Override
        public String getTitle() {
            return null;
        }

        @Override
        public boolean isModified() throws Exception {
            return false;
        }
    }

    protected abstract class PropertyInfo {
        private final String m_property;
        private final String m_subProperty;
        private final String m_innerProperty;
        private List<Property> m_propertyList;
        private Object m_currentValue = Property.UNKNOWN_VALUE;

        public PropertyInfo(String property) {
            String[] parts = StringUtils.split((String)property, (char)'.');
            this.m_subProperty = parts.length == 2 ? parts[1] : null;
            parts = StringUtils.split((String)parts[0], (char)':');
            this.m_innerProperty = parts.length == 2 ? parts[1] : null;
            this.m_property = parts[0];
        }

        public abstract void showValue();

        protected abstract void doSaveValue();

        protected final void saveValue() {
            try {
                AbstractAssistantPage.this.m_saving = true;
                this.doSaveValue();
            }
            finally {
                AbstractAssistantPage.this.m_saving = false;
            }
        }

        protected final Object getValue() {
            this.prepareProperties();
            this.m_currentValue = ExecutionUtils.runObjectLog(() -> {
                Object commonValue = NO_VALUE;
                for (Property property : this.m_propertyList) {
                    Object value = property.getValue();
                    if (commonValue == NO_VALUE) {
                        commonValue = value;
                        continue;
                    }
                    if (ObjectUtils.equals((Object)commonValue, (Object)value)) continue;
                    return Property.UNKNOWN_VALUE;
                }
                return commonValue;
            }, null);
            return this.m_currentValue;
        }

        protected final void setValue(final Object value) {
            this.prepareProperties();
            if (this.m_currentValue != Property.UNKNOWN_VALUE && ObjectUtils.equals((Object)this.m_currentValue, (Object)value)) {
                return;
            }
            this.m_currentValue = value;
            ObjectInfo firstObject = AbstractAssistantPage.this.getEditObject();
            ExecutionUtils.run(firstObject, new RunnableEx(){

                @Override
                public void run() throws Exception {
                    for (Property property : PropertyInfo.this.m_propertyList) {
                        property.setValue(value);
                    }
                }
            });
        }

        private void prepareProperties() {
            if (this.m_propertyList == null) {
                this.m_propertyList = new ArrayList<Property>();
                ExecutionUtils.runLog(new RunnableEx(){

                    @Override
                    public void run() throws Exception {
                        Property property;
                        for (ObjectInfo object : ((PropertyInfo)PropertyInfo.this).AbstractAssistantPage.this.m_selection) {
                            property = object.getPropertyByTitle(PropertyInfo.this.m_property);
                            if (property == null) {
                                property = AbstractAssistantPage.getReflectionProperty(object, PropertyInfo.this.m_property);
                            }
                            if (property == null) {
                                property = AbstractAssistantPage.this.getCustomProperty(object, PropertyInfo.this.m_property);
                            }
                            if (property == null) continue;
                            PropertyInfo.this.m_propertyList.add(property);
                        }
                        if (PropertyInfo.this.m_innerProperty != null) {
                            int size = PropertyInfo.this.m_propertyList.size();
                            int i = 0;
                            while (i < size) {
                                property = PropertyInfo.this.m_propertyList.get(i);
                                IComplexPropertyEditor editor = (IComplexPropertyEditor)((Object)property.getEditor());
                                Property[] propertyArray = editor.getProperties(property);
                                int n = propertyArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Property innerProperty = propertyArray[n2];
                                    if (PropertyInfo.this.m_innerProperty.equals(innerProperty.getTitle())) {
                                        PropertyInfo.this.m_propertyList.set(i, innerProperty);
                                    }
                                    ++n2;
                                }
                                ++i;
                            }
                        }
                        if (PropertyInfo.this.m_subProperty != null) {
                            int size = PropertyInfo.this.m_propertyList.size();
                            int i = 0;
                            while (i < size) {
                                property = PropertyInfo.this.m_propertyList.get(i);
                                PropertyInfo.this.m_propertyList.set(i, new SubFieldProperty(PropertyInfo.this.m_subProperty, property));
                                ++i;
                            }
                        }
                    }
                });
            }
        }
    }

    private static final class ReflectionProperty
    extends InternalProperty {
        private final Method m_getMethod;
        private final Method m_setMethod;
        private final Object m_thisObject;

        public ReflectionProperty(Method getMethod, Method setMethod, Object thisObject) {
            this.m_getMethod = getMethod;
            this.m_setMethod = setMethod;
            this.m_thisObject = thisObject;
        }

        @Override
        public Object getValue() throws Exception {
            return this.m_getMethod.invoke(this.m_thisObject, new Object[0]);
        }

        @Override
        public void setValue(Object value) throws Exception {
            this.m_setMethod.invoke(this.m_thisObject, value);
        }
    }

    private final class StringPropertyInfo
    extends PropertyInfo {
        private final Text m_text;
        private boolean m_enableListener;

        public StringPropertyInfo(String property, Text text) {
            super(property);
            this.m_text = text;
            this.m_enableListener = true;
            this.m_text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (StringPropertyInfo.this.m_enableListener) {
                        StringPropertyInfo.this.saveValue();
                    }
                }
            });
        }

        @Override
        public void showValue() {
            try {
                this.m_enableListener = false;
                Object value = this.getValue();
                if (value instanceof String) {
                    this.m_text.setText((String)value);
                } else {
                    this.m_text.setText("");
                }
            }
            finally {
                this.m_enableListener = true;
            }
        }

        @Override
        protected void doSaveValue() {
            this.setValue(this.m_text.getText());
        }
    }

    private static final class SubFieldProperty
    extends InternalProperty {
        private final String m_field;
        private final Property m_property;

        public SubFieldProperty(String field, Property property) {
            this.m_field = field;
            this.m_property = property;
        }

        @Override
        public Object getValue() throws Exception {
            Object mainValue = this.m_property.getValue();
            return ReflectionUtils.getFieldObject(mainValue, this.m_field);
        }

        @Override
        public void setValue(Object value) throws Exception {
            Object mainValue = this.m_property.getValue();
            ReflectionUtils.setField(mainValue, this.m_field, value);
            this.m_property.setValue(mainValue);
        }
    }
}

