/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.resource;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescriptionJava;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.RcpToolkitDescription;
import org.eclipse.wb.internal.swt.model.widgets.ButtonInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.utils.ManagerUtils;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class ResourceManagerTest
extends RcpModelTest {
    @Override
    protected void configureNewProject() throws Exception {
        ResourceManagerTest.setFileContentSrc("testplugin/Activator.java", ResourceManagerTest.getSourceDQ("package testplugin;", "import org.eclipse.ui.plugin.AbstractUIPlugin;", "public class Activator extends AbstractUIPlugin {", "  public Activator() {", "  }", "  public static Activator getDefault() {", "    return null;", "  }", "}"));
        ((List)ReflectionUtils.getFieldObject((Object)((Object)this), (String)"m_createdResources")).clear();
        ResourceManagerTest.waitForAutoBuild();
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null, "testplugin.Activator");
        ToolkitDescriptionJava toolKit = RcpToolkitDescription.INSTANCE;
        ManagerUtils.ensure_ResourceManager((IJavaProject)m_javaProject, (ToolkitDescription)toolKit);
    }

    @Test
    public void test_0() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ManagerUtils.ensure_ResourceManager((JavaInfo)shell);
    }

    @Test
    public void test_getPluginImage_StringString() throws Exception {
        this.ensureFolderExists("icons");
        TestUtils.createImagePNG(m_testProject, "icons/1.png", 10, 20);
        ResourceManagerTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private Button button;", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "    {", "      button = new Button(this, SWT.NONE);", "      button.setImage(org.eclipse.wb.swt.ResourceManager.getPluginImage('TestProject', 'icons/1.png'));", "    }", "  }", "  public Button getButton() {", "    return button;", "  }", "}"));
        ResourceManagerTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        CompositeInfo myComposite = (CompositeInfo)shell.getChildrenControls().get(0);
        ButtonInfo button = (ButtonInfo)myComposite.getChildrenControls().get(0);
        Image image = button.getWidget().getImage();
        ResourceManagerTest.assertNotNull((Object)image);
        ResourceManagerTest.assertEquals((long)10L, (long)image.getBounds().width);
        ResourceManagerTest.assertEquals((long)20L, (long)image.getBounds().height);
    }

    @Test
    public void test_getPluginImage_ObjectString() throws Exception {
        this.ensureFolderExists("icons");
        TestUtils.createImagePNG(m_testProject, "icons/2.png", 10, 20);
        ResourceManagerTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("import testplugin.Activator;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setImage(org.eclipse.wb.swt.ResourceManager.getPluginImage(Activator.getDefault(), 'icons/2.png'));", "    }", "  }", "}");
        shell.refresh();
        ButtonInfo button = (ButtonInfo)shell.getChildrenControls().get(0);
        Property property = button.getPropertyByTitle("image");
        ResourceManagerTest.assertTrue((boolean)property.isModified());
        ResourceManagerTest.assertEquals((Object)"Plugin: TestProject icons/2.png", (Object)ResourceManagerTest.getPropertyText(property));
        Image image = button.getWidget().getImage();
        ResourceManagerTest.assertNotNull((Object)image);
        ResourceManagerTest.assertEquals((long)10L, (long)image.getBounds().width);
        ResourceManagerTest.assertEquals((long)20L, (long)image.getBounds().height);
    }
}

