/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util;

import java.lang.reflect.Field;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.ICoreExceptionConstants;
import org.junit.Assert;
import org.junit.Test;

public class DesignerExceptionTest
extends Assert {
    private static final int CODE = 12345;
    private static final String PARAMETER_0 = "a";
    private static final String PARAMETER_1 = "b";

    @Test
    public void test_1() {
        DesignerException designerException = new DesignerException(12345, new String[]{PARAMETER_0});
        DesignerExceptionTest.assertEquals((long)12345L, (long)designerException.getCode());
        Object[] parameters = designerException.getParameters();
        Assertions.assertThat((Object[])parameters).hasSize(1);
        DesignerExceptionTest.assertSame((Object)PARAMETER_0, (Object)parameters[0]);
    }

    @Test
    public void test_2() {
        DesignerException designerException = new DesignerException(12345, new String[]{PARAMETER_0, PARAMETER_1});
        DesignerExceptionTest.assertEquals((long)12345L, (long)designerException.getCode());
        Object[] parameters = designerException.getParameters();
        Assertions.assertThat((Object[])parameters).hasSize(2);
        DesignerExceptionTest.assertSame((Object)PARAMETER_0, (Object)parameters[0]);
        DesignerExceptionTest.assertSame((Object)PARAMETER_1, (Object)parameters[1]);
    }

    @Test
    public void test_all() {
        Exception cause = new Exception();
        DesignerException designerException = new DesignerException(12345, (Throwable)cause, new String[]{PARAMETER_0});
        DesignerExceptionTest.assertEquals((long)12345L, (long)designerException.getCode());
        DesignerExceptionTest.assertSame((Object)cause, (Object)designerException.getCause());
        Object[] parameters = designerException.getParameters();
        Assertions.assertThat((Object[])parameters).hasSize(1);
        DesignerExceptionTest.assertSame((Object)PARAMETER_0, (Object)parameters[0]);
    }

    @Test
    public void test_setSourcePosition() {
        DesignerException designerException = new DesignerException(12345, new String[0]);
        DesignerExceptionTest.assertEquals((long)-1L, (long)designerException.getSourcePosition());
        int expectedPosition = 5;
        designerException.setSourcePosition(expectedPosition);
        DesignerExceptionTest.assertEquals((long)expectedPosition, (long)designerException.getSourcePosition());
    }

    @Test
    public void test_ICoreExceptionConstants() throws Exception {
        Field wrapperField = ICoreExceptionConstants.class.getField("UNEXPECTED");
        DesignerExceptionTest.assertEquals((long)1L, (long)wrapperField.getInt(null));
    }

    @Test
    public void test_getMessage_useTitle_knownCode() {
        DesignerException designerException = new DesignerException(1, new String[0]);
        DesignerExceptionTest.assertEquals((Object)"1 (Internal Error).", (Object)designerException.getMessage());
    }

    @Test
    public void test_getMessage_useTitle_knownCode_withParameters() {
        DesignerException designerException = new DesignerException(1, new String[]{"A", "BB"});
        DesignerExceptionTest.assertEquals((Object)"1 (Internal Error). A BB", (Object)designerException.getMessage());
    }

    @Test
    public void test_getMessage_useTitle_unknownCode() {
        DesignerException designerException = new DesignerException(-1000, new String[0]);
        DesignerExceptionTest.assertEquals((Object)"-1000 (No description).", (Object)designerException.getMessage());
    }
}

