/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jsf.context.structureddocument.internal.provisional.IStructuredDocumentContext;
import org.eclipse.jst.jsf.core.internal.types.CompositeType;
import org.eclipse.jst.jsf.core.internal.types.SignatureBasedType;
import org.eclipse.jst.jsf.validation.internal.el.ASTSemanticValidator;
import org.eclipse.jst.jsf.validation.internal.el.MyLocalizedMessage;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.ParseException;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.jst.jsp.core.internal.java.jspel.TokenMgrError;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ELExpressionValidator {
    private final IStructuredDocumentContext _context;
    private final String _elText;
    private final IFile _file;
    private final List _syntaxProblems;
    private ASTSemanticValidator _semanticValidator;

    public ELExpressionValidator(IStructuredDocumentContext context, String elText, IFile file) {
        this._context = context;
        this._elText = elText;
        this._file = file;
        this._syntaxProblems = new ArrayList();
    }

    public ASTExpression validateXMLNode() {
        JSPELParser elParser = JSPELParser.createParser((String)this._elText);
        try {
            ASTExpression expr = elParser.Expression();
            this.validateSemantics(expr, this._context);
            if (expr.getLastToken().endColumn < this._elText.trim().length() - 1) {
                int problemStartOffset = this._context.getDocumentPosition() + expr.getLastToken().endColumn;
                MyLocalizedMessage message = new MyLocalizedMessage(2, JSPCoreMessages.JSPEL_Syntax, 3);
                message.setOffset(problemStartOffset);
                message.setLength(this._elText.trim().length() - expr.getLastToken().endColumn);
                message.setTargetObject(this._file);
                this._syntaxProblems.add(message);
            }
            return expr;
        }
        catch (ParseException e) {
            Token curTok = e.currentToken;
            int problemStartOffset = this._context.getDocumentPosition() + curTok.beginColumn;
            MyLocalizedMessage message = new MyLocalizedMessage(2, JSPCoreMessages.JSPEL_Syntax, 3);
            message.setOffset(problemStartOffset);
            message.setLength(curTok.endColumn - curTok.beginColumn + 1);
            message.setTargetObject(this._file);
            this._syntaxProblems.add(message);
            return null;
        }
        catch (TokenMgrError tokenMgrError) {
            MyLocalizedMessage message = new MyLocalizedMessage(2, JSPCoreMessages.JSPEL_Token, 3);
            message.setOffset(this._context.getDocumentPosition());
            message.setLength(this._elText.length());
            message.setTargetObject(this._file);
            this._syntaxProblems.add(message);
            return null;
        }
    }

    public void reportFindings(IValidator validator, IReporter reporter) {
        Iterator it = this._syntaxProblems.iterator();
        while (it.hasNext()) {
            IMessage message = (IMessage)it.next();
            reporter.addMessage(validator, message);
        }
        if (this._semanticValidator != null) {
            this._semanticValidator.reportFindings(validator, reporter);
        }
    }

    public CompositeType getExpressionType() {
        SignatureBasedType type;
        if (this._semanticValidator != null && (type = this._semanticValidator.getExpressionType()) != null) {
            return type.toCompositeType();
        }
        return null;
    }

    private void validateSemantics(ASTExpression expr, IStructuredDocumentContext context) {
        this._semanticValidator = new ASTSemanticValidator(expr, context);
        this._semanticValidator.validate();
    }
}

