/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.contentassist.internal.el;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.jst.jsf.contentassist.internal.el.ContentAssistStrategy;
import org.eclipse.jst.jsf.contentassist.internal.el.FunctionCompletionStrategy;
import org.eclipse.jst.jsf.contentassist.internal.el.IdCompletionStrategy;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAddExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAndExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTChoiceExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTEqualityExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTFunctionInvocation;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTLiteral;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTMultiplyExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTOrExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTRelationalExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTUnaryExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValue;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValuePrefix;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValueSuffix;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParserVisitor;
import org.eclipse.jst.jsp.core.internal.java.jspel.ParseException;
import org.eclipse.jst.jsp.core.internal.java.jspel.SimpleNode;

public final class ContentAssistParser {
    public static ContentAssistStrategy getPrefix(int relativePosition, String elText) {
        if (elText == null) {
            return null;
        }
        if ("".equals(elText.trim())) {
            return new IdCompletionStrategy("");
        }
        StringReader reader = new StringReader(elText);
        JSPELParser parser = new JSPELParser((Reader)reader);
        try {
            ASTExpression expr = parser.Expression();
            PrefixVisitor visitor = new PrefixVisitor(relativePosition, elText);
            expr.jjtAccept((JSPELParserVisitor)visitor, null);
            return visitor.getPrefix();
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private ContentAssistParser() {
    }

    private static class PrefixVisitor
    implements JSPELParserVisitor {
        private final int _relativePos;
        private final String _fullText;
        private String _curPrefix;
        private int _prefixType;
        private boolean _prefixResolved;

        PrefixVisitor(int relativePos, String fullText) {
            this._relativePos = relativePos;
            this._fullText = fullText;
        }

        public ContentAssistStrategy getPrefix() {
            if (this._prefixResolved) {
                switch (this._prefixType) {
                    case 0: {
                        return new FunctionCompletionStrategy(this._curPrefix);
                    }
                    case 1: {
                        return new IdCompletionStrategy(this._curPrefix);
                    }
                    case 2: {
                        return new IdCompletionStrategy("");
                    }
                }
            }
            return null;
        }

        public Object visit(ASTAddExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTAndExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTChoiceExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTEqualityExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTFunctionInvocation node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTLiteral node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTMultiplyExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTOrExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTRelationalExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTUnaryExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTValue node, Object data) {
            if (this.testContainsCursor((SimpleNode)node)) {
                return node.childrenAccept((JSPELParserVisitor)this, data);
            }
            return null;
        }

        public Object visit(ASTValuePrefix node, Object data) {
            if (!this._prefixResolved && node.jjtGetNumChildren() == 0 && node.getFirstToken().kind == 47) {
                this._curPrefix = node.getFirstToken().image;
                if (this.testContainsCursor((SimpleNode)node)) {
                    this._prefixType = 1;
                    this._prefixResolved = true;
                }
            }
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTValueSuffix node, Object data) {
            if (node.jjtGetNumChildren() == 0) {
                if (!this._prefixResolved && node.getFirstToken().kind == 13) {
                    if (node.getLastToken().kind == 47) {
                        if (this.testContainsCursor((SimpleNode)node)) {
                            this._prefixType = 0;
                            this._prefixResolved = true;
                        } else {
                            this._curPrefix = String.valueOf(this._curPrefix) + node.getFirstToken().image + node.getLastToken().image;
                        }
                    } else if (node.getLastToken() == node.getFirstToken() && this.testCursorImmediatelyAfter((SimpleNode)node)) {
                        this._prefixType = 0;
                        this._prefixResolved = true;
                    }
                }
                return null;
            }
            Object retValue = node.childrenAccept((JSPELParserVisitor)this, data);
            if (!this._prefixResolved) {
                this._curPrefix = String.valueOf(this._curPrefix) + this._fullText.substring(node.getFirstToken().beginColumn - 1, node.getLastToken().endColumn);
            }
            return retValue;
        }

        public Object visit(SimpleNode node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        private boolean testCursorImmediatelyAfter(SimpleNode node) {
            return node.getLastToken().endColumn == this._relativePos - 1;
        }

        private boolean testContainsCursor(SimpleNode node) {
            return node.getFirstToken().beginColumn <= this._relativePos && node.getLastToken().endColumn + 1 >= this._relativePos;
        }
    }
}

