/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.section;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.jst.jsf.facesconfig.ui.section.IFacesConfigSection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public abstract class AbstractFacesConfigSection
extends SectionPart
implements IFacesConfigSection,
ISelectionProvider,
ISelectionChangedListener {
    private FormToolkit toolkit;
    private String helpContextId = null;
    private String helpTooltip = null;
    private Object input = null;
    private IFacesConfigPage page;
    private List selectionChangedListeners = new ArrayList();
    private static final Image HELP_IMAGE = EditorPlugin.getDefault().getImage("help.gif");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AbstractFacesConfigSection(Composite parent, IManagedForm managedForm, IFacesConfigPage page, FormToolkit toolkit, String helpContextId, String helpTooltip) {
        super(parent, toolkit, 450);
        super.initialize(managedForm);
        this.page = page;
        this.toolkit = toolkit;
        this.helpContextId = helpContextId;
        this.helpTooltip = helpTooltip;
    }

    public void initialize() {
        if (this.helpContextId != null) {
            this.createTextClientWithHelp();
        }
        this.getSection().setLayout((Layout)new GridLayout());
        Composite clientContainer = this.toolkit.createComposite((Composite)this.getSection());
        GridData gd = new GridData(1808);
        clientContainer.setLayoutData((Object)gd);
        this.createContents(clientContainer, this.toolkit);
        this.getSection().setClient((Control)clientContainer);
    }

    private void createTextClientWithHelp() {
        ImageHyperlink helpImage = new ImageHyperlink((Composite)this.getSection(), 0);
        this.toolkit.adapt((Control)helpImage, true, true);
        helpImage.setImage(HELP_IMAGE);
        helpImage.setBackground(this.getSection().getTitleBarGradientBackground());
        if (this.helpTooltip != null) {
            helpImage.setToolTipText(this.helpTooltip);
        }
        helpImage.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IContext context = HelpSystem.getContext((String)AbstractFacesConfigSection.this.helpContextId);
                if (context != null) {
                    IHelpResource[] topics = context.getRelatedTopics();
                    if (topics != null && topics.length == 1) {
                        EditorPlugin.getDefault().getWorkbench().getHelpSystem().displayHelpResource(topics[0].getHref());
                    } else {
                        EditorPlugin.getDefault().getWorkbench().getHelpSystem().displayHelp(AbstractFacesConfigSection.this.helpContextId);
                    }
                }
            }
        });
        this.getSection().setTextClient((Control)helpImage);
    }

    protected abstract void createContents(Composite var1, FormToolkit var2);

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object newInput) {
        if (this.input != null) {
            this.removeAdaptersFromInput(this.input);
        }
        this.input = newInput;
        if (newInput != null) {
            this.addAdaptersOntoInput(newInput);
        }
        this.refreshAll();
    }

    protected void removeAdaptersFromInput(Object oldInput) {
    }

    protected void addAdaptersOntoInput(Object newInput) {
    }

    public IFacesConfigPage getPage() {
        return this.page;
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Iterator listeners = this.selectionChangedListeners.iterator();
        while (listeners.hasNext()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners.next();
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)(event != null ? event.getSelection() : StructuredSelection.EMPTY)));
        }
    }

    public AdapterFactory getAdapterFactory() {
        FormEditor formEditor = this.getPage().getEditor();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.common.notify.AdapterFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AdapterFactory)formEditor.getAdapter((Class)clazz);
    }

    public EditingDomain getEditingDomain() {
        FormEditor formEditor = this.getPage().getEditor();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.edit.domain.EditingDomain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (EditingDomain)formEditor.getAdapter((Class)clazz);
    }
}

