/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.types;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.core.internal.types.CompositeType;

public class TypeTransformer {
    private static final Map boxConversions = new HashMap();
    private static final Map unBoxConversions = new HashMap();

    static {
        boxConversions.put("B", "Ljava.lang.Byte;");
        boxConversions.put("C", "Ljava.lang.Character;");
        boxConversions.put("D", "Ljava.lang.Double;");
        boxConversions.put("F", "Ljava.lang.Float;");
        boxConversions.put("I", "Ljava.lang.Integer;");
        boxConversions.put("J", "Ljava.lang.Long;");
        boxConversions.put("S", "Ljava.lang.Short;");
        boxConversions.put("Z", "Ljava.lang.Boolean;");
        boxConversions.put("V", "V");
        Iterator it = boxConversions.keySet().iterator();
        while (it.hasNext()) {
            String newValue = (String)it.next();
            String newKey = (String)boxConversions.get(newValue);
            if (unBoxConversions.put(newKey, newValue) != null) {
                throw new AssertionError((Object)"Duplicated boxing value");
            }
        }
    }

    public static CompositeType transformBoxPrimitives(CompositeType compositeType) {
        String[] signatures = compositeType.getSignatures();
        String[] newsignatures = new String[signatures.length];
        int i = 0;
        while (i < signatures.length) {
            newsignatures[i] = TypeTransformer.transformBoxPrimitives(signatures[i]);
            ++i;
        }
        return new CompositeType(newsignatures, compositeType.getAssignmentTypeMask());
    }

    public static String transformBoxPrimitives(String curSignature) {
        String newSignature = curSignature;
        try {
            String baseType;
            int kind = Signature.getTypeSignatureKind((String)curSignature);
            if (kind == 2) {
                newSignature = (String)boxConversions.get(curSignature);
            } else if (kind == 4 && Signature.getTypeSignatureKind((String)(baseType = Signature.getElementType((String)curSignature))) == 2) {
                String newBaseType = (String)boxConversions.get(baseType);
                int numBraces = Signature.getArrayCount((String)curSignature);
                newSignature = "";
                int j = 0;
                while (j < numBraces) {
                    newSignature = String.valueOf(newSignature) + "[";
                    ++j;
                }
                newSignature = String.valueOf(newSignature) + newBaseType;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return newSignature;
    }

    public static CompositeType transformUnboxPrimitives(CompositeType compositeType) {
        String[] signatures = compositeType.getSignatures();
        String[] newsignatures = new String[signatures.length];
        int i = 0;
        while (i < signatures.length) {
            newsignatures[i] = TypeTransformer.transformUnboxPrimitives(signatures[i]);
            ++i;
        }
        return new CompositeType(newsignatures, compositeType.getAssignmentTypeMask());
    }

    public static String transformUnboxPrimitives(String typeSignature) {
        String newSignature = typeSignature;
        try {
            String newBaseTypeCandidate;
            String baseType;
            int kind = Signature.getTypeSignatureKind((String)typeSignature);
            if (kind == 1) {
                String checkForUnbox = (String)unBoxConversions.get(typeSignature);
                if (checkForUnbox != null) {
                    newSignature = checkForUnbox;
                }
            } else if (kind == 4 && Signature.getTypeSignatureKind((String)(baseType = Signature.getElementType((String)typeSignature))) == 1 && (newBaseTypeCandidate = (String)unBoxConversions.get(baseType)) != null) {
                int numBraces = Signature.getArrayCount((String)typeSignature);
                newSignature = "";
                int j = 0;
                while (j < numBraces) {
                    newSignature = String.valueOf(newSignature) + "[";
                    ++j;
                }
                newSignature = String.valueOf(newSignature) + newBaseTypeCandidate;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return newSignature;
    }

    public static void main(String[] args) {
        TypeTransformer.testBoxPrimitives();
        TypeTransformer.testUnboxPrimitives();
    }

    private static void testBoxPrimitives() {
        CompositeType type1 = new CompositeType("J", 2);
        CompositeType type2 = new CompositeType("I", 2);
        CompositeType type3 = new CompositeType("[J", 2);
        CompositeType type4 = new CompositeType("[[I", 2);
        System.out.println(TypeTransformer.transformBoxPrimitives(type1));
        System.out.println(TypeTransformer.transformBoxPrimitives(type2));
        System.out.println(TypeTransformer.transformBoxPrimitives(type3));
        System.out.println(TypeTransformer.transformBoxPrimitives(type4));
    }

    private static void testUnboxPrimitives() {
        CompositeType type1 = new CompositeType("Ljava.lang.Long;", 2);
        CompositeType type2 = new CompositeType("Ljava.lang.Integer;", 2);
        CompositeType type3 = new CompositeType("[Ljava.lang.Long;", 2);
        CompositeType type4 = new CompositeType("[[Ljava.lang.Integer;", 2);
        System.out.println(TypeTransformer.transformUnboxPrimitives(type1));
        System.out.println(TypeTransformer.transformUnboxPrimitives(type2));
        System.out.println(TypeTransformer.transformUnboxPrimitives(type3));
        System.out.println(TypeTransformer.transformUnboxPrimitives(type4));
    }
}

